/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateTaskRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTaskRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateTaskRequest.Builder, CreateTaskRequest> {
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationArn").getter(getter(CreateTaskRequest::sourceLocationArn))
            .setter(setter(Builder::sourceLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()).build();

    private static final SdkField<String> DESTINATION_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationLocationArn").getter(getter(CreateTaskRequest::destinationLocationArn))
            .setter(setter(Builder::destinationLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLocationArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(CreateTaskRequest::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(CreateTaskRequest::options)).setter(setter(Builder::options))
            .constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Excludes")
            .getter(getter(CreateTaskRequest::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.<TaskSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(CreateTaskRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(TaskSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Includes")
            .getter(getter(CreateTaskRequest::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ManifestConfig> MANIFEST_CONFIG_FIELD = SdkField
            .<ManifestConfig> builder(MarshallingType.SDK_POJO).memberName("ManifestConfig")
            .getter(getter(CreateTaskRequest::manifestConfig)).setter(setter(Builder::manifestConfig))
            .constructor(ManifestConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestConfig").build()).build();

    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField
            .<TaskReportConfig> builder(MarshallingType.SDK_POJO).memberName("TaskReportConfig")
            .getter(getter(CreateTaskRequest::taskReportConfig)).setter(setter(Builder::taskReportConfig))
            .constructor(TaskReportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_ARN_FIELD,
            DESTINATION_LOCATION_ARN_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, NAME_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD,
            SCHEDULE_FIELD, TAGS_FIELD, INCLUDES_FIELD, MANIFEST_CONFIG_FIELD, TASK_REPORT_CONFIG_FIELD));

    private final String sourceLocationArn;

    private final String destinationLocationArn;

    private final String cloudWatchLogGroupArn;

    private final String name;

    private final Options options;

    private final List<FilterRule> excludes;

    private final TaskSchedule schedule;

    private final List<TagListEntry> tags;

    private final List<FilterRule> includes;

    private final ManifestConfig manifestConfig;

    private final TaskReportConfig taskReportConfig;

    private CreateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.sourceLocationArn = builder.sourceLocationArn;
        this.destinationLocationArn = builder.destinationLocationArn;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.name = builder.name;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.tags = builder.tags;
        this.includes = builder.includes;
        this.manifestConfig = builder.manifestConfig;
        this.taskReportConfig = builder.taskReportConfig;
    }

    /**
     * <p>
     * Specifies the ARN of your transfer's source location.
     * </p>
     * 
     * @return Specifies the ARN of your transfer's source location.
     */
    public final String sourceLocationArn() {
        return sourceLocationArn;
    }

    /**
     * <p>
     * Specifies the ARN of your transfer's destination location.
     * </p>
     * 
     * @return Specifies the ARN of your transfer's destination location.
     */
    public final String destinationLocationArn() {
        return destinationLocationArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * <p>
     * Specifies the name of your task.
     * </p>
     * 
     * @return Specifies the name of your task.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
     * </p>
     * 
     * @return Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other
     *         options.
     */
    public final Options options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want
     * DataSync to transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by
     * using filters</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return Specifies exclude filters that define the files, objects, and folders in your source location that you
     *         don't want DataSync to transfer. For more information and examples, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
     *         transfers by using filters</a>.
     */
    public final List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * <p>
     * Specifies a schedule for when you want your task to run. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
     * </p>
     * 
     * @return Specifies a schedule for when you want your task to run. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your
     *         task</a>.
     */
    public final TaskSchedule schedule() {
        return schedule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags that you want to apply to your task.
     * </p>
     * <p>
     * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the tags that you want to apply to your task.</p>
     *         <p>
     *         <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies include filters define the files, objects, and folders in your source location that you want DataSync
     * to transfer. For more information and examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by
     * using filters</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return Specifies include filters define the files, objects, and folders in your source location that you want
     *         DataSync to transfer. For more information and examples, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
     *         transfers by using filters</a>.
     */
    public final List<FilterRule> includes() {
        return includes;
    }

    /**
     * <p>
     * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more
     * information and configuration examples, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
     * DataSync transfers by using a manifest</a>.
     * </p>
     * <p>
     * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
     * <code>iam:PassRole</code> permission. The <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
     * >AWSDataSyncFullAccess</a> policy includes this permission.
     * </p>
     * 
     * @return Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more
     *         information and configuration examples, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying
     *         what DataSync transfers by using a manifest</a>.</p>
     *         <p>
     *         When using this parameter, your caller identity (the role that you're using DataSync with) must have the
     *         <code>iam:PassRole</code> permission. The <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
     *         >AWSDataSyncFullAccess</a> policy includes this permission.
     */
    public final ManifestConfig manifestConfig() {
        return manifestConfig;
    }

    /**
     * <p>
     * Specifies how you want to configure a task report, which provides detailed information about your DataSync
     * transfer. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers
     * with task reports</a>.
     * </p>
     * <p>
     * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
     * <code>iam:PassRole</code> permission. The <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
     * >AWSDataSyncFullAccess</a> policy includes this permission.
     * </p>
     * 
     * @return Specifies how you want to configure a task report, which provides detailed information about your
     *         DataSync transfer. For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync
     *         transfers with task reports</a>.</p>
     *         <p>
     *         When using this parameter, your caller identity (the role that you're using DataSync with) must have the
     *         <code>iam:PassRole</code> permission. The <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
     *         >AWSDataSyncFullAccess</a> policy includes this permission.
     */
    public final TaskReportConfig taskReportConfig() {
        return taskReportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(manifestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(taskReportConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskRequest)) {
            return false;
        }
        CreateTaskRequest other = (CreateTaskRequest) obj;
        return Objects.equals(sourceLocationArn(), other.sourceLocationArn())
                && Objects.equals(destinationLocationArn(), other.destinationLocationArn())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(options(), other.options()) && hasExcludes() == other.hasExcludes()
                && Objects.equals(excludes(), other.excludes()) && Objects.equals(schedule(), other.schedule())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasIncludes() == other.hasIncludes()
                && Objects.equals(includes(), other.includes()) && Objects.equals(manifestConfig(), other.manifestConfig())
                && Objects.equals(taskReportConfig(), other.taskReportConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTaskRequest").add("SourceLocationArn", sourceLocationArn())
                .add("DestinationLocationArn", destinationLocationArn()).add("CloudWatchLogGroupArn", cloudWatchLogGroupArn())
                .add("Name", name()).add("Options", options()).add("Excludes", hasExcludes() ? excludes() : null)
                .add("Schedule", schedule()).add("Tags", hasTags() ? tags() : null)
                .add("Includes", hasIncludes() ? includes() : null).add("ManifestConfig", manifestConfig())
                .add("TaskReportConfig", taskReportConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceLocationArn":
            return Optional.ofNullable(clazz.cast(sourceLocationArn()));
        case "DestinationLocationArn":
            return Optional.ofNullable(clazz.cast(destinationLocationArn()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "ManifestConfig":
            return Optional.ofNullable(clazz.cast(manifestConfig()));
        case "TaskReportConfig":
            return Optional.ofNullable(clazz.cast(taskReportConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskRequest, T> g) {
        return obj -> g.apply((CreateTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTaskRequest> {
        /**
         * <p>
         * Specifies the ARN of your transfer's source location.
         * </p>
         * 
         * @param sourceLocationArn
         *        Specifies the ARN of your transfer's source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationArn(String sourceLocationArn);

        /**
         * <p>
         * Specifies the ARN of your transfer's destination location.
         * </p>
         * 
         * @param destinationLocationArn
         *        Specifies the ARN of your transfer's destination location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationLocationArn(String destinationLocationArn);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * Specifies the name of your task.
         * </p>
         * 
         * @param name
         *        Specifies the name of your task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other
         * options.
         * </p>
         * 
         * @param options
         *        Specifies your task's settings, such as preserving file metadata, verifying data integrity, among
         *        other options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * <p>
         * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other
         * options.
         * </p>
         * This is a convenience method that creates an instance of the {@link Options.Builder} avoiding the need to
         * create one manually via {@link Options#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't
         * want DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * 
         * @param excludes
         *        Specifies exclude filters that define the files, objects, and folders in your source location that you
         *        don't want DataSync to transfer. For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         *        transfers by using filters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't
         * want DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * 
         * @param excludes
         *        Specifies exclude filters that define the files, objects, and folders in your source location that you
         *        don't want DataSync to transfer. For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         *        transfers by using filters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't
         * want DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(java.util.Collection<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * Specifies a schedule for when you want your task to run. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
         * </p>
         * 
         * @param schedule
         *        Specifies a schedule for when you want your task to run. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your
         *        task</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(TaskSchedule schedule);

        /**
         * <p>
         * Specifies a schedule for when you want your task to run. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskSchedule.Builder} avoiding the need
         * to create one manually via {@link TaskSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(TaskSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link TaskSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(TaskSchedule)
         */
        default Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return schedule(TaskSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * Specifies the tags that you want to apply to your task.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * 
         * @param tags
         *        Specifies the tags that you want to apply to your task.</p>
         *        <p>
         *        <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies the tags that you want to apply to your task.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * 
         * @param tags
         *        Specifies the tags that you want to apply to your task.</p>
         *        <p>
         *        <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies the tags that you want to apply to your task.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * Specifies include filters define the files, objects, and folders in your source location that you want
         * DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * 
         * @param includes
         *        Specifies include filters define the files, objects, and folders in your source location that you want
         *        DataSync to transfer. For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         *        transfers by using filters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * Specifies include filters define the files, objects, and folders in your source location that you want
         * DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * 
         * @param includes
         *        Specifies include filters define the files, objects, and folders in your source location that you want
         *        DataSync to transfer. For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         *        transfers by using filters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * Specifies include filters define the files, objects, and folders in your source location that you want
         * DataSync to transfer. For more information and examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync
         * transfers by using filters</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(java.util.Collection<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        /**
         * <p>
         * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more
         * information and configuration examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
         * DataSync transfers by using a manifest</a>.
         * </p>
         * <p>
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
         * <code>iam:PassRole</code> permission. The <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         * >AWSDataSyncFullAccess</a> policy includes this permission.
         * </p>
         * 
         * @param manifestConfig
         *        Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For
         *        more information and configuration examples, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html"
         *        >Specifying what DataSync transfers by using a manifest</a>.</p>
         *        <p>
         *        When using this parameter, your caller identity (the role that you're using DataSync with) must have
         *        the <code>iam:PassRole</code> permission. The <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         *        >AWSDataSyncFullAccess</a> policy includes this permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestConfig(ManifestConfig manifestConfig);

        /**
         * <p>
         * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more
         * information and configuration examples, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what
         * DataSync transfers by using a manifest</a>.
         * </p>
         * <p>
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
         * <code>iam:PassRole</code> permission. The <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         * >AWSDataSyncFullAccess</a> policy includes this permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestConfig.Builder} avoiding the need
         * to create one manually via {@link ManifestConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #manifestConfig(ManifestConfig)}.
         * 
         * @param manifestConfig
         *        a consumer that will call methods on {@link ManifestConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestConfig(ManifestConfig)
         */
        default Builder manifestConfig(Consumer<ManifestConfig.Builder> manifestConfig) {
            return manifestConfig(ManifestConfig.builder().applyMutation(manifestConfig).build());
        }

        /**
         * <p>
         * Specifies how you want to configure a task report, which provides detailed information about your DataSync
         * transfer. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync
         * transfers with task reports</a>.
         * </p>
         * <p>
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
         * <code>iam:PassRole</code> permission. The <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         * >AWSDataSyncFullAccess</a> policy includes this permission.
         * </p>
         * 
         * @param taskReportConfig
         *        Specifies how you want to configure a task report, which provides detailed information about your
         *        DataSync transfer. For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your
         *        DataSync transfers with task reports</a>.</p>
         *        <p>
         *        When using this parameter, your caller identity (the role that you're using DataSync with) must have
         *        the <code>iam:PassRole</code> permission. The <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         *        >AWSDataSyncFullAccess</a> policy includes this permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskReportConfig(TaskReportConfig taskReportConfig);

        /**
         * <p>
         * Specifies how you want to configure a task report, which provides detailed information about your DataSync
         * transfer. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync
         * transfers with task reports</a>.
         * </p>
         * <p>
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the
         * <code>iam:PassRole</code> permission. The <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess"
         * >AWSDataSyncFullAccess</a> policy includes this permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskReportConfig.Builder} avoiding the
         * need to create one manually via {@link TaskReportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskReportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #taskReportConfig(TaskReportConfig)}.
         * 
         * @param taskReportConfig
         *        a consumer that will call methods on {@link TaskReportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskReportConfig(TaskReportConfig)
         */
        default Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return taskReportConfig(TaskReportConfig.builder().applyMutation(taskReportConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String sourceLocationArn;

        private String destinationLocationArn;

        private String cloudWatchLogGroupArn;

        private String name;

        private Options options;

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private TaskSchedule schedule;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private ManifestConfig manifestConfig;

        private TaskReportConfig taskReportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskRequest model) {
            super(model);
            sourceLocationArn(model.sourceLocationArn);
            destinationLocationArn(model.destinationLocationArn);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            name(model.name);
            options(model.options);
            excludes(model.excludes);
            schedule(model.schedule);
            tags(model.tags);
            includes(model.includes);
            manifestConfig(model.manifestConfig);
            taskReportConfig(model.taskReportConfig);
        }

        public final String getSourceLocationArn() {
            return sourceLocationArn;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final String getDestinationLocationArn() {
            return destinationLocationArn;
        }

        public final void setDestinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
        }

        @Override
        public final Builder destinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TaskSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManifestConfig.Builder getManifestConfig() {
            return manifestConfig != null ? manifestConfig.toBuilder() : null;
        }

        public final void setManifestConfig(ManifestConfig.BuilderImpl manifestConfig) {
            this.manifestConfig = manifestConfig != null ? manifestConfig.build() : null;
        }

        @Override
        public final Builder manifestConfig(ManifestConfig manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return taskReportConfig != null ? taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTaskRequest build() {
            return new CreateTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
