/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The types of performance data that DataSync Discovery collects about an on-premises storage system resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class P95Metrics implements SdkPojo, Serializable, ToCopyableBuilder<P95Metrics.Builder, P95Metrics> {
    private static final SdkField<IOPS> IOPS_FIELD = SdkField.<IOPS> builder(MarshallingType.SDK_POJO).memberName("IOPS")
            .getter(getter(P95Metrics::iops)).setter(setter(Builder::iops)).constructor(IOPS::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOPS").build()).build();

    private static final SdkField<Throughput> THROUGHPUT_FIELD = SdkField.<Throughput> builder(MarshallingType.SDK_POJO)
            .memberName("Throughput").getter(getter(P95Metrics::throughput)).setter(setter(Builder::throughput))
            .constructor(Throughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()).build();

    private static final SdkField<Latency> LATENCY_FIELD = SdkField.<Latency> builder(MarshallingType.SDK_POJO)
            .memberName("Latency").getter(getter(P95Metrics::latency)).setter(setter(Builder::latency))
            .constructor(Latency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD,
            LATENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final IOPS iops;

    private final Throughput throughput;

    private final Latency latency;

    private P95Metrics(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.latency = builder.latency;
    }

    /**
     * <p>
     * The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak
     * value during a 1-hour interval.
     * </p>
     * 
     * @return The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile
     *         peak value during a 1-hour interval.
     */
    public final IOPS iops() {
        return iops;
    }

    /**
     * <p>
     * The throughput peaks for an on-premises storage system resource. Each data point represents the 95th percentile
     * peak value during a 1-hour interval.
     * </p>
     * 
     * @return The throughput peaks for an on-premises storage system resource. Each data point represents the 95th
     *         percentile peak value during a 1-hour interval.
     */
    public final Throughput throughput() {
        return throughput;
    }

    /**
     * <p>
     * The latency peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak
     * value during a 1-hour interval.
     * </p>
     * 
     * @return The latency peaks for an on-premises storage system resource. Each data point represents the 95th
     *         percentile peak value during a 1-hour interval.
     */
    public final Latency latency() {
        return latency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P95Metrics)) {
            return false;
        }
        P95Metrics other = (P95Metrics) obj;
        return Objects.equals(iops(), other.iops()) && Objects.equals(throughput(), other.throughput())
                && Objects.equals(latency(), other.latency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("P95Metrics").add("IOPS", iops()).add("Throughput", throughput()).add("Latency", latency())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IOPS":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "Latency":
            return Optional.ofNullable(clazz.cast(latency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<P95Metrics, T> g) {
        return obj -> g.apply((P95Metrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, P95Metrics> {
        /**
         * <p>
         * The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile
         * peak value during a 1-hour interval.
         * </p>
         * 
         * @param iops
         *        The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th
         *        percentile peak value during a 1-hour interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(IOPS iops);

        /**
         * <p>
         * The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile
         * peak value during a 1-hour interval.
         * </p>
         * This is a convenience method that creates an instance of the {@link IOPS.Builder} avoiding the need to create
         * one manually via {@link IOPS#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IOPS.Builder#build()} is called immediately and its result is
         * passed to {@link #iops(IOPS)}.
         * 
         * @param iops
         *        a consumer that will call methods on {@link IOPS.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iops(IOPS)
         */
        default Builder iops(Consumer<IOPS.Builder> iops) {
            return iops(IOPS.builder().applyMutation(iops).build());
        }

        /**
         * <p>
         * The throughput peaks for an on-premises storage system resource. Each data point represents the 95th
         * percentile peak value during a 1-hour interval.
         * </p>
         * 
         * @param throughput
         *        The throughput peaks for an on-premises storage system resource. Each data point represents the 95th
         *        percentile peak value during a 1-hour interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Throughput throughput);

        /**
         * <p>
         * The throughput peaks for an on-premises storage system resource. Each data point represents the 95th
         * percentile peak value during a 1-hour interval.
         * </p>
         * This is a convenience method that creates an instance of the {@link Throughput.Builder} avoiding the need to
         * create one manually via {@link Throughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Throughput.Builder#build()} is called immediately and its result
         * is passed to {@link #throughput(Throughput)}.
         * 
         * @param throughput
         *        a consumer that will call methods on {@link Throughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throughput(Throughput)
         */
        default Builder throughput(Consumer<Throughput.Builder> throughput) {
            return throughput(Throughput.builder().applyMutation(throughput).build());
        }

        /**
         * <p>
         * The latency peaks for an on-premises storage system resource. Each data point represents the 95th percentile
         * peak value during a 1-hour interval.
         * </p>
         * 
         * @param latency
         *        The latency peaks for an on-premises storage system resource. Each data point represents the 95th
         *        percentile peak value during a 1-hour interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Latency latency);

        /**
         * <p>
         * The latency peaks for an on-premises storage system resource. Each data point represents the 95th percentile
         * peak value during a 1-hour interval.
         * </p>
         * This is a convenience method that creates an instance of the {@link Latency.Builder} avoiding the need to
         * create one manually via {@link Latency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Latency.Builder#build()} is called immediately and its result is
         * passed to {@link #latency(Latency)}.
         * 
         * @param latency
         *        a consumer that will call methods on {@link Latency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latency(Latency)
         */
        default Builder latency(Consumer<Latency.Builder> latency) {
            return latency(Latency.builder().applyMutation(latency).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IOPS iops;

        private Throughput throughput;

        private Latency latency;

        private BuilderImpl() {
        }

        private BuilderImpl(P95Metrics model) {
            iops(model.iops);
            throughput(model.throughput);
            latency(model.latency);
        }

        public final IOPS.Builder getIops() {
            return iops != null ? iops.toBuilder() : null;
        }

        public final void setIops(IOPS.BuilderImpl iops) {
            this.iops = iops != null ? iops.build() : null;
        }

        @Override
        public final Builder iops(IOPS iops) {
            this.iops = iops;
            return this;
        }

        public final Throughput.Builder getThroughput() {
            return throughput != null ? throughput.toBuilder() : null;
        }

        public final void setThroughput(Throughput.BuilderImpl throughput) {
            this.throughput = throughput != null ? throughput.build() : null;
        }

        @Override
        public final Builder throughput(Throughput throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Latency.Builder getLatency() {
            return latency != null ? latency.toBuilder() : null;
        }

        public final void setLatency(Latency.BuilderImpl latency) {
            this.latency = latency != null ? latency.build() : null;
        }

        @Override
        public final Builder latency(Latency latency) {
            this.latency = latency;
            return this;
        }

        @Override
        public P95Metrics build() {
            return new P95Metrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
