/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest;
import software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.CreateAgentRequest;
import software.amazon.awssdk.services.datasync.model.CreateAgentResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Request;
import software.amazon.awssdk.services.datasync.model.CreateLocationS3Response;
import software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.CreateLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.CreateTaskRequest;
import software.amazon.awssdk.services.datasync.model.CreateTaskResponse;
import software.amazon.awssdk.services.datasync.model.DeleteAgentRequest;
import software.amazon.awssdk.services.datasync.model.DeleteAgentResponse;
import software.amazon.awssdk.services.datasync.model.DeleteLocationRequest;
import software.amazon.awssdk.services.datasync.model.DeleteLocationResponse;
import software.amazon.awssdk.services.datasync.model.DeleteTaskRequest;
import software.amazon.awssdk.services.datasync.model.DeleteTaskResponse;
import software.amazon.awssdk.services.datasync.model.DescribeAgentRequest;
import software.amazon.awssdk.services.datasync.model.DescribeAgentResponse;
import software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest;
import software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationEfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request;
import software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response;
import software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskResponse;
import software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest;
import software.amazon.awssdk.services.datasync.model.GenerateRecommendationsResponse;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse;
import software.amazon.awssdk.services.datasync.model.ListLocationsRequest;
import software.amazon.awssdk.services.datasync.model.ListLocationsResponse;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;
import software.amazon.awssdk.services.datasync.model.ListTasksRequest;
import software.amazon.awssdk.services.datasync.model.ListTasksResponse;
import software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest;
import software.amazon.awssdk.services.datasync.model.RemoveStorageSystemResponse;
import software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest;
import software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.StopDiscoveryJobRequest;
import software.amazon.awssdk.services.datasync.model.StopDiscoveryJobResponse;
import software.amazon.awssdk.services.datasync.model.TagResourceRequest;
import software.amazon.awssdk.services.datasync.model.TagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UntagResourceRequest;
import software.amazon.awssdk.services.datasync.model.UntagResourceResponse;
import software.amazon.awssdk.services.datasync.model.UpdateAgentRequest;
import software.amazon.awssdk.services.datasync.model.UpdateAgentResponse;
import software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest;
import software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationNfsResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageResponse;
import software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest;
import software.amazon.awssdk.services.datasync.model.UpdateLocationSmbResponse;
import software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest;
import software.amazon.awssdk.services.datasync.model.UpdateStorageSystemResponse;
import software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.UpdateTaskRequest;
import software.amazon.awssdk.services.datasync.model.UpdateTaskResponse;
import software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourceMetricsPublisher;
import software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourcesPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListDiscoveryJobsPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListStorageSystemsPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher;
import software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher;

/**
 * Service client for accessing DataSync asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>DataSync</fullname>
 * <p>
 * DataSync is an online data movement and discovery service that simplifies data migration and helps you quickly,
 * easily, and securely transfer your file or object data to, from, and between Amazon Web Services storage services.
 * </p>
 * <p>
 * This API interface reference includes documentation for using DataSync programmatically. For complete information,
 * see the <i> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/what-is-datasync.html">DataSync User
 * Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataSyncAsyncClient extends AwsClient {
    String SERVICE_NAME = "datasync";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datasync";

    /**
     * <p>
     * Creates an Amazon Web Services resource for an on-premises storage system that you want DataSync Discovery to
     * collect information about.
     * </p>
     *
     * @param addStorageSystemRequest
     * @return A Java Future containing the result of the AddStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.AddStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/AddStorageSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddStorageSystemResponse> addStorageSystem(AddStorageSystemRequest addStorageSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource for an on-premises storage system that you want DataSync Discovery to
     * collect information about.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddStorageSystemRequest.Builder} avoiding the need
     * to create one manually via {@link AddStorageSystemRequest#builder()}
     * </p>
     *
     * @param addStorageSystemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.AddStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/AddStorageSystem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddStorageSystemResponse> addStorageSystem(
            Consumer<AddStorageSystemRequest.Builder> addStorageSystemRequest) {
        return addStorageSystem(AddStorageSystemRequest.builder().applyMutation(addStorageSystemRequest).build());
    }

    /**
     * <p>
     * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File
     * contents that're transferred to the destination might be incomplete or inconsistent with the source files.
     * </p>
     * <p>
     * However, if you start a new task execution using the same task and allow it to finish, file content on the
     * destination will be complete and consistent. This applies to other unexpected failures that interrupt a task
     * execution. In all of these cases, DataSync successfully completes the transfer when you start the next task
     * execution.
     * </p>
     *
     * @param cancelTaskExecutionRequest
     *        CancelTaskExecutionRequest
     * @return A Java Future containing the result of the CancelTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CancelTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelTaskExecutionResponse> cancelTaskExecution(
            CancelTaskExecutionRequest cancelTaskExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File
     * contents that're transferred to the destination might be incomplete or inconsistent with the source files.
     * </p>
     * <p>
     * However, if you start a new task execution using the same task and allow it to finish, file content on the
     * destination will be complete and consistent. This applies to other unexpected failures that interrupt a task
     * execution. In all of these cases, DataSync successfully completes the transfer when you start the next task
     * execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelTaskExecutionRequest#builder()}
     * </p>
     *
     * @param cancelTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest.Builder} to create a
     *        request. CancelTaskExecutionRequest
     * @return A Java Future containing the result of the CancelTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CancelTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelTaskExecutionResponse> cancelTaskExecution(
            Consumer<CancelTaskExecutionRequest.Builder> cancelTaskExecutionRequest) {
        return cancelTaskExecution(CancelTaskExecutionRequest.builder().applyMutation(cancelTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Activates an DataSync agent that you've deployed in your storage environment. The activation process associates
     * the agent with your Amazon Web Services account.
     * </p>
     * <p>
     * If you haven't deployed an agent yet, see the following topics to learn more:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/agent-requirements.html">Agent requirements</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-agent.html">Create an agent</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you're transferring between Amazon Web Services storage services, you don't need a DataSync agent.
     * </p>
     * </note>
     *
     * @param createAgentRequest
     *        CreateAgentRequest
     * @return A Java Future containing the result of the CreateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentResponse> createAgent(CreateAgentRequest createAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an DataSync agent that you've deployed in your storage environment. The activation process associates
     * the agent with your Amazon Web Services account.
     * </p>
     * <p>
     * If you haven't deployed an agent yet, see the following topics to learn more:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/agent-requirements.html">Agent requirements</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-agent.html">Create an agent</a>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you're transferring between Amazon Web Services storage services, you don't need a DataSync agent.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAgentRequest#builder()}
     * </p>
     *
     * @param createAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateAgentRequest.Builder} to create a request.
     *        CreateAgentRequest
     * @return A Java Future containing the result of the CreateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentResponse> createAgent(Consumer<CreateAgentRequest.Builder> createAgentRequest) {
        return createAgent(CreateAgentRequest.builder().applyMutation(createAgentRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Microsoft Azure Blob Storage container. DataSync can use this location
     * as a transfer source or destination.
     * </p>
     * <p>
     * Before you begin, make sure you know <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access">how
     * DataSync accesses Azure Blob Storage</a> and works with <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >access tiers</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types">blob
     * types</a>. You also need a <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent"
     * >DataSync agent</a> that can connect to your container.
     * </p>
     *
     * @param createLocationAzureBlobRequest
     * @return A Java Future containing the result of the CreateLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationAzureBlobResponse> createLocationAzureBlob(
            CreateLocationAzureBlobRequest createLocationAzureBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Microsoft Azure Blob Storage container. DataSync can use this location
     * as a transfer source or destination.
     * </p>
     * <p>
     * Before you begin, make sure you know <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access">how
     * DataSync accesses Azure Blob Storage</a> and works with <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >access tiers</a> and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types">blob
     * types</a>. You also need a <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent"
     * >DataSync agent</a> that can connect to your container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param createLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationAzureBlobResponse> createLocationAzureBlob(
            Consumer<CreateLocationAzureBlobRequest.Builder> createLocationAzureBlobRequest) {
        return createLocationAzureBlob(CreateLocationAzureBlobRequest.builder().applyMutation(createLocationAzureBlobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon EFS file system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access"
     * >accesses Amazon EFS file systems</a>.
     * </p>
     *
     * @param createLocationEfsRequest
     *        CreateLocationEfsRequest
     * @return A Java Future containing the result of the CreateLocationEfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationEfsResponse> createLocationEfs(CreateLocationEfsRequest createLocationEfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon EFS file system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access"
     * >accesses Amazon EFS file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationEfsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationEfsRequest#builder()}
     * </p>
     *
     * @param createLocationEfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest.Builder} to create a
     *        request. CreateLocationEfsRequest
     * @return A Java Future containing the result of the CreateLocationEfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationEfsResponse> createLocationEfs(
            Consumer<CreateLocationEfsRequest.Builder> createLocationEfsRequest) {
        return createLocationEfs(CreateLocationEfsRequest.builder().applyMutation(createLocationEfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Lustre file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access"
     * >accesses FSx for Lustre file systems</a>.
     * </p>
     *
     * @param createLocationFsxLustreRequest
     * @return A Java Future containing the result of the CreateLocationFsxLustre operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxLustreResponse> createLocationFsxLustre(
            CreateLocationFsxLustreRequest createLocationFsxLustreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Lustre file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access"
     * >accesses FSx for Lustre file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxLustreRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxLustreRequest#builder()}
     * </p>
     *
     * @param createLocationFsxLustreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationFsxLustre operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxLustreResponse> createLocationFsxLustre(
            Consumer<CreateLocationFsxLustreRequest.Builder> createLocationFsxLustreRequest) {
        return createLocationFsxLustre(CreateLocationFsxLustreRequest.builder().applyMutation(createLocationFsxLustreRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access"
     * >accesses FSx for ONTAP file systems</a>.
     * </p>
     *
     * @param createLocationFsxOntapRequest
     * @return A Java Future containing the result of the CreateLocationFsxOntap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxOntapResponse> createLocationFsxOntap(
            CreateLocationFsxOntapRequest createLocationFsxOntapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access"
     * >accesses FSx for ONTAP file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxOntapRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLocationFsxOntapRequest#builder()}
     * </p>
     *
     * @param createLocationFsxOntapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationFsxOntap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxOntapResponse> createLocationFsxOntap(
            Consumer<CreateLocationFsxOntapRequest.Builder> createLocationFsxOntapRequest) {
        return createLocationFsxOntap(CreateLocationFsxOntapRequest.builder().applyMutation(createLocationFsxOntapRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for OpenZFS file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access"
     * >accesses FSx for OpenZFS file systems</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>CreateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note>
     *
     * @param createLocationFsxOpenZfsRequest
     * @return A Java Future containing the result of the CreateLocationFsxOpenZfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxOpenZfsResponse> createLocationFsxOpenZfs(
            CreateLocationFsxOpenZfsRequest createLocationFsxOpenZfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for OpenZFS file system. DataSync can use this location as a
     * source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access"
     * >accesses FSx for OpenZFS file systems</a>.
     * </p>
     * <note>
     * <p>
     * Request parameters related to <code>SMB</code> aren't supported with the <code>CreateLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxOpenZfsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxOpenZfsRequest#builder()}
     * </p>
     *
     * @param createLocationFsxOpenZfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationFsxOpenZfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxOpenZfsResponse> createLocationFsxOpenZfs(
            Consumer<CreateLocationFsxOpenZfsRequest.Builder> createLocationFsxOpenZfsRequest) {
        return createLocationFsxOpenZfs(CreateLocationFsxOpenZfsRequest.builder().applyMutation(createLocationFsxOpenZfsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Windows File Server file system. DataSync can use this
     * location as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access"
     * >accesses FSx for Windows File Server file systems</a>.
     * </p>
     *
     * @param createLocationFsxWindowsRequest
     * @return A Java Future containing the result of the CreateLocationFsxWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxWindowsResponse> createLocationFsxWindows(
            CreateLocationFsxWindowsRequest createLocationFsxWindowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon FSx for Windows File Server file system. DataSync can use this
     * location as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access"
     * >accesses FSx for Windows File Server file systems</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationFsxWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocationFsxWindowsRequest#builder()}
     * </p>
     *
     * @param createLocationFsxWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationFsxWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationFsxWindowsResponse> createLocationFsxWindows(
            Consumer<CreateLocationFsxWindowsRequest.Builder> createLocationFsxWindowsRequest) {
        return createLocationFsxWindows(CreateLocationFsxWindowsRequest.builder().applyMutation(createLocationFsxWindowsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Hadoop Distributed File System (HDFS). DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs">accesses
     * HDFS clusters</a>.
     * </p>
     *
     * @param createLocationHdfsRequest
     * @return A Java Future containing the result of the CreateLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationHdfsResponse> createLocationHdfs(CreateLocationHdfsRequest createLocationHdfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Hadoop Distributed File System (HDFS). DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs">accesses
     * HDFS clusters</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLocationHdfsRequest#builder()}
     * </p>
     *
     * @param createLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationHdfsResponse> createLocationHdfs(
            Consumer<CreateLocationHdfsRequest.Builder> createLocationHdfsRequest) {
        return createLocationHdfs(CreateLocationHdfsRequest.builder().applyMutation(createLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Network File System (NFS) file server. DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">accesses NFS
     * file servers</a>.
     * </p>
     * <note>
     * <p>
     * If you're copying data to or from an Snowcone device, you can also use <code>CreateLocationNfs</code> to create
     * your transfer location. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/nfs-on-snowcone.html">Configuring transfers with
     * Snowcone</a>.
     * </p>
     * </note>
     *
     * @param createLocationNfsRequest
     *        CreateLocationNfsRequest
     * @return A Java Future containing the result of the CreateLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationNfsResponse> createLocationNfs(CreateLocationNfsRequest createLocationNfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Network File System (NFS) file server. DataSync can use this location as
     * a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">accesses NFS
     * file servers</a>.
     * </p>
     * <note>
     * <p>
     * If you're copying data to or from an Snowcone device, you can also use <code>CreateLocationNfs</code> to create
     * your transfer location. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/nfs-on-snowcone.html">Configuring transfers with
     * Snowcone</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationNfsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationNfsRequest#builder()}
     * </p>
     *
     * @param createLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest.Builder} to create a
     *        request. CreateLocationNfsRequest
     * @return A Java Future containing the result of the CreateLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationNfsResponse> createLocationNfs(
            Consumer<CreateLocationNfsRequest.Builder> createLocationNfsRequest) {
        return createLocationNfs(CreateLocationNfsRequest.builder().applyMutation(createLocationNfsRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an object storage system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand the <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites"
     * >prerequisites</a> for DataSync to work with object storage systems.
     * </p>
     *
     * @param createLocationObjectStorageRequest
     *        CreateLocationObjectStorageRequest
     * @return A Java Future containing the result of the CreateLocationObjectStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationObjectStorageResponse> createLocationObjectStorage(
            CreateLocationObjectStorageRequest createLocationObjectStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an object storage system. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand the <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites"
     * >prerequisites</a> for DataSync to work with object storage systems.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param createLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest.Builder} to
     *        create a request. CreateLocationObjectStorageRequest
     * @return A Java Future containing the result of the CreateLocationObjectStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLocationObjectStorageResponse> createLocationObjectStorage(
            Consumer<CreateLocationObjectStorageRequest.Builder> createLocationObjectStorageRequest) {
        return createLocationObjectStorage(CreateLocationObjectStorageRequest.builder()
                .applyMutation(createLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon S3 bucket. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html">Configuring transfers with
     * Amazon S3</a>.
     * </p>
     *
     * @param createLocationS3Request
     *        CreateLocationS3Request
     * @return A Java Future containing the result of the CreateLocationS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLocationS3Response> createLocationS3(CreateLocationS3Request createLocationS3Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for an Amazon S3 bucket. DataSync can use this location as a source or
     * destination for transferring data.
     * </p>
     * <important>
     * <p>
     * Before you begin, make sure that you read the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">
     * Storage class considerations with Amazon S3 locations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >Evaluating S3 request costs when using DataSync</a>
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html">Configuring transfers with
     * Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationS3Request.Builder} avoiding the need
     * to create one manually via {@link CreateLocationS3Request#builder()}
     * </p>
     *
     * @param createLocationS3Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationS3Request.Builder} to create a
     *        request. CreateLocationS3Request
     * @return A Java Future containing the result of the CreateLocationS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLocationS3Response> createLocationS3(
            Consumer<CreateLocationS3Request.Builder> createLocationS3Request) {
        return createLocationS3(CreateLocationS3Request.builder().applyMutation(createLocationS3Request).build());
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Server Message Block (SMB) file server. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb">accesses
     * SMB file servers</a>.
     * </p>
     *
     * @param createLocationSmbRequest
     *        CreateLocationSmbRequest
     * @return A Java Future containing the result of the CreateLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationSmbResponse> createLocationSmb(CreateLocationSmbRequest createLocationSmbRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transfer <i>location</i> for a Server Message Block (SMB) file server. DataSync can use this location
     * as a source or destination for transferring data.
     * </p>
     * <p>
     * Before you begin, make sure that you understand how DataSync <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb">accesses
     * SMB file servers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationSmbRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLocationSmbRequest#builder()}
     * </p>
     *
     * @param createLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest.Builder} to create a
     *        request. CreateLocationSmbRequest
     * @return A Java Future containing the result of the CreateLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLocationSmbResponse> createLocationSmb(
            Consumer<CreateLocationSmbRequest.Builder> createLocationSmbRequest) {
        return createLocationSmb(CreateLocationSmbRequest.builder().applyMutation(createLocationSmbRequest).build());
    }

    /**
     * <p>
     * Configures a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <p>
     * A task includes a source location, destination location, and transfer options (such as bandwidth limits,
     * scheduling, and more).
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important>
     *
     * @param createTaskRequest
     *        CreateTaskRequest
     * @return A Java Future containing the result of the CreateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTaskResponse> createTask(CreateTaskRequest createTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <p>
     * A task includes a source location, destination location, and transfer options (such as bandwidth limits,
     * scheduling, and more).
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTaskRequest#builder()}
     * </p>
     *
     * @param createTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.CreateTaskRequest.Builder} to create a request.
     *        CreateTaskRequest
     * @return A Java Future containing the result of the CreateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTaskResponse> createTask(Consumer<CreateTaskRequest.Builder> createTaskRequest) {
        return createTask(CreateTaskRequest.builder().applyMutation(createTaskRequest).build());
    }

    /**
     * <p>
     * Removes an DataSync agent resource from your Amazon Web Services account.
     * </p>
     * <p>
     * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or
     * Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your
     * storage environment or reuse it to <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activate a new agent</a>.
     * </p>
     *
     * @param deleteAgentRequest
     *        DeleteAgentRequest
     * @return A Java Future containing the result of the DeleteAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgentResponse> deleteAgent(DeleteAgentRequest deleteAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an DataSync agent resource from your Amazon Web Services account.
     * </p>
     * <p>
     * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or
     * Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your
     * storage environment or reuse it to <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activate a new agent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAgentRequest#builder()}
     * </p>
     *
     * @param deleteAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteAgentRequest.Builder} to create a request.
     *        DeleteAgentRequest
     * @return A Java Future containing the result of the DeleteAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgentResponse> deleteAgent(Consumer<DeleteAgentRequest.Builder> deleteAgentRequest) {
        return deleteAgent(DeleteAgentRequest.builder().applyMutation(deleteAgentRequest).build());
    }

    /**
     * <p>
     * Deletes a transfer location resource from DataSync.
     * </p>
     *
     * @param deleteLocationRequest
     *        DeleteLocation
     * @return A Java Future containing the result of the DeleteLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLocationResponse> deleteLocation(DeleteLocationRequest deleteLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transfer location resource from DataSync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocationRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLocationRequest#builder()}
     * </p>
     *
     * @param deleteLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteLocationRequest.Builder} to create a request.
     *        DeleteLocation
     * @return A Java Future containing the result of the DeleteLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLocationResponse> deleteLocation(Consumer<DeleteLocationRequest.Builder> deleteLocationRequest) {
        return deleteLocation(DeleteLocationRequest.builder().applyMutation(deleteLocationRequest).build());
    }

    /**
     * <p>
     * Deletes a transfer task resource from DataSync.
     * </p>
     *
     * @param deleteTaskRequest
     *        DeleteTask
     * @return A Java Future containing the result of the DeleteTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskResponse> deleteTask(DeleteTaskRequest deleteTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transfer task resource from DataSync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTaskRequest#builder()}
     * </p>
     *
     * @param deleteTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DeleteTaskRequest.Builder} to create a request.
     *        DeleteTask
     * @return A Java Future containing the result of the DeleteTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DeleteTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskResponse> deleteTask(Consumer<DeleteTaskRequest.Builder> deleteTaskRequest) {
        return deleteTask(DeleteTaskRequest.builder().applyMutation(deleteTaskRequest).build());
    }

    /**
     * <p>
     * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
     * </p>
     *
     * @param describeAgentRequest
     *        DescribeAgent
     * @return A Java Future containing the result of the DescribeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAgentResponse> describeAgent(DescribeAgentRequest describeAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAgentRequest#builder()}
     * </p>
     *
     * @param describeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeAgentRequest.Builder} to create a request.
     *        DescribeAgent
     * @return A Java Future containing the result of the DescribeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAgentResponse> describeAgent(Consumer<DescribeAgentRequest.Builder> describeAgentRequest) {
        return describeAgent(DescribeAgentRequest.builder().applyMutation(describeAgentRequest).build());
    }

    /**
     * <p>
     * Returns information about a DataSync discovery job.
     * </p>
     *
     * @param describeDiscoveryJobRequest
     * @return A Java Future containing the result of the DescribeDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDiscoveryJobResponse> describeDiscoveryJob(
            DescribeDiscoveryJobRequest describeDiscoveryJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a DataSync discovery job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDiscoveryJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDiscoveryJobRequest#builder()}
     * </p>
     *
     * @param describeDiscoveryJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDiscoveryJobResponse> describeDiscoveryJob(
            Consumer<DescribeDiscoveryJobRequest.Builder> describeDiscoveryJobRequest) {
        return describeDiscoveryJob(DescribeDiscoveryJobRequest.builder().applyMutation(describeDiscoveryJobRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
     * </p>
     *
     * @param describeLocationAzureBlobRequest
     * @return A Java Future containing the result of the DescribeLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationAzureBlobResponse> describeLocationAzureBlob(
            DescribeLocationAzureBlobRequest describeLocationAzureBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param describeLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationAzureBlobResponse> describeLocationAzureBlob(
            Consumer<DescribeLocationAzureBlobRequest.Builder> describeLocationAzureBlobRequest) {
        return describeLocationAzureBlob(DescribeLocationAzureBlobRequest.builder()
                .applyMutation(describeLocationAzureBlobRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
     * </p>
     *
     * @param describeLocationEfsRequest
     *        DescribeLocationEfsRequest
     * @return A Java Future containing the result of the DescribeLocationEfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationEfsResponse> describeLocationEfs(
            DescribeLocationEfsRequest describeLocationEfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationEfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationEfsRequest#builder()}
     * </p>
     *
     * @param describeLocationEfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest.Builder} to create a
     *        request. DescribeLocationEfsRequest
     * @return A Java Future containing the result of the DescribeLocationEfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationEfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationEfsResponse> describeLocationEfs(
            Consumer<DescribeLocationEfsRequest.Builder> describeLocationEfsRequest) {
        return describeLocationEfs(DescribeLocationEfsRequest.builder().applyMutation(describeLocationEfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
     * </p>
     *
     * @param describeLocationFsxLustreRequest
     * @return A Java Future containing the result of the DescribeLocationFsxLustre operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxLustreResponse> describeLocationFsxLustre(
            DescribeLocationFsxLustreRequest describeLocationFsxLustreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxLustreRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxLustreRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxLustreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLocationFsxLustre operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxLustre
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxLustre"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxLustreResponse> describeLocationFsxLustre(
            Consumer<DescribeLocationFsxLustreRequest.Builder> describeLocationFsxLustreRequest) {
        return describeLocationFsxLustre(DescribeLocationFsxLustreRequest.builder()
                .applyMutation(describeLocationFsxLustreRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is
     * configured.
     * </p>
     * <note>
     * <p>
     * If your location uses SMB, the <code>DescribeLocationFsxOntap</code> operation doesn't actually return a
     * <code>Password</code>.
     * </p>
     * </note>
     *
     * @param describeLocationFsxOntapRequest
     * @return A Java Future containing the result of the DescribeLocationFsxOntap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxOntapResponse> describeLocationFsxOntap(
            DescribeLocationFsxOntapRequest describeLocationFsxOntapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is
     * configured.
     * </p>
     * <note>
     * <p>
     * If your location uses SMB, the <code>DescribeLocationFsxOntap</code> operation doesn't actually return a
     * <code>Password</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxOntapRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxOntapRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxOntapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLocationFsxOntap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxOntap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOntap"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxOntapResponse> describeLocationFsxOntap(
            Consumer<DescribeLocationFsxOntapRequest.Builder> describeLocationFsxOntapRequest) {
        return describeLocationFsxOntap(DescribeLocationFsxOntapRequest.builder().applyMutation(describeLocationFsxOntapRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
     * </p>
     * <note>
     * <p>
     * Response elements related to <code>SMB</code> aren't supported with the <code>DescribeLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note>
     *
     * @param describeLocationFsxOpenZfsRequest
     * @return A Java Future containing the result of the DescribeLocationFsxOpenZfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxOpenZfsResponse> describeLocationFsxOpenZfs(
            DescribeLocationFsxOpenZfsRequest describeLocationFsxOpenZfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
     * </p>
     * <note>
     * <p>
     * Response elements related to <code>SMB</code> aren't supported with the <code>DescribeLocationFsxOpenZfs</code>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxOpenZfsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxOpenZfsRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxOpenZfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLocationFsxOpenZfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxOpenZfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxOpenZfs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxOpenZfsResponse> describeLocationFsxOpenZfs(
            Consumer<DescribeLocationFsxOpenZfsRequest.Builder> describeLocationFsxOpenZfsRequest) {
        return describeLocationFsxOpenZfs(DescribeLocationFsxOpenZfsRequest.builder()
                .applyMutation(describeLocationFsxOpenZfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is
     * configured.
     * </p>
     *
     * @param describeLocationFsxWindowsRequest
     * @return A Java Future containing the result of the DescribeLocationFsxWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxWindowsResponse> describeLocationFsxWindows(
            DescribeLocationFsxWindowsRequest describeLocationFsxWindowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationFsxWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeLocationFsxWindowsRequest#builder()}
     * </p>
     *
     * @param describeLocationFsxWindowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLocationFsxWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationFsxWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationFsxWindowsResponse> describeLocationFsxWindows(
            Consumer<DescribeLocationFsxWindowsRequest.Builder> describeLocationFsxWindowsRequest) {
        return describeLocationFsxWindows(DescribeLocationFsxWindowsRequest.builder()
                .applyMutation(describeLocationFsxWindowsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is
     * configured.
     * </p>
     *
     * @param describeLocationHdfsRequest
     * @return A Java Future containing the result of the DescribeLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationHdfsResponse> describeLocationHdfs(
            DescribeLocationHdfsRequest describeLocationHdfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationHdfsRequest#builder()}
     * </p>
     *
     * @param describeLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationHdfsResponse> describeLocationHdfs(
            Consumer<DescribeLocationHdfsRequest.Builder> describeLocationHdfsRequest) {
        return describeLocationHdfs(DescribeLocationHdfsRequest.builder().applyMutation(describeLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is
     * configured.
     * </p>
     *
     * @param describeLocationNfsRequest
     *        DescribeLocationNfsRequest
     * @return A Java Future containing the result of the DescribeLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationNfsResponse> describeLocationNfs(
            DescribeLocationNfsRequest describeLocationNfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationNfsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationNfsRequest#builder()}
     * </p>
     *
     * @param describeLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest.Builder} to create a
     *        request. DescribeLocationNfsRequest
     * @return A Java Future containing the result of the DescribeLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationNfsResponse> describeLocationNfs(
            Consumer<DescribeLocationNfsRequest.Builder> describeLocationNfsRequest) {
        return describeLocationNfs(DescribeLocationNfsRequest.builder().applyMutation(describeLocationNfsRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an object storage system is configured.
     * </p>
     *
     * @param describeLocationObjectStorageRequest
     *        DescribeLocationObjectStorageRequest
     * @return A Java Future containing the result of the DescribeLocationObjectStorage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationObjectStorageResponse> describeLocationObjectStorage(
            DescribeLocationObjectStorageRequest describeLocationObjectStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an object storage system is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param describeLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest.Builder} to
     *        create a request. DescribeLocationObjectStorageRequest
     * @return A Java Future containing the result of the DescribeLocationObjectStorage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLocationObjectStorageResponse> describeLocationObjectStorage(
            Consumer<DescribeLocationObjectStorageRequest.Builder> describeLocationObjectStorageRequest) {
        return describeLocationObjectStorage(DescribeLocationObjectStorageRequest.builder()
                .applyMutation(describeLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an S3 bucket is configured.
     * </p>
     *
     * @param describeLocationS3Request
     *        DescribeLocationS3Request
     * @return A Java Future containing the result of the DescribeLocationS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationS3Response> describeLocationS3(DescribeLocationS3Request describeLocationS3Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for an S3 bucket is configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationS3Request.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationS3Request#builder()}
     * </p>
     *
     * @param describeLocationS3Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request.Builder} to create a
     *        request. DescribeLocationS3Request
     * @return A Java Future containing the result of the DescribeLocationS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationS3
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationS3Response> describeLocationS3(
            Consumer<DescribeLocationS3Request.Builder> describeLocationS3Request) {
        return describeLocationS3(DescribeLocationS3Request.builder().applyMutation(describeLocationS3Request).build());
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is
     * configured.
     * </p>
     *
     * @param describeLocationSmbRequest
     *        DescribeLocationSmbRequest
     * @return A Java Future containing the result of the DescribeLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationSmbResponse> describeLocationSmb(
            DescribeLocationSmbRequest describeLocationSmbRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is
     * configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationSmbRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLocationSmbRequest#builder()}
     * </p>
     *
     * @param describeLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest.Builder} to create a
     *        request. DescribeLocationSmbRequest
     * @return A Java Future containing the result of the DescribeLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLocationSmbResponse> describeLocationSmb(
            Consumer<DescribeLocationSmbRequest.Builder> describeLocationSmbRequest) {
        return describeLocationSmb(DescribeLocationSmbRequest.builder().applyMutation(describeLocationSmbRequest).build());
    }

    /**
     * <p>
     * Returns information about an on-premises storage system that you're using with DataSync Discovery.
     * </p>
     *
     * @param describeStorageSystemRequest
     * @return A Java Future containing the result of the DescribeStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResponse> describeStorageSystem(
            DescribeStorageSystemRequest describeStorageSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an on-premises storage system that you're using with DataSync Discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageSystemRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStorageSystemRequest#builder()}
     * </p>
     *
     * @param describeStorageSystemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResponse> describeStorageSystem(
            Consumer<DescribeStorageSystemRequest.Builder> describeStorageSystemRequest) {
        return describeStorageSystem(DescribeStorageSystemRequest.builder().applyMutation(describeStorageSystemRequest).build());
    }

    /**
     * <p>
     * Returns information, including performance data and capacity usage, which DataSync Discovery collects about a
     * specific resource in your-premises storage system.
     * </p>
     *
     * @param describeStorageSystemResourceMetricsRequest
     * @return A Java Future containing the result of the DescribeStorageSystemResourceMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResourceMetricsResponse> describeStorageSystemResourceMetrics(
            DescribeStorageSystemResourceMetricsRequest describeStorageSystemResourceMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information, including performance data and capacity usage, which DataSync Discovery collects about a
     * specific resource in your-premises storage system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeStorageSystemResourceMetricsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeStorageSystemResourceMetricsRequest#builder()}
     * </p>
     *
     * @param describeStorageSystemResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeStorageSystemResourceMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResourceMetricsResponse> describeStorageSystemResourceMetrics(
            Consumer<DescribeStorageSystemResourceMetricsRequest.Builder> describeStorageSystemResourceMetricsRequest) {
        return describeStorageSystemResourceMetrics(DescribeStorageSystemResourceMetricsRequest.builder()
                .applyMutation(describeStorageSystemResourceMetricsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStorageSystemResourceMetrics(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourceMetricsPublisher publisher = client.describeStorageSystemResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourceMetricsPublisher publisher = client.describeStorageSystemResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStorageSystemResourceMetrics(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStorageSystemResourceMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageSystemResourceMetricsPublisher describeStorageSystemResourceMetricsPaginator(
            DescribeStorageSystemResourceMetricsRequest describeStorageSystemResourceMetricsRequest) {
        return new DescribeStorageSystemResourceMetricsPublisher(this, describeStorageSystemResourceMetricsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStorageSystemResourceMetrics(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourceMetricsPublisher publisher = client.describeStorageSystemResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourceMetricsPublisher publisher = client.describeStorageSystemResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStorageSystemResourceMetrics(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeStorageSystemResourceMetricsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeStorageSystemResourceMetricsRequest#builder()}
     * </p>
     *
     * @param describeStorageSystemResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageSystemResourceMetricsPublisher describeStorageSystemResourceMetricsPaginator(
            Consumer<DescribeStorageSystemResourceMetricsRequest.Builder> describeStorageSystemResourceMetricsRequest) {
        return describeStorageSystemResourceMetricsPaginator(DescribeStorageSystemResourceMetricsRequest.builder()
                .applyMutation(describeStorageSystemResourceMetricsRequest).build());
    }

    /**
     * <p>
     * Returns information that DataSync Discovery collects about resources in your on-premises storage system.
     * </p>
     *
     * @param describeStorageSystemResourcesRequest
     * @return A Java Future containing the result of the DescribeStorageSystemResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResourcesResponse> describeStorageSystemResources(
            DescribeStorageSystemResourcesRequest describeStorageSystemResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information that DataSync Discovery collects about resources in your on-premises storage system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageSystemResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStorageSystemResourcesRequest#builder()}
     * </p>
     *
     * @param describeStorageSystemResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStorageSystemResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageSystemResourcesResponse> describeStorageSystemResources(
            Consumer<DescribeStorageSystemResourcesRequest.Builder> describeStorageSystemResourcesRequest) {
        return describeStorageSystemResources(DescribeStorageSystemResourcesRequest.builder()
                .applyMutation(describeStorageSystemResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStorageSystemResources(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourcesPublisher publisher = client.describeStorageSystemResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourcesPublisher publisher = client.describeStorageSystemResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStorageSystemResources(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStorageSystemResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageSystemResourcesPublisher describeStorageSystemResourcesPaginator(
            DescribeStorageSystemResourcesRequest describeStorageSystemResourcesRequest) {
        return new DescribeStorageSystemResourcesPublisher(this, describeStorageSystemResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStorageSystemResources(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourcesPublisher publisher = client.describeStorageSystemResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.DescribeStorageSystemResourcesPublisher publisher = client.describeStorageSystemResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStorageSystemResources(software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageSystemResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStorageSystemResourcesRequest#builder()}
     * </p>
     *
     * @param describeStorageSystemResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeStorageSystemResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeStorageSystemResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageSystemResourcesPublisher describeStorageSystemResourcesPaginator(
            Consumer<DescribeStorageSystemResourcesRequest.Builder> describeStorageSystemResourcesRequest) {
        return describeStorageSystemResourcesPaginator(DescribeStorageSystemResourcesRequest.builder()
                .applyMutation(describeStorageSystemResourcesRequest).build());
    }

    /**
     * <p>
     * Provides information about a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     *
     * @param describeTaskRequest
     *        DescribeTaskRequest
     * @return A Java Future containing the result of the DescribeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTaskResponse> describeTask(DescribeTaskRequest describeTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTaskRequest#builder()}
     * </p>
     *
     * @param describeTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeTaskRequest.Builder} to create a request.
     *        DescribeTaskRequest
     * @return A Java Future containing the result of the DescribeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTaskResponse> describeTask(Consumer<DescribeTaskRequest.Builder> describeTaskRequest) {
        return describeTask(DescribeTaskRequest.builder().applyMutation(describeTaskRequest).build());
    }

    /**
     * <p>
     * Provides information about an execution of your DataSync task. You can use this operation to help monitor the
     * progress of an ongoing transfer or check the results of the transfer.
     * </p>
     *
     * @param describeTaskExecutionRequest
     *        DescribeTaskExecutionRequest
     * @return A Java Future containing the result of the DescribeTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTaskExecutionResponse> describeTaskExecution(
            DescribeTaskExecutionRequest describeTaskExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an execution of your DataSync task. You can use this operation to help monitor the
     * progress of an ongoing transfer or check the results of the transfer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTaskExecutionRequest#builder()}
     * </p>
     *
     * @param describeTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest.Builder} to create a
     *        request. DescribeTaskExecutionRequest
     * @return A Java Future containing the result of the DescribeTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.DescribeTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTaskExecutionResponse> describeTaskExecution(
            Consumer<DescribeTaskExecutionRequest.Builder> describeTaskExecutionRequest) {
        return describeTaskExecution(DescribeTaskExecutionRequest.builder().applyMutation(describeTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Creates recommendations about where to migrate your data to in Amazon Web Services. Recommendations are generated
     * based on information that DataSync Discovery collects about your on-premises storage system's resources. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
     * >Recommendations provided by DataSync Discovery</a>.
     * </p>
     * <p>
     * Once generated, you can view your recommendations by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html"
     * >DescribeStorageSystemResources</a> operation.
     * </p>
     *
     * @param generateRecommendationsRequest
     * @return A Java Future containing the result of the GenerateRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.GenerateRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/GenerateRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateRecommendationsResponse> generateRecommendations(
            GenerateRecommendationsRequest generateRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates recommendations about where to migrate your data to in Amazon Web Services. Recommendations are generated
     * based on information that DataSync Discovery collects about your on-premises storage system's resources. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
     * >Recommendations provided by DataSync Discovery</a>.
     * </p>
     * <p>
     * Once generated, you can view your recommendations by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html"
     * >DescribeStorageSystemResources</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateRecommendationsRequest#builder()}
     * </p>
     *
     * @param generateRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GenerateRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.GenerateRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/GenerateRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateRecommendationsResponse> generateRecommendations(
            Consumer<GenerateRecommendationsRequest.Builder> generateRecommendationsRequest) {
        return generateRecommendations(GenerateRecommendationsRequest.builder().applyMutation(generateRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     *
     * @param listAgentsRequest
     *        ListAgentsRequest
     * @return A Java Future containing the result of the ListAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgentsResponse> listAgents(ListAgentsRequest listAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListAgentsRequest.Builder} to create a request.
     *        ListAgentsRequest
     * @return A Java Future containing the result of the ListAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgentsResponse> listAgents(Consumer<ListAgentsRequest.Builder> listAgentsRequest) {
        return listAgents(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region
     * specified in the request.
     * </p>
     * <p>
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of
     * agents in a response, the response contains a marker that you can specify in your next request to fetch the next
     * page of agents.
     * </p>
     * <p>
     * <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not
     * reflect that you just created or deleted an agent. For example, if you create an agent with <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then
     * immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like
     * this, you can always confirm whether an agent has been created (or deleted) by using <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgentsResponse> listAgents() {
        return listAgents(ListAgentsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsPublisher listAgentsPaginator() {
        return listAgentsPaginator(ListAgentsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     *
     * @param listAgentsRequest
     *        ListAgentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsPublisher listAgentsPaginator(ListAgentsRequest listAgentsRequest) {
        return new ListAgentsPublisher(this, listAgentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.datasync.model.ListAgentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListAgentsRequest.Builder} to create a request.
     *        ListAgentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsPublisher listAgentsPaginator(Consumer<ListAgentsRequest.Builder> listAgentsRequest) {
        return listAgentsPaginator(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * Provides a list of the existing discovery jobs in the Amazon Web Services Region and Amazon Web Services account
     * where you're using DataSync Discovery.
     * </p>
     *
     * @param listDiscoveryJobsRequest
     * @return A Java Future containing the result of the ListDiscoveryJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListDiscoveryJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDiscoveryJobsResponse> listDiscoveryJobs(ListDiscoveryJobsRequest listDiscoveryJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the existing discovery jobs in the Amazon Web Services Region and Amazon Web Services account
     * where you're using DataSync Discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveryJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoveryJobsRequest#builder()}
     * </p>
     *
     * @param listDiscoveryJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDiscoveryJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListDiscoveryJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDiscoveryJobsResponse> listDiscoveryJobs(
            Consumer<ListDiscoveryJobsRequest.Builder> listDiscoveryJobsRequest) {
        return listDiscoveryJobs(ListDiscoveryJobsRequest.builder().applyMutation(listDiscoveryJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveryJobs(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListDiscoveryJobsPublisher publisher = client.listDiscoveryJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListDiscoveryJobsPublisher publisher = client.listDiscoveryJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveryJobs(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveryJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListDiscoveryJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDiscoveryJobsPublisher listDiscoveryJobsPaginator(ListDiscoveryJobsRequest listDiscoveryJobsRequest) {
        return new ListDiscoveryJobsPublisher(this, listDiscoveryJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveryJobs(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListDiscoveryJobsPublisher publisher = client.listDiscoveryJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListDiscoveryJobsPublisher publisher = client.listDiscoveryJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveryJobs(software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveryJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoveryJobsRequest#builder()}
     * </p>
     *
     * @param listDiscoveryJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListDiscoveryJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListDiscoveryJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDiscoveryJobsPublisher listDiscoveryJobsPaginator(
            Consumer<ListDiscoveryJobsRequest.Builder> listDiscoveryJobsRequest) {
        return listDiscoveryJobsPaginator(ListDiscoveryJobsRequest.builder().applyMutation(listDiscoveryJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     *
     * @param listLocationsRequest
     *        ListLocationsRequest
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLocationsResponse> listLocations(ListLocationsRequest listLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListLocationsRequest.Builder} to create a request.
     *        ListLocationsRequest
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLocationsResponse> listLocations(Consumer<ListLocationsRequest.Builder> listLocationsRequest) {
        return listLocations(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of source and destination locations.
     * </p>
     * <p>
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list
     * of your agents), the response contains a token that you can specify in your next request to fetch the next page
     * of locations.
     * </p>
     *
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLocationsResponse> listLocations() {
        return listLocations(ListLocationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsPublisher listLocationsPaginator() {
        return listLocationsPaginator(ListLocationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @param listLocationsRequest
     *        ListLocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsPublisher listLocationsPaginator(ListLocationsRequest listLocationsRequest) {
        return new ListLocationsPublisher(this, listLocationsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.datasync.model.ListLocationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListLocationsRequest.Builder} to create a request.
     *        ListLocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsPublisher listLocationsPaginator(Consumer<ListLocationsRequest.Builder> listLocationsRequest) {
        return listLocationsPaginator(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Lists the on-premises storage systems that you're using with DataSync Discovery.
     * </p>
     *
     * @param listStorageSystemsRequest
     * @return A Java Future containing the result of the ListStorageSystems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListStorageSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStorageSystemsResponse> listStorageSystems(ListStorageSystemsRequest listStorageSystemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the on-premises storage systems that you're using with DataSync Discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageSystemsRequest#builder()}
     * </p>
     *
     * @param listStorageSystemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStorageSystems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListStorageSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStorageSystemsResponse> listStorageSystems(
            Consumer<ListStorageSystemsRequest.Builder> listStorageSystemsRequest) {
        return listStorageSystems(ListStorageSystemsRequest.builder().applyMutation(listStorageSystemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageSystems(software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListStorageSystemsPublisher publisher = client.listStorageSystemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListStorageSystemsPublisher publisher = client.listStorageSystemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageSystems(software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageSystemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListStorageSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageSystemsPublisher listStorageSystemsPaginator(ListStorageSystemsRequest listStorageSystemsRequest) {
        return new ListStorageSystemsPublisher(this, listStorageSystemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageSystems(software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListStorageSystemsPublisher publisher = client.listStorageSystemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListStorageSystemsPublisher publisher = client.listStorageSystemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageSystems(software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStorageSystemsRequest#builder()}
     * </p>
     *
     * @param listStorageSystemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListStorageSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListStorageSystems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStorageSystemsPublisher listStorageSystemsPaginator(
            Consumer<ListStorageSystemsRequest.Builder> listStorageSystemsRequest) {
        return listStorageSystemsPaginator(ListStorageSystemsRequest.builder().applyMutation(listStorageSystemsRequest).build());
    }

    /**
     * <p>
     * Returns all the tags associated with an Amazon Web Services resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the tags associated with an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest.Builder} to create a
     *        request. ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest.Builder} to create a
     *        request. ListTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        ListTaskExecutions
     * @return A Java Future containing the result of the ListTaskExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTaskExecutionsResponse> listTaskExecutions(ListTaskExecutionsRequest listTaskExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest.Builder} to create a
     *        request. ListTaskExecutions
     * @return A Java Future containing the result of the ListTaskExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTaskExecutionsResponse> listTaskExecutions(
            Consumer<ListTaskExecutionsRequest.Builder> listTaskExecutionsRequest) {
        return listTaskExecutions(ListTaskExecutionsRequest.builder().applyMutation(listTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of executions for an DataSync transfer task.
     * </p>
     *
     * @return A Java Future containing the result of the ListTaskExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTaskExecutionsResponse> listTaskExecutions() {
        return listTaskExecutions(ListTaskExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsPublisher listTaskExecutionsPaginator() {
        return listTaskExecutionsPaginator(ListTaskExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        ListTaskExecutions
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsPublisher listTaskExecutionsPaginator(ListTaskExecutionsRequest listTaskExecutionsRequest) {
        return new ListTaskExecutionsPublisher(this, listTaskExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTaskExecutionsPublisher publisher = client.listTaskExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskExecutions(software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest.Builder} to create a
     *        request. ListTaskExecutions
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaskExecutionsPublisher listTaskExecutionsPaginator(
            Consumer<ListTaskExecutionsRequest.Builder> listTaskExecutionsRequest) {
        return listTaskExecutionsPaginator(ListTaskExecutionsRequest.builder().applyMutation(listTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     *
     * @param listTasksRequest
     *        ListTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTasksRequest.Builder} to create a request.
     *        ListTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of the DataSync tasks you created.
     * </p>
     *
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks() {
        return listTasks(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator() {
        return listTasksPaginator(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     *        ListTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(ListTasksRequest listTasksRequest) {
        return new ListTasksPublisher(this, listTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datasync.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datasync.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datasync.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.datasync.model.ListTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.ListTasksRequest.Builder} to create a request.
     *        ListTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Permanently removes a storage system resource from DataSync Discovery, including the associated discovery jobs,
     * collected data, and recommendations.
     * </p>
     *
     * @param removeStorageSystemRequest
     * @return A Java Future containing the result of the RemoveStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.RemoveStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/RemoveStorageSystem" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveStorageSystemResponse> removeStorageSystem(
            RemoveStorageSystemRequest removeStorageSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently removes a storage system resource from DataSync Discovery, including the associated discovery jobs,
     * collected data, and recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveStorageSystemRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveStorageSystemRequest#builder()}
     * </p>
     *
     * @param removeStorageSystemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.RemoveStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/RemoveStorageSystem" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveStorageSystemResponse> removeStorageSystem(
            Consumer<RemoveStorageSystemRequest.Builder> removeStorageSystemRequest) {
        return removeStorageSystem(RemoveStorageSystemRequest.builder().applyMutation(removeStorageSystemRequest).build());
    }

    /**
     * <p>
     * Runs a DataSync discovery job on your on-premises storage system. If you haven't added the storage system to
     * DataSync Discovery yet, do this first by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html">AddStorageSystem</a>
     * operation.
     * </p>
     *
     * @param startDiscoveryJobRequest
     * @return A Java Future containing the result of the StartDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StartDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDiscoveryJobResponse> startDiscoveryJob(StartDiscoveryJobRequest startDiscoveryJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a DataSync discovery job on your on-premises storage system. If you haven't added the storage system to
     * DataSync Discovery yet, do this first by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html">AddStorageSystem</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDiscoveryJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartDiscoveryJobRequest#builder()}
     * </p>
     *
     * @param startDiscoveryJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StartDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDiscoveryJobResponse> startDiscoveryJob(
            Consumer<StartDiscoveryJobRequest.Builder> startDiscoveryJobRequest) {
        return startDiscoveryJob(StartDiscoveryJobRequest.builder().applyMutation(startDiscoveryJobRequest).build());
    }

    /**
     * <p>
     * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
     * </p>
     * <p>
     * There are several phases to a task execution. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important>
     *
     * @param startTaskExecutionRequest
     *        StartTaskExecutionRequest
     * @return A Java Future containing the result of the StartTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StartTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartTaskExecutionResponse> startTaskExecution(StartTaskExecutionRequest startTaskExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
     * </p>
     * <p>
     * There are several phases to a task execution. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses"
     * >Task execution statuses</a>.
     * </p>
     * <important>
     * <p>
     * If you're planning to transfer data to or from an Amazon S3 location, review <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests"
     * >how DataSync can affect your S3 request charges</a> and the <a
     * href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartTaskExecutionRequest#builder()}
     * </p>
     *
     * @param startTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest.Builder} to create a
     *        request. StartTaskExecutionRequest
     * @return A Java Future containing the result of the StartTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StartTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartTaskExecutionResponse> startTaskExecution(
            Consumer<StartTaskExecutionRequest.Builder> startTaskExecutionRequest) {
        return startTaskExecution(StartTaskExecutionRequest.builder().applyMutation(startTaskExecutionRequest).build());
    }

    /**
     * <p>
     * Stops a running DataSync discovery job.
     * </p>
     * <p>
     * You can stop a discovery job anytime. A job that's stopped before it's scheduled to end likely will provide you
     * some information about your on-premises storage system resources. To get recommendations for a stopped job, you
     * must use the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html">
     * GenerateRecommendations</a> operation.
     * </p>
     *
     * @param stopDiscoveryJobRequest
     * @return A Java Future containing the result of the StopDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StopDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StopDiscoveryJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDiscoveryJobResponse> stopDiscoveryJob(StopDiscoveryJobRequest stopDiscoveryJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running DataSync discovery job.
     * </p>
     * <p>
     * You can stop a discovery job anytime. A job that's stopped before it's scheduled to end likely will provide you
     * some information about your on-premises storage system resources. To get recommendations for a stopped job, you
     * must use the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html">
     * GenerateRecommendations</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDiscoveryJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopDiscoveryJobRequest#builder()}
     * </p>
     *
     * @param stopDiscoveryJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.StopDiscoveryJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.StopDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StopDiscoveryJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDiscoveryJobResponse> stopDiscoveryJob(
            Consumer<StopDiscoveryJobRequest.Builder> stopDiscoveryJobRequest) {
        return stopDiscoveryJob(StopDiscoveryJobRequest.builder().applyMutation(stopDiscoveryJobRequest).build());
    }

    /**
     * <p>
     * Applies a <i>tag</i> to an Amazon Web Services resource. Tags are key-value pairs that can help you manage,
     * filter, and search for your resources.
     * </p>
     * <p>
     * These include DataSync resources, such as locations, tasks, and task executions.
     * </p>
     *
     * @param tagResourceRequest
     *        TagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a <i>tag</i> to an Amazon Web Services resource. Tags are key-value pairs that can help you manage,
     * filter, and search for your resources.
     * </p>
     * <p>
     * These include DataSync resources, such as locations, tasks, and task executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.TagResourceRequest.Builder} to create a request.
     *        TagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     *        UntagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UntagResourceRequest.Builder} to create a request.
     *        UntagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name of an DataSync agent.
     * </p>
     *
     * @param updateAgentRequest
     *        UpdateAgentRequest
     * @return A Java Future containing the result of the UpdateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgentResponse> updateAgent(UpdateAgentRequest updateAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of an DataSync agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAgentRequest#builder()}
     * </p>
     *
     * @param updateAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateAgentRequest.Builder} to create a request.
     *        UpdateAgentRequest
     * @return A Java Future containing the result of the UpdateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgentResponse> updateAgent(Consumer<UpdateAgentRequest.Builder> updateAgentRequest) {
        return updateAgent(UpdateAgentRequest.builder().applyMutation(updateAgentRequest).build());
    }

    /**
     * <p>
     * Edits a DataSync discovery job configuration.
     * </p>
     *
     * @param updateDiscoveryJobRequest
     * @return A Java Future containing the result of the UpdateDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDiscoveryJobResponse> updateDiscoveryJob(UpdateDiscoveryJobRequest updateDiscoveryJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Edits a DataSync discovery job configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDiscoveryJobRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDiscoveryJobRequest#builder()}
     * </p>
     *
     * @param updateDiscoveryJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDiscoveryJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateDiscoveryJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateDiscoveryJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDiscoveryJobResponse> updateDiscoveryJob(
            Consumer<UpdateDiscoveryJobRequest.Builder> updateDiscoveryJobRequest) {
        return updateDiscoveryJob(UpdateDiscoveryJobRequest.builder().applyMutation(updateDiscoveryJobRequest).build());
    }

    /**
     * <p>
     * Modifies some configurations of the Microsoft Azure Blob Storage transfer location that you're using with
     * DataSync.
     * </p>
     *
     * @param updateLocationAzureBlobRequest
     * @return A Java Future containing the result of the UpdateLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLocationAzureBlobResponse> updateLocationAzureBlob(
            UpdateLocationAzureBlobRequest updateLocationAzureBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some configurations of the Microsoft Azure Blob Storage transfer location that you're using with
     * DataSync.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationAzureBlobRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLocationAzureBlobRequest#builder()}
     * </p>
     *
     * @param updateLocationAzureBlobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLocationAzureBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationAzureBlob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationAzureBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLocationAzureBlobResponse> updateLocationAzureBlob(
            Consumer<UpdateLocationAzureBlobRequest.Builder> updateLocationAzureBlobRequest) {
        return updateLocationAzureBlob(UpdateLocationAzureBlobRequest.builder().applyMutation(updateLocationAzureBlobRequest)
                .build());
    }

    /**
     * <p>
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     * </p>
     *
     * @param updateLocationHdfsRequest
     * @return A Java Future containing the result of the UpdateLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationHdfsResponse> updateLocationHdfs(UpdateLocationHdfsRequest updateLocationHdfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationHdfsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLocationHdfsRequest#builder()}
     * </p>
     *
     * @param updateLocationHdfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLocationHdfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationHdfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationHdfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationHdfsResponse> updateLocationHdfs(
            Consumer<UpdateLocationHdfsRequest.Builder> updateLocationHdfsRequest) {
        return updateLocationHdfs(UpdateLocationHdfsRequest.builder().applyMutation(updateLocationHdfsRequest).build());
    }

    /**
     * <p>
     * Modifies some configurations of the Network File System (NFS) transfer location that you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Configuring transfers to or
     * from an NFS file server</a>.
     * </p>
     *
     * @param updateLocationNfsRequest
     * @return A Java Future containing the result of the UpdateLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationNfsResponse> updateLocationNfs(UpdateLocationNfsRequest updateLocationNfsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some configurations of the Network File System (NFS) transfer location that you're using with DataSync.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Configuring transfers to or
     * from an NFS file server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationNfsRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationNfsRequest#builder()}
     * </p>
     *
     * @param updateLocationNfsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLocationNfs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationNfs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationNfs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationNfsResponse> updateLocationNfs(
            Consumer<UpdateLocationNfsRequest.Builder> updateLocationNfsRequest) {
        return updateLocationNfs(UpdateLocationNfsRequest.builder().applyMutation(updateLocationNfsRequest).build());
    }

    /**
     * <p>
     * Updates some parameters of an existing DataSync location for an object storage system.
     * </p>
     *
     * @param updateLocationObjectStorageRequest
     * @return A Java Future containing the result of the UpdateLocationObjectStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLocationObjectStorageResponse> updateLocationObjectStorage(
            UpdateLocationObjectStorageRequest updateLocationObjectStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some parameters of an existing DataSync location for an object storage system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationObjectStorageRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLocationObjectStorageRequest#builder()}
     * </p>
     *
     * @param updateLocationObjectStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLocationObjectStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationObjectStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationObjectStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLocationObjectStorageResponse> updateLocationObjectStorage(
            Consumer<UpdateLocationObjectStorageRequest.Builder> updateLocationObjectStorageRequest) {
        return updateLocationObjectStorage(UpdateLocationObjectStorageRequest.builder()
                .applyMutation(updateLocationObjectStorageRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters of a Server Message Block (SMB) file server location that you can use for DataSync
     * transfers.
     * </p>
     *
     * @param updateLocationSmbRequest
     * @return A Java Future containing the result of the UpdateLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationSmbResponse> updateLocationSmb(UpdateLocationSmbRequest updateLocationSmbRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters of a Server Message Block (SMB) file server location that you can use for DataSync
     * transfers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLocationSmbRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLocationSmbRequest#builder()}
     * </p>
     *
     * @param updateLocationSmbRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLocationSmb operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateLocationSmb
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateLocationSmb" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLocationSmbResponse> updateLocationSmb(
            Consumer<UpdateLocationSmbRequest.Builder> updateLocationSmbRequest) {
        return updateLocationSmb(UpdateLocationSmbRequest.builder().applyMutation(updateLocationSmbRequest).build());
    }

    /**
     * <p>
     * Modifies some configurations of an on-premises storage system resource that you're using with DataSync Discovery.
     * </p>
     *
     * @param updateStorageSystemRequest
     * @return A Java Future containing the result of the UpdateStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateStorageSystem" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStorageSystemResponse> updateStorageSystem(
            UpdateStorageSystemRequest updateStorageSystemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies some configurations of an on-premises storage system resource that you're using with DataSync Discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStorageSystemRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStorageSystemRequest#builder()}
     * </p>
     *
     * @param updateStorageSystemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStorageSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateStorageSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateStorageSystem" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStorageSystemResponse> updateStorageSystem(
            Consumer<UpdateStorageSystemRequest.Builder> updateStorageSystemRequest) {
        return updateStorageSystem(UpdateStorageSystemRequest.builder().applyMutation(updateStorageSystemRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     *
     * @param updateTaskRequest
     *        UpdateTaskResponse
     * @return A Java Future containing the result of the UpdateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskResponse> updateTask(UpdateTaskRequest updateTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a <i>task</i>, which defines where and how DataSync transfers your data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTaskRequest#builder()}
     * </p>
     *
     * @param updateTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateTaskRequest.Builder} to create a request.
     *        UpdateTaskResponse
     * @return A Java Future containing the result of the UpdateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskResponse> updateTask(Consumer<UpdateTaskRequest.Builder> updateTaskRequest) {
        return updateTask(UpdateTaskRequest.builder().applyMutation(updateTaskRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a running DataSync task execution.
     * </p>
     * <note>
     * <p>
     * Currently, the only <code>Option</code> that you can modify with <code>UpdateTaskExecution</code> is
     * <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>
     * , which throttles bandwidth for a running or queued task execution.
     * </p>
     * </note>
     *
     * @param updateTaskExecutionRequest
     * @return A Java Future containing the result of the UpdateTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTaskExecutionResponse> updateTaskExecution(
            UpdateTaskExecutionRequest updateTaskExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a running DataSync task execution.
     * </p>
     * <note>
     * <p>
     * Currently, the only <code>Option</code> that you can modify with <code>UpdateTaskExecution</code> is
     * <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>
     * , which throttles bandwidth for a running or queued task execution.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTaskExecutionRequest#builder()}
     * </p>
     *
     * @param updateTaskExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTaskExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalException This exception is thrown when an error occurs in the DataSync service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataSyncAsyncClient.UpdateTaskExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTaskExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTaskExecutionResponse> updateTaskExecution(
            Consumer<UpdateTaskExecutionRequest.Builder> updateTaskExecutionRequest) {
        return updateTaskExecution(UpdateTaskExecutionRequest.builder().applyMutation(updateTaskExecutionRequest).build());
    }

    @Override
    default DataSyncServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DataSyncAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataSyncAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataSyncAsyncClient}.
     */
    static DataSyncAsyncClientBuilder builder() {
        return new DefaultDataSyncAsyncClientBuilder();
    }
}
