/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddStorageSystemRequest extends DataSyncRequest implements
        ToCopyableBuilder<AddStorageSystemRequest.Builder, AddStorageSystemRequest> {
    private static final SdkField<DiscoveryServerConfiguration> SERVER_CONFIGURATION_FIELD = SdkField
            .<DiscoveryServerConfiguration> builder(MarshallingType.SDK_POJO).memberName("ServerConfiguration")
            .getter(getter(AddStorageSystemRequest::serverConfiguration)).setter(setter(Builder::serverConfiguration))
            .constructor(DiscoveryServerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerConfiguration").build())
            .build();

    private static final SdkField<String> SYSTEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SystemType").getter(getter(AddStorageSystemRequest::systemTypeAsString))
            .setter(setter(Builder::systemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemType").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(AddStorageSystemRequest::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(AddStorageSystemRequest::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(AddStorageSystemRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AddStorageSystemRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AddStorageSystemRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials").getter(getter(AddStorageSystemRequest::credentials)).setter(setter(Builder::credentials))
            .constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CONFIGURATION_FIELD,
            SYSTEM_TYPE_FIELD, AGENT_ARNS_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, TAGS_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD,
            CREDENTIALS_FIELD));

    private final DiscoveryServerConfiguration serverConfiguration;

    private final String systemType;

    private final List<String> agentArns;

    private final String cloudWatchLogGroupArn;

    private final List<TagListEntry> tags;

    private final String name;

    private final String clientToken;

    private final Credentials credentials;

    private AddStorageSystemRequest(BuilderImpl builder) {
        super(builder);
        this.serverConfiguration = builder.serverConfiguration;
        this.systemType = builder.systemType;
        this.agentArns = builder.agentArns;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.tags = builder.tags;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * Specifies the server name and network port required to connect with the management interface of your on-premises
     * storage system.
     * </p>
     * 
     * @return Specifies the server name and network port required to connect with the management interface of your
     *         on-premises storage system.
     */
    public final DiscoveryServerConfiguration serverConfiguration() {
        return serverConfiguration;
    }

    /**
     * <p>
     * Specifies the type of on-premises storage system that you want DataSync Discovery to collect information about.
     * </p>
     * <note>
     * <p>
     * DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems
     * running ONTAP 9.7 or later.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemType} will
     * return {@link DiscoverySystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #systemTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of on-premises storage system that you want DataSync Discovery to collect information
     *         about.</p> <note>
     *         <p>
     *         DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF)
     *         systems running ONTAP 9.7 or later.
     *         </p>
     * @see DiscoverySystemType
     */
    public final DiscoverySystemType systemType() {
        return DiscoverySystemType.fromValue(systemType);
    }

    /**
     * <p>
     * Specifies the type of on-premises storage system that you want DataSync Discovery to collect information about.
     * </p>
     * <note>
     * <p>
     * DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems
     * running ONTAP 9.7 or later.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #systemType} will
     * return {@link DiscoverySystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #systemTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of on-premises storage system that you want DataSync Discovery to collect information
     *         about.</p> <note>
     *         <p>
     *         DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF)
     *         systems running ONTAP 9.7 or later.
     *         </p>
     * @see DiscoverySystemType
     */
    public final String systemTypeAsString() {
        return systemType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your on-premises
     * storage system's management interface. You can only specify one ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your
     *         on-premises storage system's management interface. You can only specify one ARN.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
     * </p>
     * 
     * @return Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     * recommend creating at least a name tag for your on-premises storage system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     *         recommend creating at least a name tag for your on-premises storage system.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies a familiar name for your on-premises storage system.
     * </p>
     * 
     * @return Specifies a familiar name for your on-premises storage system.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a
     * client token, DataSync generates one for you automatically.
     * </p>
     * 
     * @return Specifies a client token to make sure requests with this API operation are idempotent. If you don't
     *         specify a client token, DataSync generates one for you automatically.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the user name and password for accessing your on-premises storage system's management interface.
     * </p>
     * 
     * @return Specifies the user name and password for accessing your on-premises storage system's management
     *         interface.
     */
    public final Credentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(systemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddStorageSystemRequest)) {
            return false;
        }
        AddStorageSystemRequest other = (AddStorageSystemRequest) obj;
        return Objects.equals(serverConfiguration(), other.serverConfiguration())
                && Objects.equals(systemTypeAsString(), other.systemTypeAsString()) && hasAgentArns() == other.hasAgentArns()
                && Objects.equals(agentArns(), other.agentArns())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddStorageSystemRequest").add("ServerConfiguration", serverConfiguration())
                .add("SystemType", systemTypeAsString()).add("AgentArns", hasAgentArns() ? agentArns() : null)
                .add("CloudWatchLogGroupArn", cloudWatchLogGroupArn()).add("Tags", hasTags() ? tags() : null).add("Name", name())
                .add("ClientToken", clientToken()).add("Credentials", credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerConfiguration":
            return Optional.ofNullable(clazz.cast(serverConfiguration()));
        case "SystemType":
            return Optional.ofNullable(clazz.cast(systemTypeAsString()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddStorageSystemRequest, T> g) {
        return obj -> g.apply((AddStorageSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddStorageSystemRequest> {
        /**
         * <p>
         * Specifies the server name and network port required to connect with the management interface of your
         * on-premises storage system.
         * </p>
         * 
         * @param serverConfiguration
         *        Specifies the server name and network port required to connect with the management interface of your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverConfiguration(DiscoveryServerConfiguration serverConfiguration);

        /**
         * <p>
         * Specifies the server name and network port required to connect with the management interface of your
         * on-premises storage system.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiscoveryServerConfiguration.Builder}
         * avoiding the need to create one manually via {@link DiscoveryServerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiscoveryServerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serverConfiguration(DiscoveryServerConfiguration)}.
         * 
         * @param serverConfiguration
         *        a consumer that will call methods on {@link DiscoveryServerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverConfiguration(DiscoveryServerConfiguration)
         */
        default Builder serverConfiguration(Consumer<DiscoveryServerConfiguration.Builder> serverConfiguration) {
            return serverConfiguration(DiscoveryServerConfiguration.builder().applyMutation(serverConfiguration).build());
        }

        /**
         * <p>
         * Specifies the type of on-premises storage system that you want DataSync Discovery to collect information
         * about.
         * </p>
         * <note>
         * <p>
         * DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems
         * running ONTAP 9.7 or later.
         * </p>
         * </note>
         * 
         * @param systemType
         *        Specifies the type of on-premises storage system that you want DataSync Discovery to collect
         *        information about.</p> <note>
         *        <p>
         *        DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF)
         *        systems running ONTAP 9.7 or later.
         *        </p>
         * @see DiscoverySystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoverySystemType
         */
        Builder systemType(String systemType);

        /**
         * <p>
         * Specifies the type of on-premises storage system that you want DataSync Discovery to collect information
         * about.
         * </p>
         * <note>
         * <p>
         * DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems
         * running ONTAP 9.7 or later.
         * </p>
         * </note>
         * 
         * @param systemType
         *        Specifies the type of on-premises storage system that you want DataSync Discovery to collect
         *        information about.</p> <note>
         *        <p>
         *        DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF)
         *        systems running ONTAP 9.7 or later.
         *        </p>
         * @see DiscoverySystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoverySystemType
         */
        Builder systemType(DiscoverySystemType systemType);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your
         * on-premises storage system's management interface. You can only specify one ARN.
         * </p>
         * 
         * @param agentArns
         *        Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your
         *        on-premises storage system's management interface. You can only specify one ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your
         * on-premises storage system's management interface. You can only specify one ARN.
         * </p>
         * 
         * @param agentArns
         *        Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your
         *        on-premises storage system's management interface. You can only specify one ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your on-premises storage system.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your on-premises storage system.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your on-premises storage system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * Specifies a familiar name for your on-premises storage system.
         * </p>
         * 
         * @param name
         *        Specifies a familiar name for your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a
         * client token, DataSync generates one for you automatically.
         * </p>
         * 
         * @param clientToken
         *        Specifies a client token to make sure requests with this API operation are idempotent. If you don't
         *        specify a client token, DataSync generates one for you automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the user name and password for accessing your on-premises storage system's management interface.
         * </p>
         * 
         * @param credentials
         *        Specifies the user name and password for accessing your on-premises storage system's management
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * Specifies the user name and password for accessing your on-premises storage system's management interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private DiscoveryServerConfiguration serverConfiguration;

        private String systemType;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private String cloudWatchLogGroupArn;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String clientToken;

        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AddStorageSystemRequest model) {
            super(model);
            serverConfiguration(model.serverConfiguration);
            systemType(model.systemType);
            agentArns(model.agentArns);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            tags(model.tags);
            name(model.name);
            clientToken(model.clientToken);
            credentials(model.credentials);
        }

        public final DiscoveryServerConfiguration.Builder getServerConfiguration() {
            return serverConfiguration != null ? serverConfiguration.toBuilder() : null;
        }

        public final void setServerConfiguration(DiscoveryServerConfiguration.BuilderImpl serverConfiguration) {
            this.serverConfiguration = serverConfiguration != null ? serverConfiguration.build() : null;
        }

        @Override
        public final Builder serverConfiguration(DiscoveryServerConfiguration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public final String getSystemType() {
            return systemType;
        }

        public final void setSystemType(String systemType) {
            this.systemType = systemType;
        }

        @Override
        public final Builder systemType(String systemType) {
            this.systemType = systemType;
            return this;
        }

        @Override
        public final Builder systemType(DiscoverySystemType systemType) {
            this.systemType(systemType == null ? null : systemType.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddStorageSystemRequest build() {
            return new AddStorageSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
