/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListTaskExecutionsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTaskExecutionsResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListTaskExecutionsResponse.Builder, ListTaskExecutionsResponse> {
    private static final SdkField<List<TaskExecutionListEntry>> TASK_EXECUTIONS_FIELD = SdkField
            .<List<TaskExecutionListEntry>> builder(MarshallingType.LIST)
            .getter(getter(ListTaskExecutionsResponse::taskExecutions))
            .setter(setter(Builder::taskExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskExecutionListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskExecutionListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTaskExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TaskExecutionListEntry> taskExecutions;

    private final String nextToken;

    private ListTaskExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutions = builder.taskExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of executed tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of executed tasks.
     */
    public List<TaskExecutionListEntry> taskExecutions() {
        return taskExecutions;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin returning the next list of executed tasks.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin returning the next list of executed tasks.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskExecutionsResponse)) {
            return false;
        }
        ListTaskExecutionsResponse other = (ListTaskExecutionsResponse) obj;
        return Objects.equals(taskExecutions(), other.taskExecutions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTaskExecutionsResponse").add("TaskExecutions", taskExecutions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutions":
            return Optional.ofNullable(clazz.cast(taskExecutions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskExecutionsResponse, T> g) {
        return obj -> g.apply((ListTaskExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTaskExecutionsResponse> {
        /**
         * <p>
         * A list of executed tasks.
         * </p>
         * 
         * @param taskExecutions
         *        A list of executed tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutions(Collection<TaskExecutionListEntry> taskExecutions);

        /**
         * <p>
         * A list of executed tasks.
         * </p>
         * 
         * @param taskExecutions
         *        A list of executed tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutions(TaskExecutionListEntry... taskExecutions);

        /**
         * <p>
         * A list of executed tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaskExecutionListEntry>.Builder} avoiding
         * the need to create one manually via {@link List<TaskExecutionListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskExecutionListEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #taskExecutions(List<TaskExecutionListEntry>)}.
         * 
         * @param taskExecutions
         *        a consumer that will call methods on {@link List<TaskExecutionListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskExecutions(List<TaskExecutionListEntry>)
         */
        Builder taskExecutions(Consumer<TaskExecutionListEntry.Builder>... taskExecutions);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin returning the next list of executed tasks.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates the position at which to begin returning the next list of executed
         *        tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<TaskExecutionListEntry> taskExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskExecutionsResponse model) {
            super(model);
            taskExecutions(model.taskExecutions);
            nextToken(model.nextToken);
        }

        public final Collection<TaskExecutionListEntry.Builder> getTaskExecutions() {
            return taskExecutions != null ? taskExecutions.stream().map(TaskExecutionListEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskExecutions(Collection<TaskExecutionListEntry> taskExecutions) {
            this.taskExecutions = TaskExecutionListCopier.copy(taskExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskExecutions(TaskExecutionListEntry... taskExecutions) {
            taskExecutions(Arrays.asList(taskExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskExecutions(Consumer<TaskExecutionListEntry.Builder>... taskExecutions) {
            taskExecutions(Stream.of(taskExecutions).map(c -> TaskExecutionListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTaskExecutions(Collection<TaskExecutionListEntry.BuilderImpl> taskExecutions) {
            this.taskExecutions = TaskExecutionListCopier.copyFromBuilder(taskExecutions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTaskExecutionsResponse build() {
            return new ListTaskExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
