/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that is used to access an Amazon
 * S3 bucket. For detailed information about using such a role, see <a href=
 * "https://alpha-aws-docs.aws.amazon.com/sync-service/latest/userguide/create-locations-cli.html#create-location-s3-cli"
 * >Components and Terminology</a> in the <i>AWS DataSync User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Config implements SdkPojo, Serializable, ToCopyableBuilder<S3Config.Builder, S3Config> {
    private static final SdkField<String> BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Config::bucketAccessRoleArn)).setter(setter(Builder::bucketAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketAccessRoleArn;

    private S3Config(BuilderImpl builder) {
        this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket to access. This bucket is used as a parameter in the <a>CreateLocationS3</a> operation.
     * </p>
     * 
     * @return The Amazon S3 bucket to access. This bucket is used as a parameter in the <a>CreateLocationS3</a>
     *         operation.
     */
    public String bucketAccessRoleArn() {
        return bucketAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketAccessRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config) obj;
        return Objects.equals(bucketAccessRoleArn(), other.bucketAccessRoleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("S3Config").add("BucketAccessRoleArn", bucketAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketAccessRoleArn":
            return Optional.ofNullable(clazz.cast(bucketAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Config, T> g) {
        return obj -> g.apply((S3Config) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Config> {
        /**
         * <p>
         * The Amazon S3 bucket to access. This bucket is used as a parameter in the <a>CreateLocationS3</a> operation.
         * </p>
         * 
         * @param bucketAccessRoleArn
         *        The Amazon S3 bucket to access. This bucket is used as a parameter in the <a>CreateLocationS3</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketAccessRoleArn(String bucketAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String bucketAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Config model) {
            bucketAccessRoleArn(model.bucketAccessRoleArn);
        }

        public final String getBucketAccessRoleArn() {
            return bucketAccessRoleArn;
        }

        @Override
        public final Builder bucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
            return this;
        }

        public final void setBucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
        }

        @Override
        public S3Config build() {
            return new S3Config(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
