/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationObjectStorageResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationObjectStorageResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationObjectStorageResponse.Builder, DescribeLocationObjectStorageResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationObjectStorageResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationObjectStorageResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKey").getter(getter(DescribeLocationObjectStorageResponse::accessKey))
            .setter(setter(Builder::accessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServerPort").getter(getter(DescribeLocationObjectStorageResponse::serverPort))
            .setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerProtocol").getter(getter(DescribeLocationObjectStorageResponse::serverProtocolAsString))
            .setter(setter(Builder::serverProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(DescribeLocationObjectStorageResponse::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationObjectStorageResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<SdkBytes> SERVER_CERTIFICATE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ServerCertificate").getter(getter(DescribeLocationObjectStorageResponse::serverCertificate))
            .setter(setter(Builder::serverCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, ACCESS_KEY_FIELD, SERVER_PORT_FIELD, SERVER_PROTOCOL_FIELD, AGENT_ARNS_FIELD,
            CREATION_TIME_FIELD, SERVER_CERTIFICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String locationUri;

    private final String accessKey;

    private final Integer serverPort;

    private final String serverProtocol;

    private final List<String> agentArns;

    private final Instant creationTime;

    private final SdkBytes serverCertificate;

    private DescribeLocationObjectStorageResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.accessKey = builder.accessKey;
        this.serverPort = builder.serverPort;
        this.serverProtocol = builder.serverProtocol;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
        this.serverCertificate = builder.serverCertificate;
    }

    /**
     * <p>
     * The ARN of the object storage system location.
     * </p>
     * 
     * @return The ARN of the object storage system location.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URI of the object storage system location.
     * </p>
     * 
     * @return The URI of the object storage system location.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The access key (for example, a user name) required to authenticate with the object storage system.
     * </p>
     * 
     * @return The access key (for example, a user name) required to authenticate with the object storage system.
     */
    public final String accessKey() {
        return accessKey;
    }

    /**
     * <p>
     * The port that your object storage server accepts inbound network traffic on (for example, port 443).
     * </p>
     * 
     * @return The port that your object storage server accepts inbound network traffic on (for example, port 443).
     */
    public final Integer serverPort() {
        return serverPort;
    }

    /**
     * <p>
     * The protocol that your object storage system uses to communicate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that your object storage system uses to communicate.
     * @see ObjectStorageServerProtocol
     */
    public final ObjectStorageServerProtocol serverProtocol() {
        return ObjectStorageServerProtocol.fromValue(serverProtocol);
    }

    /**
     * <p>
     * The protocol that your object storage system uses to communicate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ObjectStorageServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The protocol that your object storage system uses to communicate.
     * @see ObjectStorageServerProtocol
     */
    public final String serverProtocolAsString() {
        return serverProtocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the DataSync agents that can connect with your object storage system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return The ARNs of the DataSync agents that can connect with your object storage system.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * The time that the location was created.
     * </p>
     * 
     * @return The time that the location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The certificate chain for DataSync to authenticate with your object storage system if the system uses a private
     * or self-signed certificate authority (CA).
     * </p>
     * 
     * @return The certificate chain for DataSync to authenticate with your object storage system if the system uses a
     *         private or self-signed certificate authority (CA).
     */
    public final SdkBytes serverCertificate() {
        return serverCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationObjectStorageResponse)) {
            return false;
        }
        DescribeLocationObjectStorageResponse other = (DescribeLocationObjectStorageResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(accessKey(), other.accessKey()) && Objects.equals(serverPort(), other.serverPort())
                && Objects.equals(serverProtocolAsString(), other.serverProtocolAsString())
                && hasAgentArns() == other.hasAgentArns() && Objects.equals(agentArns(), other.agentArns())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(serverCertificate(), other.serverCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationObjectStorageResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("AccessKey", accessKey()).add("ServerPort", serverPort())
                .add("ServerProtocol", serverProtocolAsString()).add("AgentArns", hasAgentArns() ? agentArns() : null)
                .add("CreationTime", creationTime()).add("ServerCertificate", serverCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        case "ServerProtocol":
            return Optional.ofNullable(clazz.cast(serverProtocolAsString()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ServerCertificate":
            return Optional.ofNullable(clazz.cast(serverCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("AccessKey", ACCESS_KEY_FIELD);
        map.put("ServerPort", SERVER_PORT_FIELD);
        map.put("ServerProtocol", SERVER_PROTOCOL_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ServerCertificate", SERVER_CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationObjectStorageResponse, T> g) {
        return obj -> g.apply((DescribeLocationObjectStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocationObjectStorageResponse> {
        /**
         * <p>
         * The ARN of the object storage system location.
         * </p>
         * 
         * @param locationArn
         *        The ARN of the object storage system location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URI of the object storage system location.
         * </p>
         * 
         * @param locationUri
         *        The URI of the object storage system location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The access key (for example, a user name) required to authenticate with the object storage system.
         * </p>
         * 
         * @param accessKey
         *        The access key (for example, a user name) required to authenticate with the object storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(String accessKey);

        /**
         * <p>
         * The port that your object storage server accepts inbound network traffic on (for example, port 443).
         * </p>
         * 
         * @param serverPort
         *        The port that your object storage server accepts inbound network traffic on (for example, port 443).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);

        /**
         * <p>
         * The protocol that your object storage system uses to communicate.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that your object storage system uses to communicate.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(String serverProtocol);

        /**
         * <p>
         * The protocol that your object storage system uses to communicate.
         * </p>
         * 
         * @param serverProtocol
         *        The protocol that your object storage system uses to communicate.
         * @see ObjectStorageServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageServerProtocol
         */
        Builder serverProtocol(ObjectStorageServerProtocol serverProtocol);

        /**
         * <p>
         * The ARNs of the DataSync agents that can connect with your object storage system.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the DataSync agents that can connect with your object storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The ARNs of the DataSync agents that can connect with your object storage system.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the DataSync agents that can connect with your object storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The time that the location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The certificate chain for DataSync to authenticate with your object storage system if the system uses a
         * private or self-signed certificate authority (CA).
         * </p>
         * 
         * @param serverCertificate
         *        The certificate chain for DataSync to authenticate with your object storage system if the system uses
         *        a private or self-signed certificate authority (CA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificate(SdkBytes serverCertificate);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private String accessKey;

        private Integer serverPort;

        private String serverProtocol;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private SdkBytes serverCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationObjectStorageResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            accessKey(model.accessKey);
            serverPort(model.serverPort);
            serverProtocol(model.serverProtocol);
            agentArns(model.agentArns);
            creationTime(model.creationTime);
            serverCertificate(model.serverCertificate);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getAccessKey() {
            return accessKey;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final String getServerProtocol() {
            return serverProtocol;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ObjectStorageServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ByteBuffer getServerCertificate() {
            return serverCertificate == null ? null : serverCertificate.asByteBuffer();
        }

        public final void setServerCertificate(ByteBuffer serverCertificate) {
            serverCertificate(serverCertificate == null ? null : SdkBytes.fromByteBuffer(serverCertificate));
        }

        @Override
        public final Builder serverCertificate(SdkBytes serverCertificate) {
            this.serverCertificate = serverCertificate;
            return this;
        }

        @Override
        public DescribeLocationObjectStorageResponse build() {
            return new DescribeLocationObjectStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
