/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageSystemResourceMetricsRequest extends DataSyncRequest implements
        ToCopyableBuilder<DescribeStorageSystemResourceMetricsRequest.Builder, DescribeStorageSystemResourceMetricsRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(DescribeStorageSystemResourceMetricsRequest::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(DescribeStorageSystemResourceMetricsRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(DescribeStorageSystemResourceMetricsRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeStorageSystemResourceMetricsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeStorageSystemResourceMetricsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeStorageSystemResourceMetricsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStorageSystemResourceMetricsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discoveryJobArn;

    private final String resourceType;

    private final String resourceId;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeStorageSystemResourceMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your on-premises
     * storage system.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
     *         on-premises storage system.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * <p>
     * Specifies the kind of storage system resource that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the kind of storage system resource that you want information about.
     * @see DiscoveryResourceType
     */
    public final DiscoveryResourceType resourceType() {
        return DiscoveryResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the kind of storage system resource that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the kind of storage system resource that you want information about.
     * @see DiscoveryResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies the universally unique identifier (UUID) of the storage system resource that you want information
     * about.
     * </p>
     * 
     * @return Specifies the universally unique identifier (UUID) of the storage system resource that you want
     *         information about.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specifies a time within the total duration that the discovery job ran. To see information gathered during a
     * certain time frame, use this parameter with <code>EndTime</code>.
     * </p>
     * 
     * @return Specifies a time within the total duration that the discovery job ran. To see information gathered during
     *         a certain time frame, use this parameter with <code>EndTime</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Specifies a time within the total duration that the discovery job ran. To see information gathered during a
     * certain time frame, use this parameter with <code>StartTime</code>.
     * </p>
     * 
     * @return Specifies a time within the total duration that the discovery job ran. To see information gathered during
     *         a certain time frame, use this parameter with <code>StartTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Specifies how many results that you want in the response.
     * </p>
     * 
     * @return Specifies how many results that you want in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies an opaque string that indicates the position to begin the next list of results in the response.
     * </p>
     * 
     * @return Specifies an opaque string that indicates the position to begin the next list of results in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourceMetricsRequest)) {
            return false;
        }
        DescribeStorageSystemResourceMetricsRequest other = (DescribeStorageSystemResourceMetricsRequest) obj;
        return Objects.equals(discoveryJobArn(), other.discoveryJobArn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageSystemResourceMetricsRequest").add("DiscoveryJobArn", discoveryJobArn())
                .add("ResourceType", resourceTypeAsString()).add("ResourceId", resourceId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResourceMetricsRequest, T> g) {
        return obj -> g.apply((DescribeStorageSystemResourceMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorageSystemResourceMetricsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
         * on-premises storage system.
         * </p>
         * 
         * @param discoveryJobArn
         *        Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * Specifies the kind of storage system resource that you want information about.
         * </p>
         * 
         * @param resourceType
         *        Specifies the kind of storage system resource that you want information about.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the kind of storage system resource that you want information about.
         * </p>
         * 
         * @param resourceType
         *        Specifies the kind of storage system resource that you want information about.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(DiscoveryResourceType resourceType);

        /**
         * <p>
         * Specifies the universally unique identifier (UUID) of the storage system resource that you want information
         * about.
         * </p>
         * 
         * @param resourceId
         *        Specifies the universally unique identifier (UUID) of the storage system resource that you want
         *        information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specifies a time within the total duration that the discovery job ran. To see information gathered during a
         * certain time frame, use this parameter with <code>EndTime</code>.
         * </p>
         * 
         * @param startTime
         *        Specifies a time within the total duration that the discovery job ran. To see information gathered
         *        during a certain time frame, use this parameter with <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Specifies a time within the total duration that the discovery job ran. To see information gathered during a
         * certain time frame, use this parameter with <code>StartTime</code>.
         * </p>
         * 
         * @param endTime
         *        Specifies a time within the total duration that the discovery job ran. To see information gathered
         *        during a certain time frame, use this parameter with <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Specifies how many results that you want in the response.
         * </p>
         * 
         * @param maxResults
         *        Specifies how many results that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies an opaque string that indicates the position to begin the next list of results in the response.
         * </p>
         * 
         * @param nextToken
         *        Specifies an opaque string that indicates the position to begin the next list of results in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String discoveryJobArn;

        private String resourceType;

        private String resourceId;

        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResourceMetricsRequest model) {
            super(model);
            discoveryJobArn(model.discoveryJobArn);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DiscoveryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorageSystemResourceMetricsRequest build() {
            return new DescribeStorageSystemResourceMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
