/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageSystemResourcesRequest extends DataSyncRequest implements
        ToCopyableBuilder<DescribeStorageSystemResourcesRequest.Builder, DescribeStorageSystemResourcesRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(DescribeStorageSystemResourcesRequest::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(DescribeStorageSystemResourcesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIds")
            .getter(getter(DescribeStorageSystemResourcesRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> FILTER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Filter")
            .getter(getter(DescribeStorageSystemResourcesRequest::filterAsStrings))
            .setter(setter(Builder::filterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeStorageSystemResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStorageSystemResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_IDS_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discoveryJobArn;

    private final String resourceType;

    private final List<String> resourceIds;

    private final Map<String, List<String>> filter;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeStorageSystemResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the discovery job that's collecting data from your on-premises
     * storage system.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the discovery job that's collecting data from your
     *         on-premises storage system.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * <p>
     * Specifies what kind of storage system resources that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies what kind of storage system resources that you want information about.
     * @see DiscoveryResourceType
     */
    public final DiscoveryResourceType resourceType() {
        return DiscoveryResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies what kind of storage system resources that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies what kind of storage system resources that you want information about.
     * @see DiscoveryResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want information
     * about. You can't use this parameter in combination with the <code>Filter</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want
     *         information about. You can't use this parameter in combination with the <code>Filter</code> parameter.
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * Filters the storage system resources that you want returned. For example, this might be volumes associated with a
     * specific storage virtual machine (SVM).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filters the storage system resources that you want returned. For example, this might be volumes
     *         associated with a specific storage virtual machine (SVM).
     */
    public final Map<DiscoveryResourceFilter, List<String>> filter() {
        return ResourceFiltersCopier.copyStringToEnum(filter);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filters the storage system resources that you want returned. For example, this might be volumes associated with a
     * specific storage virtual machine (SVM).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filters the storage system resources that you want returned. For example, this might be volumes
     *         associated with a specific storage virtual machine (SVM).
     */
    public final Map<String, List<String>> filterAsStrings() {
        return filter;
    }

    /**
     * <p>
     * Specifies the maximum number of storage system resources that you want to list in a response.
     * </p>
     * 
     * @return Specifies the maximum number of storage system resources that you want to list in a response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies an opaque string that indicates the position to begin the next list of results in the response.
     * </p>
     * 
     * @return Specifies an opaque string that indicates the position to begin the next list of results in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourcesRequest)) {
            return false;
        }
        DescribeStorageSystemResourcesRequest other = (DescribeStorageSystemResourcesRequest) obj;
        return Objects.equals(discoveryJobArn(), other.discoveryJobArn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasResourceIds() == other.hasResourceIds() && Objects.equals(resourceIds(), other.resourceIds())
                && hasFilter() == other.hasFilter() && Objects.equals(filterAsStrings(), other.filterAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageSystemResourcesRequest").add("DiscoveryJobArn", discoveryJobArn())
                .add("ResourceType", resourceTypeAsString()).add("ResourceIds", hasResourceIds() ? resourceIds() : null)
                .add("Filter", hasFilter() ? filterAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceIds", RESOURCE_IDS_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResourcesRequest, T> g) {
        return obj -> g.apply((DescribeStorageSystemResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorageSystemResourcesRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the discovery job that's collecting data from your on-premises
         * storage system.
         * </p>
         * 
         * @param discoveryJobArn
         *        Specifies the Amazon Resource Name (ARN) of the discovery job that's collecting data from your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * Specifies what kind of storage system resources that you want information about.
         * </p>
         * 
         * @param resourceType
         *        Specifies what kind of storage system resources that you want information about.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies what kind of storage system resources that you want information about.
         * </p>
         * 
         * @param resourceType
         *        Specifies what kind of storage system resources that you want information about.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(DiscoveryResourceType resourceType);

        /**
         * <p>
         * Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want
         * information about. You can't use this parameter in combination with the <code>Filter</code> parameter.
         * </p>
         * 
         * @param resourceIds
         *        Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want
         *        information about. You can't use this parameter in combination with the <code>Filter</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want
         * information about. You can't use this parameter in combination with the <code>Filter</code> parameter.
         * </p>
         * 
         * @param resourceIds
         *        Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want
         *        information about. You can't use this parameter in combination with the <code>Filter</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * Filters the storage system resources that you want returned. For example, this might be volumes associated
         * with a specific storage virtual machine (SVM).
         * </p>
         * 
         * @param filter
         *        Filters the storage system resources that you want returned. For example, this might be volumes
         *        associated with a specific storage virtual machine (SVM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterWithStrings(Map<String, ? extends Collection<String>> filter);

        /**
         * <p>
         * Filters the storage system resources that you want returned. For example, this might be volumes associated
         * with a specific storage virtual machine (SVM).
         * </p>
         * 
         * @param filter
         *        Filters the storage system resources that you want returned. For example, this might be volumes
         *        associated with a specific storage virtual machine (SVM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<DiscoveryResourceFilter, ? extends Collection<String>> filter);

        /**
         * <p>
         * Specifies the maximum number of storage system resources that you want to list in a response.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of storage system resources that you want to list in a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies an opaque string that indicates the position to begin the next list of results in the response.
         * </p>
         * 
         * @param nextToken
         *        Specifies an opaque string that indicates the position to begin the next list of results in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String discoveryJobArn;

        private String resourceType;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> filter = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResourcesRequest model) {
            super(model);
            discoveryJobArn(model.discoveryJobArn);
            resourceType(model.resourceType);
            resourceIds(model.resourceIds);
            filterWithStrings(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DiscoveryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilter() {
            if (filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return filter;
        }

        public final void setFilter(Map<String, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Map<String, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<DiscoveryResourceFilter, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copyEnumToString(filter);
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorageSystemResourcesRequest build() {
            return new DescribeStorageSystemResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
