/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about a specific DataSync discovery job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoveryJobListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscoveryJobListEntry.Builder, DiscoveryJobListEntry> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(DiscoveryJobListEntry::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DiscoveryJobListEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String discoveryJobArn;

    private final String status;

    private DiscoveryJobListEntry(BuilderImpl builder) {
        this.discoveryJobArn = builder.discoveryJobArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a discovery job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a discovery job.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * <p>
     * The status of a discovery job. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     * >Discovery job statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DiscoveryJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a discovery job. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     *         >Discovery job statuses</a>.
     * @see DiscoveryJobStatus
     */
    public final DiscoveryJobStatus status() {
        return DiscoveryJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a discovery job. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     * >Discovery job statuses</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DiscoveryJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a discovery job. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
     *         >Discovery job statuses</a>.
     * @see DiscoveryJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveryJobListEntry)) {
            return false;
        }
        DiscoveryJobListEntry other = (DiscoveryJobListEntry) obj;
        return Objects.equals(discoveryJobArn(), other.discoveryJobArn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoveryJobListEntry").add("DiscoveryJobArn", discoveryJobArn())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoveryJobListEntry, T> g) {
        return obj -> g.apply((DiscoveryJobListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscoveryJobListEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a discovery job.
         * </p>
         * 
         * @param discoveryJobArn
         *        The Amazon Resource Name (ARN) of a discovery job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * The status of a discovery job. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         * >Discovery job statuses</a>.
         * </p>
         * 
         * @param status
         *        The status of a discovery job. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         *        >Discovery job statuses</a>.
         * @see DiscoveryJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a discovery job. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         * >Discovery job statuses</a>.
         * </p>
         * 
         * @param status
         *        The status of a discovery job. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table"
         *        >Discovery job statuses</a>.
         * @see DiscoveryJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryJobStatus
         */
        Builder status(DiscoveryJobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String discoveryJobArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveryJobListEntry model) {
            discoveryJobArn(model.discoveryJobArn);
            status(model.status);
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DiscoveryJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DiscoveryJobListEntry build() {
            return new DiscoveryJobListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
