/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network settings that DataSync Discovery uses to connect with your on-premises storage system's management
 * interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoveryServerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscoveryServerConfiguration.Builder, DiscoveryServerConfiguration> {
    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerHostname").getter(getter(DiscoveryServerConfiguration::serverHostname))
            .setter(setter(Builder::serverHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServerPort").getter(getter(DiscoveryServerConfiguration::serverPort))
            .setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_HOSTNAME_FIELD,
            SERVER_PORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverHostname;

    private final Integer serverPort;

    private DiscoveryServerConfiguration(BuilderImpl builder) {
        this.serverHostname = builder.serverHostname;
        this.serverPort = builder.serverPort;
    }

    /**
     * <p>
     * The domain name or IP address of your storage system's management interface.
     * </p>
     * 
     * @return The domain name or IP address of your storage system's management interface.
     */
    public final String serverHostname() {
        return serverHostname;
    }

    /**
     * <p>
     * The network port for accessing the storage system's management interface.
     * </p>
     * 
     * @return The network port for accessing the storage system's management interface.
     */
    public final Integer serverPort() {
        return serverPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveryServerConfiguration)) {
            return false;
        }
        DiscoveryServerConfiguration other = (DiscoveryServerConfiguration) obj;
        return Objects.equals(serverHostname(), other.serverHostname()) && Objects.equals(serverPort(), other.serverPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoveryServerConfiguration").add("ServerHostname", serverHostname())
                .add("ServerPort", serverPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerHostname":
            return Optional.ofNullable(clazz.cast(serverHostname()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerHostname", SERVER_HOSTNAME_FIELD);
        map.put("ServerPort", SERVER_PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoveryServerConfiguration, T> g) {
        return obj -> g.apply((DiscoveryServerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscoveryServerConfiguration> {
        /**
         * <p>
         * The domain name or IP address of your storage system's management interface.
         * </p>
         * 
         * @param serverHostname
         *        The domain name or IP address of your storage system's management interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverHostname(String serverHostname);

        /**
         * <p>
         * The network port for accessing the storage system's management interface.
         * </p>
         * 
         * @param serverPort
         *        The network port for accessing the storage system's management interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);
    }

    static final class BuilderImpl implements Builder {
        private String serverHostname;

        private Integer serverPort;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveryServerConfiguration model) {
            serverHostname(model.serverHostname);
            serverPort(model.serverPort);
        }

        public final String getServerHostname() {
            return serverHostname;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public DiscoveryServerConfiguration build() {
            return new DiscoveryServerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
