/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateRecommendationsRequest extends DataSyncRequest implements
        ToCopyableBuilder<GenerateRecommendationsRequest.Builder, GenerateRecommendationsRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(GenerateRecommendationsRequest::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIds")
            .getter(getter(GenerateRecommendationsRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GenerateRecommendationsRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD,
            RESOURCE_IDS_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discoveryJobArn;

    private final List<String> resourceIds;

    private final String resourceType;

    private GenerateRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your on-premises
     * storage system.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
     *         on-premises storage system.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you want
     * recommendations on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you
     *         want recommendations on.
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * Specifies the type of resource in your storage system that you want recommendations on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource in your storage system that you want recommendations on.
     * @see DiscoveryResourceType
     */
    public final DiscoveryResourceType resourceType() {
        return DiscoveryResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource in your storage system that you want recommendations on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DiscoveryResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource in your storage system that you want recommendations on.
     * @see DiscoveryResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRecommendationsRequest)) {
            return false;
        }
        GenerateRecommendationsRequest other = (GenerateRecommendationsRequest) obj;
        return Objects.equals(discoveryJobArn(), other.discoveryJobArn()) && hasResourceIds() == other.hasResourceIds()
                && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateRecommendationsRequest").add("DiscoveryJobArn", discoveryJobArn())
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("ResourceIds", RESOURCE_IDS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateRecommendationsRequest, T> g) {
        return obj -> g.apply((GenerateRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateRecommendationsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
         * on-premises storage system.
         * </p>
         * 
         * @param discoveryJobArn
         *        Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you want
         * recommendations on.
         * </p>
         * 
         * @param resourceIds
         *        Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you
         *        want recommendations on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you want
         * recommendations on.
         * </p>
         * 
         * @param resourceIds
         *        Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you
         *        want recommendations on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * Specifies the type of resource in your storage system that you want recommendations on.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource in your storage system that you want recommendations on.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource in your storage system that you want recommendations on.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource in your storage system that you want recommendations on.
         * @see DiscoveryResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryResourceType
         */
        Builder resourceType(DiscoveryResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String discoveryJobArn;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRecommendationsRequest model) {
            super(model);
            discoveryJobArn(model.discoveryJobArn);
            resourceIds(model.resourceIds);
            resourceType(model.resourceType);
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DiscoveryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateRecommendationsRequest build() {
            return new GenerateRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
