/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value
 * during a 1-hour interval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IOPS implements SdkPojo, Serializable, ToCopyableBuilder<IOPS.Builder, IOPS> {
    private static final SdkField<Double> READ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Read")
            .getter(getter(IOPS::read)).setter(setter(Builder::read))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Read").build()).build();

    private static final SdkField<Double> WRITE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Write")
            .getter(getter(IOPS::write)).setter(setter(Builder::write))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Write").build()).build();

    private static final SdkField<Double> OTHER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Other")
            .getter(getter(IOPS::other)).setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build()).build();

    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Total")
            .getter(getter(IOPS::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_FIELD, WRITE_FIELD,
            OTHER_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double read;

    private final Double write;

    private final Double other;

    private final Double total;

    private IOPS(BuilderImpl builder) {
        this.read = builder.read;
        this.write = builder.write;
        this.other = builder.other;
        this.total = builder.total;
    }

    /**
     * <p>
     * Peak IOPS related to read operations.
     * </p>
     * 
     * @return Peak IOPS related to read operations.
     */
    public final Double read() {
        return read;
    }

    /**
     * <p>
     * Peak IOPS related to write operations.
     * </p>
     * 
     * @return Peak IOPS related to write operations.
     */
    public final Double write() {
        return write;
    }

    /**
     * <p>
     * Peak IOPS unrelated to read and write operations.
     * </p>
     * 
     * @return Peak IOPS unrelated to read and write operations.
     */
    public final Double other() {
        return other;
    }

    /**
     * <p>
     * Peak total IOPS on your on-premises storage system resource.
     * </p>
     * 
     * @return Peak total IOPS on your on-premises storage system resource.
     */
    public final Double total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(read());
        hashCode = 31 * hashCode + Objects.hashCode(write());
        hashCode = 31 * hashCode + Objects.hashCode(other());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IOPS)) {
            return false;
        }
        IOPS other = (IOPS) obj;
        return Objects.equals(read(), other.read()) && Objects.equals(write(), other.write())
                && Objects.equals(other(), other.other()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IOPS").add("Read", read()).add("Write", write()).add("Other", other()).add("Total", total())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Read":
            return Optional.ofNullable(clazz.cast(read()));
        case "Write":
            return Optional.ofNullable(clazz.cast(write()));
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Read", READ_FIELD);
        map.put("Write", WRITE_FIELD);
        map.put("Other", OTHER_FIELD);
        map.put("Total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IOPS, T> g) {
        return obj -> g.apply((IOPS) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IOPS> {
        /**
         * <p>
         * Peak IOPS related to read operations.
         * </p>
         * 
         * @param read
         *        Peak IOPS related to read operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder read(Double read);

        /**
         * <p>
         * Peak IOPS related to write operations.
         * </p>
         * 
         * @param write
         *        Peak IOPS related to write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder write(Double write);

        /**
         * <p>
         * Peak IOPS unrelated to read and write operations.
         * </p>
         * 
         * @param other
         *        Peak IOPS unrelated to read and write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Double other);

        /**
         * <p>
         * Peak total IOPS on your on-premises storage system resource.
         * </p>
         * 
         * @param total
         *        Peak total IOPS on your on-premises storage system resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);
    }

    static final class BuilderImpl implements Builder {
        private Double read;

        private Double write;

        private Double other;

        private Double total;

        private BuilderImpl() {
        }

        private BuilderImpl(IOPS model) {
            read(model.read);
            write(model.write);
            other(model.other);
            total(model.total);
        }

        public final Double getRead() {
            return read;
        }

        public final void setRead(Double read) {
            this.read = read;
        }

        @Override
        public final Builder read(Double read) {
            this.read = read;
            return this;
        }

        public final Double getWrite() {
            return write;
        }

        public final void setWrite(Double write) {
            this.write = write;
        }

        @Override
        public final Builder write(Double write) {
            this.write = write;
            return this;
        }

        public final Double getOther() {
            return other;
        }

        public final void setOther(Double other) {
            this.other = other;
        }

        @Override
        public final Builder other(Double other) {
            this.other = other;
            return this;
        }

        public final Double getTotal() {
            return total;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        @Override
        public IOPS build() {
            return new IOPS(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
