/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStorageSystemsResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListStorageSystemsResponse.Builder, ListStorageSystemsResponse> {
    private static final SdkField<List<StorageSystemListEntry>> STORAGE_SYSTEMS_FIELD = SdkField
            .<List<StorageSystemListEntry>> builder(MarshallingType.LIST)
            .memberName("StorageSystems")
            .getter(getter(ListStorageSystemsResponse::storageSystems))
            .setter(setter(Builder::storageSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageSystemListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageSystemListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStorageSystemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StorageSystemListEntry> storageSystems;

    private final String nextToken;

    private ListStorageSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.storageSystems = builder.storageSystems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageSystems() {
        return storageSystems != null && !(storageSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync Discovery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageSystems} method.
     * </p>
     * 
     * @return The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync
     *         Discovery.
     */
    public final List<StorageSystemListEntry> storageSystems() {
        return storageSystems;
    }

    /**
     * <p>
     * The opaque string that indicates the position to begin the next list of results in the response.
     * </p>
     * 
     * @return The opaque string that indicates the position to begin the next list of results in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageSystems() ? storageSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageSystemsResponse)) {
            return false;
        }
        ListStorageSystemsResponse other = (ListStorageSystemsResponse) obj;
        return hasStorageSystems() == other.hasStorageSystems() && Objects.equals(storageSystems(), other.storageSystems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStorageSystemsResponse")
                .add("StorageSystems", hasStorageSystems() ? storageSystems() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageSystems":
            return Optional.ofNullable(clazz.cast(storageSystems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageSystems", STORAGE_SYSTEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStorageSystemsResponse, T> g) {
        return obj -> g.apply((ListStorageSystemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStorageSystemsResponse> {
        /**
         * <p>
         * The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync Discovery.
         * </p>
         * 
         * @param storageSystems
         *        The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync
         *        Discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSystems(Collection<StorageSystemListEntry> storageSystems);

        /**
         * <p>
         * The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync Discovery.
         * </p>
         * 
         * @param storageSystems
         *        The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync
         *        Discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSystems(StorageSystemListEntry... storageSystems);

        /**
         * <p>
         * The Amazon Resource Names ARNs) of the on-premises storage systems that you're using with DataSync Discovery.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.StorageSystemListEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datasync.model.StorageSystemListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.StorageSystemListEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #storageSystems(List<StorageSystemListEntry>)}.
         * 
         * @param storageSystems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.StorageSystemListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageSystems(java.util.Collection<StorageSystemListEntry>)
         */
        Builder storageSystems(Consumer<StorageSystemListEntry.Builder>... storageSystems);

        /**
         * <p>
         * The opaque string that indicates the position to begin the next list of results in the response.
         * </p>
         * 
         * @param nextToken
         *        The opaque string that indicates the position to begin the next list of results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<StorageSystemListEntry> storageSystems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageSystemsResponse model) {
            super(model);
            storageSystems(model.storageSystems);
            nextToken(model.nextToken);
        }

        public final List<StorageSystemListEntry.Builder> getStorageSystems() {
            List<StorageSystemListEntry.Builder> result = StorageSystemListCopier.copyToBuilder(this.storageSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageSystems(Collection<StorageSystemListEntry.BuilderImpl> storageSystems) {
            this.storageSystems = StorageSystemListCopier.copyFromBuilder(storageSystems);
        }

        @Override
        public final Builder storageSystems(Collection<StorageSystemListEntry> storageSystems) {
            this.storageSystems = StorageSystemListCopier.copy(storageSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSystems(StorageSystemListEntry... storageSystems) {
            storageSystems(Arrays.asList(storageSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSystems(Consumer<StorageSystemListEntry.Builder>... storageSystems) {
            storageSystems(Stream.of(storageSystems).map(c -> StorageSystemListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStorageSystemsResponse build() {
            return new ListStorageSystemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
