/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how DataSync can access a location using the NFS protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NfsMountOptions implements SdkPojo, Serializable, ToCopyableBuilder<NfsMountOptions.Builder, NfsMountOptions> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(NfsMountOptions::versionAsString)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private NfsMountOptions(BuilderImpl builder) {
        this.version = builder.version;
    }

    /**
     * <p>
     * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses to
     * use the version specified, the task fails.
     * </p>
     * <p>
     * You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo file
     * systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and parallel data
     * processing. NFS version 4.1 also includes all features available in version 4.0.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link NfsVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server
     *         refuses to use the version specified, the task fails.</p>
     *         <p>
     *         You can specify the following options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo
     *         file systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and
     *         parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
     *         </p>
     * @see NfsVersion
     */
    public final NfsVersion version() {
        return NfsVersion.fromValue(version);
    }

    /**
     * <p>
     * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses to
     * use the version specified, the task fails.
     * </p>
     * <p>
     * You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo file
     * systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and parallel data
     * processing. NFS version 4.1 also includes all features available in version 4.0.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link NfsVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server
     *         refuses to use the version specified, the task fails.</p>
     *         <p>
     *         You can specify the following options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo
     *         file systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and
     *         parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
     *         </p>
     * @see NfsVersion
     */
    public final String versionAsString() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NfsMountOptions)) {
            return false;
        }
        NfsMountOptions other = (NfsMountOptions) obj;
        return Objects.equals(versionAsString(), other.versionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NfsMountOptions").add("Version", versionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(versionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NfsMountOptions, T> g) {
        return obj -> g.apply((NfsMountOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NfsMountOptions> {
        /**
         * <p>
         * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses
         * to use the version specified, the task fails.
         * </p>
         * <p>
         * You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo file
         * systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and parallel
         * data processing. NFS version 4.1 also includes all features available in version 4.0.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
         * </p>
         * </note>
         * 
         * @param version
         *        Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server
         *        refuses to use the version specified, the task fails.</p>
         *        <p>
         *        You can specify the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and
         *        pseudo file systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and
         *        parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
         *        </p>
         * @see NfsVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NfsVersion
         */
        Builder version(String version);

        /**
         * <p>
         * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses
         * to use the version specified, the task fails.
         * </p>
         * <p>
         * You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo file
         * systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and parallel
         * data processing. NFS version 4.1 also includes all features available in version 4.0.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
         * </p>
         * </note>
         * 
         * @param version
         *        Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server
         *        refuses to use the version specified, the task fails.</p>
         *        <p>
         *        You can specify the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and
         *        pseudo file systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and
         *        parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
         *        </p>
         * @see NfsVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NfsVersion
         */
        Builder version(NfsVersion version);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(NfsMountOptions model) {
            version(model.version);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(NfsVersion version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        @Override
        public NfsMountOptions build() {
            return new NfsMountOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
