/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether DataSync created a complete <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your transfer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportResult implements SdkPojo, Serializable, ToCopyableBuilder<ReportResult.Builder, ReportResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReportResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ReportResult::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDetail").getter(getter(ReportResult::errorDetail)).setter(setter(Builder::errorDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ERROR_CODE_FIELD, ERROR_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String errorCode;

    private final String errorDetail;

    private ReportResult(BuilderImpl builder) {
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * <p>
     * Indicates whether DataSync is still working on your report, created a report, or can't create a complete report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether DataSync is still working on your report, created a report, or can't create a complete
     *         report.
     * @see PhaseStatus
     */
    public final PhaseStatus status() {
        return PhaseStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether DataSync is still working on your report, created a report, or can't create a complete report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether DataSync is still working on your report, created a report, or can't create a complete
     *         report.
     * @see PhaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates the code associated with the error if DataSync can't create a complete report.
     * </p>
     * 
     * @return Indicates the code associated with the error if DataSync can't create a complete report.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * Provides details about issues creating a report.
     * </p>
     * 
     * @return Provides details about issues creating a report.
     */
    public final String errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportResult)) {
            return false;
        }
        ReportResult other = (ReportResult) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportResult").add("Status", statusAsString()).add("ErrorCode", errorCode())
                .add("ErrorDetail", errorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorDetail", ERROR_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportResult, T> g) {
        return obj -> g.apply((ReportResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportResult> {
        /**
         * <p>
         * Indicates whether DataSync is still working on your report, created a report, or can't create a complete
         * report.
         * </p>
         * 
         * @param status
         *        Indicates whether DataSync is still working on your report, created a report, or can't create a
         *        complete report.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether DataSync is still working on your report, created a report, or can't create a complete
         * report.
         * </p>
         * 
         * @param status
         *        Indicates whether DataSync is still working on your report, created a report, or can't create a
         *        complete report.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder status(PhaseStatus status);

        /**
         * <p>
         * Indicates the code associated with the error if DataSync can't create a complete report.
         * </p>
         * 
         * @param errorCode
         *        Indicates the code associated with the error if DataSync can't create a complete report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Provides details about issues creating a report.
         * </p>
         * 
         * @param errorDetail
         *        Provides details about issues creating a report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(String errorDetail);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String errorCode;

        private String errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportResult model) {
            status(model.status);
            errorCode(model.errorCode);
            errorDetail(model.errorDetail);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorDetail() {
            return errorDetail;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        @Override
        public ReportResult build() {
            return new ReportResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
