/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information provided by DataSync Discovery about the resources in your on-premises storage system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<List<NetAppONTAPSVM>> NET_APP_ONTAPSV_MS_FIELD = SdkField
            .<List<NetAppONTAPSVM>> builder(MarshallingType.LIST)
            .memberName("NetAppONTAPSVMs")
            .getter(getter(ResourceDetails::netAppONTAPSVMs))
            .setter(setter(Builder::netAppONTAPSVMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetAppONTAPSVMs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetAppONTAPSVM> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetAppONTAPSVM::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetAppONTAPVolume>> NET_APP_ONTAP_VOLUMES_FIELD = SdkField
            .<List<NetAppONTAPVolume>> builder(MarshallingType.LIST)
            .memberName("NetAppONTAPVolumes")
            .getter(getter(ResourceDetails::netAppONTAPVolumes))
            .setter(setter(Builder::netAppONTAPVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetAppONTAPVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetAppONTAPVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetAppONTAPVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetAppONTAPCluster>> NET_APP_ONTAP_CLUSTERS_FIELD = SdkField
            .<List<NetAppONTAPCluster>> builder(MarshallingType.LIST)
            .memberName("NetAppONTAPClusters")
            .getter(getter(ResourceDetails::netAppONTAPClusters))
            .setter(setter(Builder::netAppONTAPClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetAppONTAPClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetAppONTAPCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetAppONTAPCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NET_APP_ONTAPSV_MS_FIELD,
            NET_APP_ONTAP_VOLUMES_FIELD, NET_APP_ONTAP_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<NetAppONTAPSVM> netAppONTAPSVMs;

    private final List<NetAppONTAPVolume> netAppONTAPVolumes;

    private final List<NetAppONTAPCluster> netAppONTAPClusters;

    private ResourceDetails(BuilderImpl builder) {
        this.netAppONTAPSVMs = builder.netAppONTAPSVMs;
        this.netAppONTAPVolumes = builder.netAppONTAPVolumes;
        this.netAppONTAPClusters = builder.netAppONTAPClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetAppONTAPSVMs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetAppONTAPSVMs() {
        return netAppONTAPSVMs != null && !(netAppONTAPSVMs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information that DataSync Discovery collects about storage virtual machines (SVMs) in your on-premises
     * storage system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetAppONTAPSVMs} method.
     * </p>
     * 
     * @return The information that DataSync Discovery collects about storage virtual machines (SVMs) in your
     *         on-premises storage system.
     */
    public final List<NetAppONTAPSVM> netAppONTAPSVMs() {
        return netAppONTAPSVMs;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetAppONTAPVolumes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetAppONTAPVolumes() {
        return netAppONTAPVolumes != null && !(netAppONTAPVolumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information that DataSync Discovery collects about volumes in your on-premises storage system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetAppONTAPVolumes} method.
     * </p>
     * 
     * @return The information that DataSync Discovery collects about volumes in your on-premises storage system.
     */
    public final List<NetAppONTAPVolume> netAppONTAPVolumes() {
        return netAppONTAPVolumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetAppONTAPClusters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetAppONTAPClusters() {
        return netAppONTAPClusters != null && !(netAppONTAPClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information that DataSync Discovery collects about the cluster in your on-premises storage system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetAppONTAPClusters} method.
     * </p>
     * 
     * @return The information that DataSync Discovery collects about the cluster in your on-premises storage system.
     */
    public final List<NetAppONTAPCluster> netAppONTAPClusters() {
        return netAppONTAPClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNetAppONTAPSVMs() ? netAppONTAPSVMs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetAppONTAPVolumes() ? netAppONTAPVolumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetAppONTAPClusters() ? netAppONTAPClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return hasNetAppONTAPSVMs() == other.hasNetAppONTAPSVMs() && Objects.equals(netAppONTAPSVMs(), other.netAppONTAPSVMs())
                && hasNetAppONTAPVolumes() == other.hasNetAppONTAPVolumes()
                && Objects.equals(netAppONTAPVolumes(), other.netAppONTAPVolumes())
                && hasNetAppONTAPClusters() == other.hasNetAppONTAPClusters()
                && Objects.equals(netAppONTAPClusters(), other.netAppONTAPClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDetails").add("NetAppONTAPSVMs", hasNetAppONTAPSVMs() ? netAppONTAPSVMs() : null)
                .add("NetAppONTAPVolumes", hasNetAppONTAPVolumes() ? netAppONTAPVolumes() : null)
                .add("NetAppONTAPClusters", hasNetAppONTAPClusters() ? netAppONTAPClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetAppONTAPSVMs":
            return Optional.ofNullable(clazz.cast(netAppONTAPSVMs()));
        case "NetAppONTAPVolumes":
            return Optional.ofNullable(clazz.cast(netAppONTAPVolumes()));
        case "NetAppONTAPClusters":
            return Optional.ofNullable(clazz.cast(netAppONTAPClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetAppONTAPSVMs", NET_APP_ONTAPSV_MS_FIELD);
        map.put("NetAppONTAPVolumes", NET_APP_ONTAP_VOLUMES_FIELD);
        map.put("NetAppONTAPClusters", NET_APP_ONTAP_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * The information that DataSync Discovery collects about storage virtual machines (SVMs) in your on-premises
         * storage system.
         * </p>
         * 
         * @param netAppONTAPSVMs
         *        The information that DataSync Discovery collects about storage virtual machines (SVMs) in your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPSVMs(Collection<NetAppONTAPSVM> netAppONTAPSVMs);

        /**
         * <p>
         * The information that DataSync Discovery collects about storage virtual machines (SVMs) in your on-premises
         * storage system.
         * </p>
         * 
         * @param netAppONTAPSVMs
         *        The information that DataSync Discovery collects about storage virtual machines (SVMs) in your
         *        on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPSVMs(NetAppONTAPSVM... netAppONTAPSVMs);

        /**
         * <p>
         * The information that DataSync Discovery collects about storage virtual machines (SVMs) in your on-premises
         * storage system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM.Builder#build()} is called immediately
         * and its result is passed to {@link #netAppONTAPSVMs(List<NetAppONTAPSVM>)}.
         * 
         * @param netAppONTAPSVMs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #netAppONTAPSVMs(java.util.Collection<NetAppONTAPSVM>)
         */
        Builder netAppONTAPSVMs(Consumer<NetAppONTAPSVM.Builder>... netAppONTAPSVMs);

        /**
         * <p>
         * The information that DataSync Discovery collects about volumes in your on-premises storage system.
         * </p>
         * 
         * @param netAppONTAPVolumes
         *        The information that DataSync Discovery collects about volumes in your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPVolumes(Collection<NetAppONTAPVolume> netAppONTAPVolumes);

        /**
         * <p>
         * The information that DataSync Discovery collects about volumes in your on-premises storage system.
         * </p>
         * 
         * @param netAppONTAPVolumes
         *        The information that DataSync Discovery collects about volumes in your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPVolumes(NetAppONTAPVolume... netAppONTAPVolumes);

        /**
         * <p>
         * The information that DataSync Discovery collects about volumes in your on-premises storage system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume.Builder#build()} is called
         * immediately and its result is passed to {@link #netAppONTAPVolumes(List<NetAppONTAPVolume>)}.
         * 
         * @param netAppONTAPVolumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #netAppONTAPVolumes(java.util.Collection<NetAppONTAPVolume>)
         */
        Builder netAppONTAPVolumes(Consumer<NetAppONTAPVolume.Builder>... netAppONTAPVolumes);

        /**
         * <p>
         * The information that DataSync Discovery collects about the cluster in your on-premises storage system.
         * </p>
         * 
         * @param netAppONTAPClusters
         *        The information that DataSync Discovery collects about the cluster in your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPClusters(Collection<NetAppONTAPCluster> netAppONTAPClusters);

        /**
         * <p>
         * The information that DataSync Discovery collects about the cluster in your on-premises storage system.
         * </p>
         * 
         * @param netAppONTAPClusters
         *        The information that DataSync Discovery collects about the cluster in your on-premises storage system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netAppONTAPClusters(NetAppONTAPCluster... netAppONTAPClusters);

        /**
         * <p>
         * The information that DataSync Discovery collects about the cluster in your on-premises storage system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #netAppONTAPClusters(List<NetAppONTAPCluster>)}.
         * 
         * @param netAppONTAPClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #netAppONTAPClusters(java.util.Collection<NetAppONTAPCluster>)
         */
        Builder netAppONTAPClusters(Consumer<NetAppONTAPCluster.Builder>... netAppONTAPClusters);
    }

    static final class BuilderImpl implements Builder {
        private List<NetAppONTAPSVM> netAppONTAPSVMs = DefaultSdkAutoConstructList.getInstance();

        private List<NetAppONTAPVolume> netAppONTAPVolumes = DefaultSdkAutoConstructList.getInstance();

        private List<NetAppONTAPCluster> netAppONTAPClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            netAppONTAPSVMs(model.netAppONTAPSVMs);
            netAppONTAPVolumes(model.netAppONTAPVolumes);
            netAppONTAPClusters(model.netAppONTAPClusters);
        }

        public final List<NetAppONTAPSVM.Builder> getNetAppONTAPSVMs() {
            List<NetAppONTAPSVM.Builder> result = NetAppONTAPSVMsCopier.copyToBuilder(this.netAppONTAPSVMs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetAppONTAPSVMs(Collection<NetAppONTAPSVM.BuilderImpl> netAppONTAPSVMs) {
            this.netAppONTAPSVMs = NetAppONTAPSVMsCopier.copyFromBuilder(netAppONTAPSVMs);
        }

        @Override
        public final Builder netAppONTAPSVMs(Collection<NetAppONTAPSVM> netAppONTAPSVMs) {
            this.netAppONTAPSVMs = NetAppONTAPSVMsCopier.copy(netAppONTAPSVMs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPSVMs(NetAppONTAPSVM... netAppONTAPSVMs) {
            netAppONTAPSVMs(Arrays.asList(netAppONTAPSVMs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPSVMs(Consumer<NetAppONTAPSVM.Builder>... netAppONTAPSVMs) {
            netAppONTAPSVMs(Stream.of(netAppONTAPSVMs).map(c -> NetAppONTAPSVM.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<NetAppONTAPVolume.Builder> getNetAppONTAPVolumes() {
            List<NetAppONTAPVolume.Builder> result = NetAppONTAPVolumesCopier.copyToBuilder(this.netAppONTAPVolumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetAppONTAPVolumes(Collection<NetAppONTAPVolume.BuilderImpl> netAppONTAPVolumes) {
            this.netAppONTAPVolumes = NetAppONTAPVolumesCopier.copyFromBuilder(netAppONTAPVolumes);
        }

        @Override
        public final Builder netAppONTAPVolumes(Collection<NetAppONTAPVolume> netAppONTAPVolumes) {
            this.netAppONTAPVolumes = NetAppONTAPVolumesCopier.copy(netAppONTAPVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPVolumes(NetAppONTAPVolume... netAppONTAPVolumes) {
            netAppONTAPVolumes(Arrays.asList(netAppONTAPVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPVolumes(Consumer<NetAppONTAPVolume.Builder>... netAppONTAPVolumes) {
            netAppONTAPVolumes(Stream.of(netAppONTAPVolumes).map(c -> NetAppONTAPVolume.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<NetAppONTAPCluster.Builder> getNetAppONTAPClusters() {
            List<NetAppONTAPCluster.Builder> result = NetAppONTAPClustersCopier.copyToBuilder(this.netAppONTAPClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetAppONTAPClusters(Collection<NetAppONTAPCluster.BuilderImpl> netAppONTAPClusters) {
            this.netAppONTAPClusters = NetAppONTAPClustersCopier.copyFromBuilder(netAppONTAPClusters);
        }

        @Override
        public final Builder netAppONTAPClusters(Collection<NetAppONTAPCluster> netAppONTAPClusters) {
            this.netAppONTAPClusters = NetAppONTAPClustersCopier.copy(netAppONTAPClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPClusters(NetAppONTAPCluster... netAppONTAPClusters) {
            netAppONTAPClusters(Arrays.asList(netAppONTAPClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netAppONTAPClusters(Consumer<NetAppONTAPCluster.Builder>... netAppONTAPClusters) {
            netAppONTAPClusters(Stream.of(netAppONTAPClusters).map(c -> NetAppONTAPCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
