/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDiscoveryJobRequest extends DataSyncRequest implements
        ToCopyableBuilder<StartDiscoveryJobRequest.Builder, StartDiscoveryJobRequest> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageSystemArn").getter(getter(StartDiscoveryJobRequest::storageSystemArn))
            .setter(setter(Builder::storageSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()).build();

    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CollectionDurationMinutes")
            .getter(getter(StartDiscoveryJobRequest::collectionDurationMinutes))
            .setter(setter(Builder::collectionDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartDiscoveryJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartDiscoveryJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD,
            COLLECTION_DURATION_MINUTES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String storageSystemArn;

    private final Integer collectionDurationMinutes;

    private final String clientToken;

    private final List<TagListEntry> tags;

    private StartDiscoveryJobRequest(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the discovery job
     * on.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the
     *         discovery job on.
     */
    public final String storageSystemArn() {
        return storageSystemArn;
    }

    /**
     * <p>
     * Specifies in minutes how long you want the discovery job to run.
     * </p>
     * <note>
     * <p>
     * For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow time to
     * collect a sufficient number of data points and provide a realistic representation of storage performance and
     * utilization.
     * </p>
     * </note>
     * 
     * @return Specifies in minutes how long you want the discovery job to run.</p> <note>
     *         <p>
     *         For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow
     *         time to collect a sufficient number of data points and provide a realistic representation of storage
     *         performance and utilization.
     *         </p>
     */
    public final Integer collectionDurationMinutes() {
        return collectionDurationMinutes;
    }

    /**
     * <p>
     * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a
     * client token, DataSync generates one for you automatically.
     * </p>
     * 
     * @return Specifies a client token to make sure requests with this API operation are idempotent. If you don't
     *         specify a client token, DataSync generates one for you automatically.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDiscoveryJobRequest)) {
            return false;
        }
        StartDiscoveryJobRequest other = (StartDiscoveryJobRequest) obj;
        return Objects.equals(storageSystemArn(), other.storageSystemArn())
                && Objects.equals(collectionDurationMinutes(), other.collectionDurationMinutes())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDiscoveryJobRequest").add("StorageSystemArn", storageSystemArn())
                .add("CollectionDurationMinutes", collectionDurationMinutes()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageSystemArn":
            return Optional.ofNullable(clazz.cast(storageSystemArn()));
        case "CollectionDurationMinutes":
            return Optional.ofNullable(clazz.cast(collectionDurationMinutes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageSystemArn", STORAGE_SYSTEM_ARN_FIELD);
        map.put("CollectionDurationMinutes", COLLECTION_DURATION_MINUTES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDiscoveryJobRequest, T> g) {
        return obj -> g.apply((StartDiscoveryJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDiscoveryJobRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the discovery
         * job on.
         * </p>
         * 
         * @param storageSystemArn
         *        Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the
         *        discovery job on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSystemArn(String storageSystemArn);

        /**
         * <p>
         * Specifies in minutes how long you want the discovery job to run.
         * </p>
         * <note>
         * <p>
         * For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow time
         * to collect a sufficient number of data points and provide a realistic representation of storage performance
         * and utilization.
         * </p>
         * </note>
         * 
         * @param collectionDurationMinutes
         *        Specifies in minutes how long you want the discovery job to run.</p> <note>
         *        <p>
         *        For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow
         *        time to collect a sufficient number of data points and provide a realistic representation of storage
         *        performance and utilization.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionDurationMinutes(Integer collectionDurationMinutes);

        /**
         * <p>
         * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a
         * client token, DataSync generates one for you automatically.
         * </p>
         * 
         * @param clientToken
         *        Specifies a client token to make sure requests with this API operation are idempotent. If you don't
         *        specify a client token, DataSync generates one for you automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String storageSystemArn;

        private Integer collectionDurationMinutes;

        private String clientToken;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDiscoveryJobRequest model) {
            super(model);
            storageSystemArn(model.storageSystemArn);
            collectionDurationMinutes(model.collectionDurationMinutes);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getStorageSystemArn() {
            return storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDiscoveryJobRequest build() {
            return new StartDiscoveryJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
