/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that identifies an on-premises storage system that you're using with DataSync Discovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageSystemListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageSystemListEntry.Builder, StorageSystemListEntry> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageSystemArn").getter(getter(StorageSystemListEntry::storageSystemArn))
            .setter(setter(Builder::storageSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StorageSystemListEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageSystemArn;

    private final String name;

    private StorageSystemListEntry(BuilderImpl builder) {
        this.storageSystemArn = builder.storageSystemArn;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of an on-premises storage system that you added to DataSync Discovery.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of an on-premises storage system that you added to DataSync Discovery.
     */
    public final String storageSystemArn() {
        return storageSystemArn;
    }

    /**
     * <p>
     * The name of an on-premises storage system that you added to DataSync Discovery.
     * </p>
     * 
     * @return The name of an on-premises storage system that you added to DataSync Discovery.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageSystemListEntry)) {
            return false;
        }
        StorageSystemListEntry other = (StorageSystemListEntry) obj;
        return Objects.equals(storageSystemArn(), other.storageSystemArn()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageSystemListEntry").add("StorageSystemArn", storageSystemArn()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageSystemArn":
            return Optional.ofNullable(clazz.cast(storageSystemArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageSystemArn", STORAGE_SYSTEM_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageSystemListEntry, T> g) {
        return obj -> g.apply((StorageSystemListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageSystemListEntry> {
        /**
         * <p>
         * The Amazon Resource Names (ARN) of an on-premises storage system that you added to DataSync Discovery.
         * </p>
         * 
         * @param storageSystemArn
         *        The Amazon Resource Names (ARN) of an on-premises storage system that you added to DataSync Discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSystemArn(String storageSystemArn);

        /**
         * <p>
         * The name of an on-premises storage system that you added to DataSync Discovery.
         * </p>
         * 
         * @param name
         *        The name of an on-premises storage system that you added to DataSync Discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String storageSystemArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageSystemListEntry model) {
            storageSystemArn(model.storageSystemArn);
            name(model.name);
        }

        public final String getStorageSystemArn() {
            return storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public StorageSystemListEntry build() {
            return new StorageSystemListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
