/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of objects that DataSync fails to prepare, transfer, verify, and delete during your task execution.
 * </p>
 * <note>
 * <p>
 * Applies only to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Enhanced mode
 * tasks</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskExecutionFilesFailedDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskExecutionFilesFailedDetail.Builder, TaskExecutionFilesFailedDetail> {
    private static final SdkField<Long> PREPARE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Prepare")
            .getter(getter(TaskExecutionFilesFailedDetail::prepare)).setter(setter(Builder::prepare))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prepare").build()).build();

    private static final SdkField<Long> TRANSFER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Transfer")
            .getter(getter(TaskExecutionFilesFailedDetail::transfer)).setter(setter(Builder::transfer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transfer").build()).build();

    private static final SdkField<Long> VERIFY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Verify")
            .getter(getter(TaskExecutionFilesFailedDetail::verify)).setter(setter(Builder::verify))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verify").build()).build();

    private static final SdkField<Long> DELETE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Delete")
            .getter(getter(TaskExecutionFilesFailedDetail::delete)).setter(setter(Builder::delete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARE_FIELD, TRANSFER_FIELD,
            VERIFY_FIELD, DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long prepare;

    private final Long transfer;

    private final Long verify;

    private final Long delete;

    private TaskExecutionFilesFailedDetail(BuilderImpl builder) {
        this.prepare = builder.prepare;
        this.transfer = builder.transfer;
        this.verify = builder.verify;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The number of objects that DataSync fails to prepare during your task execution.
     * </p>
     * 
     * @return The number of objects that DataSync fails to prepare during your task execution.
     */
    public final Long prepare() {
        return prepare;
    }

    /**
     * <p>
     * The number of objects that DataSync fails to transfer during your task execution.
     * </p>
     * 
     * @return The number of objects that DataSync fails to transfer during your task execution.
     */
    public final Long transfer() {
        return transfer;
    }

    /**
     * <p>
     * The number of objects that DataSync fails to verify during your task execution.
     * </p>
     * 
     * @return The number of objects that DataSync fails to verify during your task execution.
     */
    public final Long verify() {
        return verify;
    }

    /**
     * <p>
     * The number of objects that DataSync fails to delete during your task execution.
     * </p>
     * 
     * @return The number of objects that DataSync fails to delete during your task execution.
     */
    public final Long delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prepare());
        hashCode = 31 * hashCode + Objects.hashCode(transfer());
        hashCode = 31 * hashCode + Objects.hashCode(verify());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionFilesFailedDetail)) {
            return false;
        }
        TaskExecutionFilesFailedDetail other = (TaskExecutionFilesFailedDetail) obj;
        return Objects.equals(prepare(), other.prepare()) && Objects.equals(transfer(), other.transfer())
                && Objects.equals(verify(), other.verify()) && Objects.equals(delete(), other.delete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskExecutionFilesFailedDetail").add("Prepare", prepare()).add("Transfer", transfer())
                .add("Verify", verify()).add("Delete", delete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prepare":
            return Optional.ofNullable(clazz.cast(prepare()));
        case "Transfer":
            return Optional.ofNullable(clazz.cast(transfer()));
        case "Verify":
            return Optional.ofNullable(clazz.cast(verify()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Prepare", PREPARE_FIELD);
        map.put("Transfer", TRANSFER_FIELD);
        map.put("Verify", VERIFY_FIELD);
        map.put("Delete", DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionFilesFailedDetail, T> g) {
        return obj -> g.apply((TaskExecutionFilesFailedDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskExecutionFilesFailedDetail> {
        /**
         * <p>
         * The number of objects that DataSync fails to prepare during your task execution.
         * </p>
         * 
         * @param prepare
         *        The number of objects that DataSync fails to prepare during your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prepare(Long prepare);

        /**
         * <p>
         * The number of objects that DataSync fails to transfer during your task execution.
         * </p>
         * 
         * @param transfer
         *        The number of objects that DataSync fails to transfer during your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transfer(Long transfer);

        /**
         * <p>
         * The number of objects that DataSync fails to verify during your task execution.
         * </p>
         * 
         * @param verify
         *        The number of objects that DataSync fails to verify during your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verify(Long verify);

        /**
         * <p>
         * The number of objects that DataSync fails to delete during your task execution.
         * </p>
         * 
         * @param delete
         *        The number of objects that DataSync fails to delete during your task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(Long delete);
    }

    static final class BuilderImpl implements Builder {
        private Long prepare;

        private Long transfer;

        private Long verify;

        private Long delete;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionFilesFailedDetail model) {
            prepare(model.prepare);
            transfer(model.transfer);
            verify(model.verify);
            delete(model.delete);
        }

        public final Long getPrepare() {
            return prepare;
        }

        public final void setPrepare(Long prepare) {
            this.prepare = prepare;
        }

        @Override
        public final Builder prepare(Long prepare) {
            this.prepare = prepare;
            return this;
        }

        public final Long getTransfer() {
            return transfer;
        }

        public final void setTransfer(Long transfer) {
            this.transfer = transfer;
        }

        @Override
        public final Builder transfer(Long transfer) {
            this.transfer = transfer;
            return this;
        }

        public final Long getVerify() {
            return verify;
        }

        public final void setVerify(Long verify) {
            this.verify = verify;
        }

        @Override
        public final Builder verify(Long verify) {
            this.verify = verify;
            return this;
        }

        public final Long getDelete() {
            return delete;
        }

        public final void setDelete(Long delete) {
            this.delete = delete;
        }

        @Override
        public final Builder delete(Long delete) {
            this.delete = delete;
            return this;
        }

        @Override
        public TaskExecutionFilesFailedDetail build() {
            return new TaskExecutionFilesFailedDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
