/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of objects that DataSync finds at your locations.
 * </p>
 * <note>
 * <p>
 * Applies only to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Enhanced mode
 * tasks</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskExecutionFilesListedDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskExecutionFilesListedDetail.Builder, TaskExecutionFilesListedDetail> {
    private static final SdkField<Long> AT_SOURCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("AtSource")
            .getter(getter(TaskExecutionFilesListedDetail::atSource)).setter(setter(Builder::atSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtSource").build()).build();

    private static final SdkField<Long> AT_DESTINATION_FOR_DELETE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AtDestinationForDelete").getter(getter(TaskExecutionFilesListedDetail::atDestinationForDelete))
            .setter(setter(Builder::atDestinationForDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtDestinationForDelete").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AT_SOURCE_FIELD,
            AT_DESTINATION_FOR_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long atSource;

    private final Long atDestinationForDelete;

    private TaskExecutionFilesListedDetail(BuilderImpl builder) {
        this.atSource = builder.atSource;
        this.atDestinationForDelete = builder.atDestinationForDelete;
    }

    /**
     * <p>
     * The number of objects that DataSync finds at your source location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With a <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">manifest</a>,
     * DataSync lists only what's in your manifest (and not everything at your source location).
     * </p>
     * </li>
     * <li>
     * <p>
     * With an include <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">filter</a>,
     * DataSync lists only what matches the filter at your source location.
     * </p>
     * </li>
     * <li>
     * <p>
     * With an exclude filter, DataSync lists everything at your source location before applying the filter.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of objects that DataSync finds at your source location.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With a <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">manifest
     *         </a>, DataSync lists only what's in your manifest (and not everything at your source location).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With an include <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">filter</a>, DataSync lists
     *         only what matches the filter at your source location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With an exclude filter, DataSync lists everything at your source location before applying the filter.
     *         </p>
     *         </li>
     */
    public final Long atSource() {
        return atSource;
    }

    /**
     * <p>
     * The number of objects that DataSync finds at your destination location. This counter is only applicable if you <a
     * href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling"
     * >configure your task</a> to delete data in the destination that isn't in the source.
     * </p>
     * 
     * @return The number of objects that DataSync finds at your destination location. This counter is only applicable
     *         if you <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling"
     *         >configure your task</a> to delete data in the destination that isn't in the source.
     */
    public final Long atDestinationForDelete() {
        return atDestinationForDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(atSource());
        hashCode = 31 * hashCode + Objects.hashCode(atDestinationForDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionFilesListedDetail)) {
            return false;
        }
        TaskExecutionFilesListedDetail other = (TaskExecutionFilesListedDetail) obj;
        return Objects.equals(atSource(), other.atSource())
                && Objects.equals(atDestinationForDelete(), other.atDestinationForDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskExecutionFilesListedDetail").add("AtSource", atSource())
                .add("AtDestinationForDelete", atDestinationForDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AtSource":
            return Optional.ofNullable(clazz.cast(atSource()));
        case "AtDestinationForDelete":
            return Optional.ofNullable(clazz.cast(atDestinationForDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AtSource", AT_SOURCE_FIELD);
        map.put("AtDestinationForDelete", AT_DESTINATION_FOR_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionFilesListedDetail, T> g) {
        return obj -> g.apply((TaskExecutionFilesListedDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskExecutionFilesListedDetail> {
        /**
         * <p>
         * The number of objects that DataSync finds at your source location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * With a <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">manifest</a>,
         * DataSync lists only what's in your manifest (and not everything at your source location).
         * </p>
         * </li>
         * <li>
         * <p>
         * With an include <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">filter</a>,
         * DataSync lists only what matches the filter at your source location.
         * </p>
         * </li>
         * <li>
         * <p>
         * With an exclude filter, DataSync lists everything at your source location before applying the filter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param atSource
         *        The number of objects that DataSync finds at your source location.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        With a <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">
         *        manifest</a>, DataSync lists only what's in your manifest (and not everything at your source
         *        location).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With an include <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">filter</a>, DataSync lists
         *        only what matches the filter at your source location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With an exclude filter, DataSync lists everything at your source location before applying the filter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atSource(Long atSource);

        /**
         * <p>
         * The number of objects that DataSync finds at your destination location. This counter is only applicable if
         * you <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling"
         * >configure your task</a> to delete data in the destination that isn't in the source.
         * </p>
         * 
         * @param atDestinationForDelete
         *        The number of objects that DataSync finds at your destination location. This counter is only
         *        applicable if you <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling"
         *        >configure your task</a> to delete data in the destination that isn't in the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atDestinationForDelete(Long atDestinationForDelete);
    }

    static final class BuilderImpl implements Builder {
        private Long atSource;

        private Long atDestinationForDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionFilesListedDetail model) {
            atSource(model.atSource);
            atDestinationForDelete(model.atDestinationForDelete);
        }

        public final Long getAtSource() {
            return atSource;
        }

        public final void setAtSource(Long atSource) {
            this.atSource = atSource;
        }

        @Override
        public final Builder atSource(Long atSource) {
            this.atSource = atSource;
            return this;
        }

        public final Long getAtDestinationForDelete() {
            return atDestinationForDelete;
        }

        public final void setAtDestinationForDelete(Long atDestinationForDelete) {
            this.atDestinationForDelete = atDestinationForDelete;
        }

        @Override
        public final Builder atDestinationForDelete(Long atDestinationForDelete) {
            this.atDestinationForDelete = atDestinationForDelete;
            return this;
        }

        @Override
        public TaskExecutionFilesListedDetail build() {
            return new TaskExecutionFilesListedDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
