/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDiscoveryJobRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateDiscoveryJobRequest.Builder, UpdateDiscoveryJobRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryJobArn").getter(getter(UpdateDiscoveryJobRequest::discoveryJobArn))
            .setter(setter(Builder::discoveryJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()).build();

    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("CollectionDurationMinutes")
            .getter(getter(UpdateDiscoveryJobRequest::collectionDurationMinutes))
            .setter(setter(Builder::collectionDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD,
            COLLECTION_DURATION_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discoveryJobArn;

    private final Integer collectionDurationMinutes;

    private UpdateDiscoveryJobRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the discovery job that you want to update.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the discovery job that you want to update.
     */
    public final String discoveryJobArn() {
        return discoveryJobArn;
    }

    /**
     * <p>
     * Specifies in minutes how long that you want the discovery job to run. (You can't set this parameter to less than
     * the number of minutes that the job has already run for.)
     * </p>
     * 
     * @return Specifies in minutes how long that you want the discovery job to run. (You can't set this parameter to
     *         less than the number of minutes that the job has already run for.)
     */
    public final Integer collectionDurationMinutes() {
        return collectionDurationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectionDurationMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDiscoveryJobRequest)) {
            return false;
        }
        UpdateDiscoveryJobRequest other = (UpdateDiscoveryJobRequest) obj;
        return Objects.equals(discoveryJobArn(), other.discoveryJobArn())
                && Objects.equals(collectionDurationMinutes(), other.collectionDurationMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDiscoveryJobRequest").add("DiscoveryJobArn", discoveryJobArn())
                .add("CollectionDurationMinutes", collectionDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryJobArn":
            return Optional.ofNullable(clazz.cast(discoveryJobArn()));
        case "CollectionDurationMinutes":
            return Optional.ofNullable(clazz.cast(collectionDurationMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
        map.put("CollectionDurationMinutes", COLLECTION_DURATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDiscoveryJobRequest, T> g) {
        return obj -> g.apply((UpdateDiscoveryJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDiscoveryJobRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the discovery job that you want to update.
         * </p>
         * 
         * @param discoveryJobArn
         *        Specifies the Amazon Resource Name (ARN) of the discovery job that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryJobArn(String discoveryJobArn);

        /**
         * <p>
         * Specifies in minutes how long that you want the discovery job to run. (You can't set this parameter to less
         * than the number of minutes that the job has already run for.)
         * </p>
         * 
         * @param collectionDurationMinutes
         *        Specifies in minutes how long that you want the discovery job to run. (You can't set this parameter to
         *        less than the number of minutes that the job has already run for.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionDurationMinutes(Integer collectionDurationMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String discoveryJobArn;

        private Integer collectionDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDiscoveryJobRequest model) {
            super(model);
            discoveryJobArn(model.discoveryJobArn);
            collectionDurationMinutes(model.collectionDurationMinutes);
        }

        public final String getDiscoveryJobArn() {
            return discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDiscoveryJobRequest build() {
            return new UpdateDiscoveryJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
