/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationEfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationEfsRequest.Builder, UpdateLocationEfsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationEfsRequest::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationEfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn").getter(getter(UpdateLocationEfsRequest::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAccessRoleArn").getter(getter(UpdateLocationEfsRequest::fileSystemAccessRoleArn))
            .setter(setter(Builder::fileSystemAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAccessRoleArn").build())
            .build();

    private static final SdkField<String> IN_TRANSIT_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InTransitEncryption").getter(getter(UpdateLocationEfsRequest::inTransitEncryptionAsString))
            .setter(setter(Builder::inTransitEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InTransitEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SUBDIRECTORY_FIELD, ACCESS_POINT_ARN_FIELD, FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD, IN_TRANSIT_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String subdirectory;

    private final String accessPointArn;

    private final String fileSystemAccessRoleArn;

    private final String inTransitEncryption;

    private UpdateLocationEfsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.accessPointArn = builder.accessPointArn;
        this.fileSystemAccessRoleArn = builder.fileSystemAccessRoleArn;
        this.inTransitEncryption = builder.inTransitEncryption;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the Amazon EFS transfer location that you're updating.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the Amazon EFS transfer location that you're updating.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on your file
     * system (depending on if this is a source or destination location).
     * </p>
     * <p>
     * By default, DataSync uses the root directory (or <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide one by
     * using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for example,
     * <code>/path/to/folder</code>).
     * </p>
     * 
     * @return Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on
     *         your file system (depending on if this is a source or destination location).</p>
     *         <p>
     *         By default, DataSync uses the root directory (or <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide
     *         one by using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for
     *         example, <code>/path/to/folder</code>).
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS file
     * system.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
     * >Accessing restricted Amazon EFS file systems</a>.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS
     *         file system.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
     *         >Accessing restricted Amazon EFS file systems</a>.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS file
     * system.
     * </p>
     * <p>
     * For information on creating this role, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
     * >Creating a DataSync IAM role for Amazon EFS file system access</a>.
     * </p>
     * 
     * @return Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS
     *         file system.</p>
     *         <p>
     *         For information on creating this role, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
     *         >Creating a DataSync IAM role for Amazon EFS file system access</a>.
     */
    public final String fileSystemAccessRoleArn() {
        return fileSystemAccessRoleArn;
    }

    /**
     * <p>
     * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers data
     * to or from your Amazon EFS file system.
     * </p>
     * <p>
     * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inTransitEncryption} will return {@link EfsInTransitEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inTransitEncryptionAsString}.
     * </p>
     * 
     * @return Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
     *         transfers data to or from your Amazon EFS file system.</p>
     *         <p>
     *         If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     *         <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * @see EfsInTransitEncryption
     */
    public final EfsInTransitEncryption inTransitEncryption() {
        return EfsInTransitEncryption.fromValue(inTransitEncryption);
    }

    /**
     * <p>
     * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers data
     * to or from your Amazon EFS file system.
     * </p>
     * <p>
     * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inTransitEncryption} will return {@link EfsInTransitEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inTransitEncryptionAsString}.
     * </p>
     * 
     * @return Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
     *         transfers data to or from your Amazon EFS file system.</p>
     *         <p>
     *         If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     *         <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * @see EfsInTransitEncryption
     */
    public final String inTransitEncryptionAsString() {
        return inTransitEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inTransitEncryptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationEfsRequest)) {
            return false;
        }
        UpdateLocationEfsRequest other = (UpdateLocationEfsRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(accessPointArn(), other.accessPointArn())
                && Objects.equals(fileSystemAccessRoleArn(), other.fileSystemAccessRoleArn())
                && Objects.equals(inTransitEncryptionAsString(), other.inTransitEncryptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationEfsRequest").add("LocationArn", locationArn()).add("Subdirectory", subdirectory())
                .add("AccessPointArn", accessPointArn()).add("FileSystemAccessRoleArn", fileSystemAccessRoleArn())
                .add("InTransitEncryption", inTransitEncryptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "FileSystemAccessRoleArn":
            return Optional.ofNullable(clazz.cast(fileSystemAccessRoleArn()));
        case "InTransitEncryption":
            return Optional.ofNullable(clazz.cast(inTransitEncryptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("FileSystemAccessRoleArn", FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD);
        map.put("InTransitEncryption", IN_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationEfsRequest, T> g) {
        return obj -> g.apply((UpdateLocationEfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationEfsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the Amazon EFS transfer location that you're updating.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the Amazon EFS transfer location that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on your
         * file system (depending on if this is a source or destination location).
         * </p>
         * <p>
         * By default, DataSync uses the root directory (or <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide one
         * by using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for
         * example, <code>/path/to/folder</code>).
         * </p>
         * 
         * @param subdirectory
         *        Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on
         *        your file system (depending on if this is a source or destination location).</p>
         *        <p>
         *        By default, DataSync uses the root directory (or <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you
         *        provide one by using <code>AccessPointArn</code>). You can also include subdirectories using forward
         *        slashes (for example, <code>/path/to/folder</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS file
         * system.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
         * >Accessing restricted Amazon EFS file systems</a>.
         * </p>
         * 
         * @param accessPointArn
         *        Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon
         *        EFS file system.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
         *        >Accessing restricted Amazon EFS file systems</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS file
         * system.
         * </p>
         * <p>
         * For information on creating this role, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
         * >Creating a DataSync IAM role for Amazon EFS file system access</a>.
         * </p>
         * 
         * @param fileSystemAccessRoleArn
         *        Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS
         *        file system.</p>
         *        <p>
         *        For information on creating this role, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
         *        >Creating a DataSync IAM role for Amazon EFS file system access</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn);

        /**
         * <p>
         * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers
         * data to or from your Amazon EFS file system.
         * </p>
         * <p>
         * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * </p>
         * 
         * @param inTransitEncryption
         *        Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
         *        transfers data to or from your Amazon EFS file system.</p>
         *        <p>
         *        If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         *        <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * @see EfsInTransitEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EfsInTransitEncryption
         */
        Builder inTransitEncryption(String inTransitEncryption);

        /**
         * <p>
         * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers
         * data to or from your Amazon EFS file system.
         * </p>
         * <p>
         * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * </p>
         * 
         * @param inTransitEncryption
         *        Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
         *        transfers data to or from your Amazon EFS file system.</p>
         *        <p>
         *        If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         *        <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * @see EfsInTransitEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EfsInTransitEncryption
         */
        Builder inTransitEncryption(EfsInTransitEncryption inTransitEncryption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private String subdirectory;

        private String accessPointArn;

        private String fileSystemAccessRoleArn;

        private String inTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationEfsRequest model) {
            super(model);
            locationArn(model.locationArn);
            subdirectory(model.subdirectory);
            accessPointArn(model.accessPointArn);
            fileSystemAccessRoleArn(model.fileSystemAccessRoleArn);
            inTransitEncryption(model.inTransitEncryption);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getFileSystemAccessRoleArn() {
            return fileSystemAccessRoleArn;
        }

        public final void setFileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
        }

        @Override
        public final Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        public final String getInTransitEncryption() {
            return inTransitEncryption;
        }

        public final void setInTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
        }

        @Override
        public final Builder inTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
            return this;
        }

        @Override
        public final Builder inTransitEncryption(EfsInTransitEncryption inTransitEncryption) {
            this.inTransitEncryption(inTransitEncryption == null ? null : inTransitEncryption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationEfsRequest build() {
            return new UpdateLocationEfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
