/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationFsxOntapRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationFsxOntapRequest.Builder, UpdateLocationFsxOntapRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationFsxOntapRequest::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<FsxUpdateProtocol> PROTOCOL_FIELD = SdkField
            .<FsxUpdateProtocol> builder(MarshallingType.SDK_POJO).memberName("Protocol")
            .getter(getter(UpdateLocationFsxOntapRequest::protocol)).setter(setter(Builder::protocol))
            .constructor(FsxUpdateProtocol::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationFsxOntapRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            PROTOCOL_FIELD, SUBDIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final FsxUpdateProtocol protocol;

    private final String subdirectory;

    private UpdateLocationFsxOntapRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.protocol = builder.protocol;
        this.subdirectory = builder.subdirectory;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP transfer location that you're updating.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP transfer location that you're updating.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
     * </p>
     * 
     * @return Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
     */
    public final FsxUpdateProtocol protocol() {
        return protocol;
    }

    /**
     * <p>
     * Specifies a path to the file share in the storage virtual machine (SVM) where you want to transfer data to or
     * from.
     * </p>
     * <p>
     * You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name
     * (for SMB file shares). For example, your mount path might be <code>/vol1</code>, <code>/vol1/tree1</code>, or
     * <code>/share1</code>.
     * </p>
     * <note>
     * <p>
     * Don't specify a junction path in the SVM's root volume. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage
     * virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Specifies a path to the file share in the storage virtual machine (SVM) where you want to transfer data
     *         to or from.</p>
     *         <p>
     *         You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share
     *         name (for SMB file shares). For example, your mount path might be <code>/vol1</code>,
     *         <code>/vol1/tree1</code>, or <code>/share1</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Don't specify a junction path in the SVM's root volume. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP
     *         storage virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
     *         </p>
     */
    public final String subdirectory() {
        return subdirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationFsxOntapRequest)) {
            return false;
        }
        UpdateLocationFsxOntapRequest other = (UpdateLocationFsxOntapRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(subdirectory(), other.subdirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationFsxOntapRequest").add("LocationArn", locationArn()).add("Protocol", protocol())
                .add("Subdirectory", subdirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationFsxOntapRequest, T> g) {
        return obj -> g.apply((UpdateLocationFsxOntapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationFsxOntapRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP transfer location that you're updating.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP transfer location that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
         * </p>
         * 
         * @param protocol
         *        Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(FsxUpdateProtocol protocol);

        /**
         * <p>
         * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link FsxUpdateProtocol.Builder} avoiding the
         * need to create one manually via {@link FsxUpdateProtocol#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxUpdateProtocol.Builder#build()} is called immediately and its
         * result is passed to {@link #protocol(FsxUpdateProtocol)}.
         * 
         * @param protocol
         *        a consumer that will call methods on {@link FsxUpdateProtocol.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocol(FsxUpdateProtocol)
         */
        default Builder protocol(Consumer<FsxUpdateProtocol.Builder> protocol) {
            return protocol(FsxUpdateProtocol.builder().applyMutation(protocol).build());
        }

        /**
         * <p>
         * Specifies a path to the file share in the storage virtual machine (SVM) where you want to transfer data to or
         * from.
         * </p>
         * <p>
         * You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share
         * name (for SMB file shares). For example, your mount path might be <code>/vol1</code>,
         * <code>/vol1/tree1</code>, or <code>/share1</code>.
         * </p>
         * <note>
         * <p>
         * Don't specify a junction path in the SVM's root volume. For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage
         * virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         * </p>
         * </note>
         * 
         * @param subdirectory
         *        Specifies a path to the file share in the storage virtual machine (SVM) where you want to transfer
         *        data to or from.</p>
         *        <p>
         *        You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or
         *        share name (for SMB file shares). For example, your mount path might be <code>/vol1</code>,
         *        <code>/vol1/tree1</code>, or <code>/share1</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Don't specify a junction path in the SVM's root volume. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP
         *        storage virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private FsxUpdateProtocol protocol;

        private String subdirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationFsxOntapRequest model) {
            super(model);
            locationArn(model.locationArn);
            protocol(model.protocol);
            subdirectory(model.subdirectory);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final FsxUpdateProtocol.Builder getProtocol() {
            return protocol != null ? protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxUpdateProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxUpdateProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationFsxOntapRequest build() {
            return new UpdateLocationFsxOntapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
