/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationFsxOpenZfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationFsxOpenZfsRequest.Builder, UpdateLocationFsxOpenZfsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationFsxOpenZfsRequest::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<FsxProtocol> PROTOCOL_FIELD = SdkField.<FsxProtocol> builder(MarshallingType.SDK_POJO)
            .memberName("Protocol").getter(getter(UpdateLocationFsxOpenZfsRequest::protocol)).setter(setter(Builder::protocol))
            .constructor(FsxProtocol::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationFsxOpenZfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            PROTOCOL_FIELD, SUBDIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final FsxProtocol protocol;

    private final String subdirectory;

    private UpdateLocationFsxOpenZfsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.protocol = builder.protocol;
        this.subdirectory = builder.subdirectory;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the FSx for OpenZFS transfer location that you're updating.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the FSx for OpenZFS transfer location that you're updating.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * Returns the value of the Protocol property for this object.
     * 
     * @return The value of the Protocol property for this object.
     */
    public final FsxProtocol protocol() {
        return protocol;
    }

    /**
     * <p>
     * Specifies a subdirectory in the location's path that must begin with <code>/fsx</code>. DataSync uses this
     * subdirectory to read or write data (depending on whether the file system is a source or destination location).
     * </p>
     * 
     * @return Specifies a subdirectory in the location's path that must begin with <code>/fsx</code>. DataSync uses
     *         this subdirectory to read or write data (depending on whether the file system is a source or destination
     *         location).
     */
    public final String subdirectory() {
        return subdirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationFsxOpenZfsRequest)) {
            return false;
        }
        UpdateLocationFsxOpenZfsRequest other = (UpdateLocationFsxOpenZfsRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(subdirectory(), other.subdirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationFsxOpenZfsRequest").add("LocationArn", locationArn()).add("Protocol", protocol())
                .add("Subdirectory", subdirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationFsxOpenZfsRequest, T> g) {
        return obj -> g.apply((UpdateLocationFsxOpenZfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationFsxOpenZfsRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the FSx for OpenZFS transfer location that you're updating.
         * </p>
         * 
         * @param locationArn
         *        Specifies the Amazon Resource Name (ARN) of the FSx for OpenZFS transfer location that you're
         *        updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * Sets the value of the Protocol property for this object.
         *
         * @param protocol
         *        The new value for the Protocol property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(FsxProtocol protocol);

        /**
         * Sets the value of the Protocol property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FsxProtocol.Builder} avoiding the need to
         * create one manually via {@link FsxProtocol#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxProtocol.Builder#build()} is called immediately and its result
         * is passed to {@link #protocol(FsxProtocol)}.
         * 
         * @param protocol
         *        a consumer that will call methods on {@link FsxProtocol.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocol(FsxProtocol)
         */
        default Builder protocol(Consumer<FsxProtocol.Builder> protocol) {
            return protocol(FsxProtocol.builder().applyMutation(protocol).build());
        }

        /**
         * <p>
         * Specifies a subdirectory in the location's path that must begin with <code>/fsx</code>. DataSync uses this
         * subdirectory to read or write data (depending on whether the file system is a source or destination
         * location).
         * </p>
         * 
         * @param subdirectory
         *        Specifies a subdirectory in the location's path that must begin with <code>/fsx</code>. DataSync uses
         *        this subdirectory to read or write data (depending on whether the file system is a source or
         *        destination location).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private FsxProtocol protocol;

        private String subdirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationFsxOpenZfsRequest model) {
            super(model);
            locationArn(model.locationArn);
            protocol(model.protocol);
            subdirectory(model.subdirectory);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final FsxProtocol.Builder getProtocol() {
            return protocol != null ? protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationFsxOpenZfsRequest build() {
            return new UpdateLocationFsxOpenZfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
