/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capacity> {
    private static final SdkField<Long> USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Used").getter(Capacity.getter(Capacity::used)).setter(Capacity.setter(Builder::used)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()}).build();
    private static final SdkField<Long> PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Provisioned").getter(Capacity.getter(Capacity::provisioned)).setter(Capacity.setter(Builder::provisioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provisioned").build()}).build();
    private static final SdkField<Long> LOGICAL_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LogicalUsed").getter(Capacity.getter(Capacity::logicalUsed)).setter(Capacity.setter(Builder::logicalUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalUsed").build()}).build();
    private static final SdkField<Long> CLUSTER_CLOUD_STORAGE_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ClusterCloudStorageUsed").getter(Capacity.getter(Capacity::clusterCloudStorageUsed)).setter(Capacity.setter(Builder::clusterCloudStorageUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCloudStorageUsed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USED_FIELD, PROVISIONED_FIELD, LOGICAL_USED_FIELD, CLUSTER_CLOUD_STORAGE_USED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Capacity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long used;
    private final Long provisioned;
    private final Long logicalUsed;
    private final Long clusterCloudStorageUsed;

    private Capacity(BuilderImpl builder) {
        this.used = builder.used;
        this.provisioned = builder.provisioned;
        this.logicalUsed = builder.logicalUsed;
        this.clusterCloudStorageUsed = builder.clusterCloudStorageUsed;
    }

    public final Long used() {
        return this.used;
    }

    public final Long provisioned() {
        return this.provisioned;
    }

    public final Long logicalUsed() {
        return this.logicalUsed;
    }

    public final Long clusterCloudStorageUsed() {
        return this.clusterCloudStorageUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.used());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCloudStorageUsed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity)obj;
        return Objects.equals(this.used(), other.used()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.logicalUsed(), other.logicalUsed()) && Objects.equals(this.clusterCloudStorageUsed(), other.clusterCloudStorageUsed());
    }

    public final String toString() {
        return ToString.builder((String)"Capacity").add("Used", (Object)this.used()).add("Provisioned", (Object)this.provisioned()).add("LogicalUsed", (Object)this.logicalUsed()).add("ClusterCloudStorageUsed", (Object)this.clusterCloudStorageUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Used": {
                return Optional.ofNullable(clazz.cast(this.used()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "LogicalUsed": {
                return Optional.ofNullable(clazz.cast(this.logicalUsed()));
            }
            case "ClusterCloudStorageUsed": {
                return Optional.ofNullable(clazz.cast(this.clusterCloudStorageUsed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("Used", USED_FIELD);
        map.put("Provisioned", PROVISIONED_FIELD);
        map.put("LogicalUsed", LOGICAL_USED_FIELD);
        map.put("ClusterCloudStorageUsed", CLUSTER_CLOUD_STORAGE_USED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long used;
        private Long provisioned;
        private Long logicalUsed;
        private Long clusterCloudStorageUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            this.used(model.used);
            this.provisioned(model.provisioned);
            this.logicalUsed(model.logicalUsed);
            this.clusterCloudStorageUsed(model.clusterCloudStorageUsed);
        }

        public final Long getUsed() {
            return this.used;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        @Override
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        public final Long getProvisioned() {
            return this.provisioned;
        }

        public final void setProvisioned(Long provisioned) {
            this.provisioned = provisioned;
        }

        @Override
        public final Builder provisioned(Long provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final Long getLogicalUsed() {
            return this.logicalUsed;
        }

        public final void setLogicalUsed(Long logicalUsed) {
            this.logicalUsed = logicalUsed;
        }

        @Override
        public final Builder logicalUsed(Long logicalUsed) {
            this.logicalUsed = logicalUsed;
            return this;
        }

        public final Long getClusterCloudStorageUsed() {
            return this.clusterCloudStorageUsed;
        }

        public final void setClusterCloudStorageUsed(Long clusterCloudStorageUsed) {
            this.clusterCloudStorageUsed = clusterCloudStorageUsed;
        }

        @Override
        public final Builder clusterCloudStorageUsed(Long clusterCloudStorageUsed) {
            this.clusterCloudStorageUsed = clusterCloudStorageUsed;
            return this;
        }

        public Capacity build() {
            return new Capacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capacity> {
        public Builder used(Long var1);

        public Builder provisioned(Long var1);

        public Builder logicalUsed(Long var1);

        public Builder clusterCloudStorageUsed(Long var1);
    }
}

