/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationNfsRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationNfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationNfsRequest.Builder, CreateLocationNfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(CreateLocationNfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerHostname").getter(getter(CreateLocationNfsRequest::serverHostname))
            .setter(setter(Builder::serverHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()).build();

    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.<OnPremConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OnPremConfig").getter(getter(CreateLocationNfsRequest::onPremConfig))
            .setter(setter(Builder::onPremConfig)).constructor(OnPremConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()).build();

    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(CreateLocationNfsRequest::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLocationNfsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD,
            SERVER_HOSTNAME_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subdirectory;

    private final String serverHostname;

    private final OnPremConfig onPremConfig;

    private final NfsMountOptions mountOptions;

    private final List<TagListEntry> tags;

    private CreateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.serverHostname = builder.serverHostname;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the export path in your NFS file server that you want DataSync to mount.
     * </p>
     * <p>
     * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
     * configuring an export for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing NFS
     * file servers</a>.
     * </p>
     * 
     * @return Specifies the export path in your NFS file server that you want DataSync to mount.</p>
     *         <p>
     *         This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
     *         configuring an export for DataSync, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs"
     *         >Accessing NFS file servers</a>.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent connects to.
     * </p>
     * 
     * @return Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent
     *         connects to.
     */
    public final String serverHostname() {
        return serverHostname;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect to your NFS file server.
     * </p>
     * <p>
     * You can specify more than one agent. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents">Using
     * multiple DataSync agents</a>.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect to your NFS file
     *         server.</p>
     *         <p>
     *         You can specify more than one agent. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents"
     *         >Using multiple DataSync agents</a>.
     */
    public final OnPremConfig onPremConfig() {
        return onPremConfig;
    }

    /**
     * <p>
     * Specifies the options that DataSync can use to mount your NFS file server.
     * </p>
     * 
     * @return Specifies the options that DataSync can use to mount your NFS file server.
     */
    public final NfsMountOptions mountOptions() {
        return mountOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     * recommend creating at least a name tag for your location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     *         recommend creating at least a name tag for your location.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationNfsRequest)) {
            return false;
        }
        CreateLocationNfsRequest other = (CreateLocationNfsRequest) obj;
        return Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(serverHostname(), other.serverHostname())
                && Objects.equals(onPremConfig(), other.onPremConfig()) && Objects.equals(mountOptions(), other.mountOptions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocationNfsRequest").add("Subdirectory", subdirectory())
                .add("ServerHostname", serverHostname()).add("OnPremConfig", onPremConfig()).add("MountOptions", mountOptions())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "ServerHostname":
            return Optional.ofNullable(clazz.cast(serverHostname()));
        case "OnPremConfig":
            return Optional.ofNullable(clazz.cast(onPremConfig()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("ServerHostname", SERVER_HOSTNAME_FIELD);
        map.put("OnPremConfig", ON_PREM_CONFIG_FIELD);
        map.put("MountOptions", MOUNT_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationNfsRequest, T> g) {
        return obj -> g.apply((CreateLocationNfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationNfsRequest> {
        /**
         * <p>
         * Specifies the export path in your NFS file server that you want DataSync to mount.
         * </p>
         * <p>
         * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on
         * configuring an export for DataSync, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing
         * NFS file servers</a>.
         * </p>
         * 
         * @param subdirectory
         *        Specifies the export path in your NFS file server that you want DataSync to mount.</p>
         *        <p>
         *        This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information
         *        on configuring an export for DataSync, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs"
         *        >Accessing NFS file servers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent connects
         * to.
         * </p>
         * 
         * @param serverHostname
         *        Specifies the DNS name or IP address (IPv4 or IPv6) of the NFS file server that your DataSync agent
         *        connects to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverHostname(String serverHostname);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect to your NFS file server.
         * </p>
         * <p>
         * You can specify more than one agent. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents"
         * >Using multiple DataSync agents</a>.
         * </p>
         * 
         * @param onPremConfig
         *        Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect to your NFS file
         *        server.</p>
         *        <p>
         *        You can specify more than one agent. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents"
         *        >Using multiple DataSync agents</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremConfig(OnPremConfig onPremConfig);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect to your NFS file server.
         * </p>
         * <p>
         * You can specify more than one agent. For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents"
         * >Using multiple DataSync agents</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnPremConfig.Builder} avoiding the need
         * to create one manually via {@link OnPremConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremConfig(OnPremConfig)}.
         * 
         * @param onPremConfig
         *        a consumer that will call methods on {@link OnPremConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremConfig(OnPremConfig)
         */
        default Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return onPremConfig(OnPremConfig.builder().applyMutation(onPremConfig).build());
        }

        /**
         * <p>
         * Specifies the options that DataSync can use to mount your NFS file server.
         * </p>
         * 
         * @param mountOptions
         *        Specifies the options that DataSync can use to mount your NFS file server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * <p>
         * Specifies the options that DataSync can use to mount your NFS file server.
         * </p>
         * This is a convenience method that creates an instance of the {@link NfsMountOptions.Builder} avoiding the
         * need to create one manually via {@link NfsMountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least a name tag for your location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String subdirectory;

        private String serverHostname;

        private OnPremConfig onPremConfig;

        private NfsMountOptions mountOptions;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationNfsRequest model) {
            super(model);
            subdirectory(model.subdirectory);
            serverHostname(model.serverHostname);
            onPremConfig(model.onPremConfig);
            mountOptions(model.mountOptions);
            tags(model.tags);
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getServerHostname() {
            return serverHostname;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return onPremConfig != null ? onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationNfsRequest build() {
            return new CreateLocationNfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
