/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationAzureBlobResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationAzureBlobResponse.Builder, DescribeLocationAzureBlobResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationAzureBlobResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationAzureBlobResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(DescribeLocationAzureBlobResponse::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> BLOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlobType").getter(getter(DescribeLocationAzureBlobResponse::blobTypeAsString))
            .setter(setter(Builder::blobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlobType").build()).build();

    private static final SdkField<String> ACCESS_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessTier").getter(getter(DescribeLocationAzureBlobResponse::accessTierAsString))
            .setter(setter(Builder::accessTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTier").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(DescribeLocationAzureBlobResponse::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationAzureBlobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<ManagedSecretConfig> MANAGED_SECRET_CONFIG_FIELD = SdkField
            .<ManagedSecretConfig> builder(MarshallingType.SDK_POJO).memberName("ManagedSecretConfig")
            .getter(getter(DescribeLocationAzureBlobResponse::managedSecretConfig)).setter(setter(Builder::managedSecretConfig))
            .constructor(ManagedSecretConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedSecretConfig").build())
            .build();

    private static final SdkField<CmkSecretConfig> CMK_SECRET_CONFIG_FIELD = SdkField
            .<CmkSecretConfig> builder(MarshallingType.SDK_POJO).memberName("CmkSecretConfig")
            .getter(getter(DescribeLocationAzureBlobResponse::cmkSecretConfig)).setter(setter(Builder::cmkSecretConfig))
            .constructor(CmkSecretConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkSecretConfig").build()).build();

    private static final SdkField<CustomSecretConfig> CUSTOM_SECRET_CONFIG_FIELD = SdkField
            .<CustomSecretConfig> builder(MarshallingType.SDK_POJO).memberName("CustomSecretConfig")
            .getter(getter(DescribeLocationAzureBlobResponse::customSecretConfig)).setter(setter(Builder::customSecretConfig))
            .constructor(CustomSecretConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecretConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, AUTHENTICATION_TYPE_FIELD, BLOB_TYPE_FIELD, ACCESS_TIER_FIELD, AGENT_ARNS_FIELD,
            CREATION_TIME_FIELD, MANAGED_SECRET_CONFIG_FIELD, CMK_SECRET_CONFIG_FIELD, CUSTOM_SECRET_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String locationUri;

    private final String authenticationType;

    private final String blobType;

    private final String accessTier;

    private final List<String> agentArns;

    private final Instant creationTime;

    private final ManagedSecretConfig managedSecretConfig;

    private final CmkSecretConfig cmkSecretConfig;

    private final CustomSecretConfig customSecretConfig;

    private DescribeLocationAzureBlobResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.authenticationType = builder.authenticationType;
        this.blobType = builder.blobType;
        this.accessTier = builder.accessTier;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
        this.managedSecretConfig = builder.managedSecretConfig;
        this.cmkSecretConfig = builder.cmkSecretConfig;
        this.customSecretConfig = builder.customSecretConfig;
    }

    /**
     * <p>
     * The ARN of your Azure Blob Storage transfer location.
     * </p>
     * 
     * @return The ARN of your Azure Blob Storage transfer location.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the Azure Blob Storage container involved in your transfer.
     * </p>
     * 
     * @return The URL of the Azure Blob Storage container involved in your transfer.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using
     * a shared access signature (SAS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AzureBlobAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob
     *         storage using a shared access signature (SAS).
     * @see AzureBlobAuthenticationType
     */
    public final AzureBlobAuthenticationType authenticationType() {
        return AzureBlobAuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using
     * a shared access signature (SAS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AzureBlobAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob
     *         storage using a shared access signature (SAS).
     * @see AzureBlobAuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
     * Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on
     * blob types, see the <a href=
     * "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
     * >Azure Blob Storage documentation</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blobType} will
     * return {@link AzureBlobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #blobTypeAsString}.
     * </p>
     * 
     * @return The type of blob that you want your objects or files to be when transferring them into Azure Blob
     *         Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more
     *         information on blob types, see the <a href=
     *         "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
     *         >Azure Blob Storage documentation</a>.
     * @see AzureBlobType
     */
    public final AzureBlobType blobType() {
        return AzureBlobType.fromValue(blobType);
    }

    /**
     * <p>
     * The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
     * Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on
     * blob types, see the <a href=
     * "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
     * >Azure Blob Storage documentation</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blobType} will
     * return {@link AzureBlobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #blobTypeAsString}.
     * </p>
     * 
     * @return The type of blob that you want your objects or files to be when transferring them into Azure Blob
     *         Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more
     *         information on blob types, see the <a href=
     *         "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
     *         >Azure Blob Storage documentation</a>.
     * @see AzureBlobType
     */
    public final String blobTypeAsString() {
        return blobType;
    }

    /**
     * <p>
     * The access tier that you want your objects or files transferred into. This only applies when using the location
     * as a transfer destination. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >Access tiers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessTier} will
     * return {@link AzureAccessTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTierAsString}.
     * </p>
     * 
     * @return The access tier that you want your objects or files transferred into. This only applies when using the
     *         location as a transfer destination. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     *         >Access tiers</a>.
     * @see AzureAccessTier
     */
    public final AzureAccessTier accessTier() {
        return AzureAccessTier.fromValue(accessTier);
    }

    /**
     * <p>
     * The access tier that you want your objects or files transferred into. This only applies when using the location
     * as a transfer destination. For more information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     * >Access tiers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessTier} will
     * return {@link AzureAccessTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTierAsString}.
     * </p>
     * 
     * @return The access tier that you want your objects or files transferred into. This only applies when using the
     *         location as a transfer destination. For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
     *         >Access tiers</a>.
     * @see AzureAccessTier
     */
    public final String accessTierAsString() {
        return accessTier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * The time that your Azure Blob Storage transfer location was created.
     * </p>
     * 
     * @return The time that your Azure Blob Storage transfer location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Describes configuration information for a DataSync-managed secret, such as an authentication token that DataSync
     * uses to access a specific storage location. DataSync uses the default Amazon Web Services-managed KMS key to
     * encrypt this secret in Secrets Manager.
     * </p>
     * 
     * @return Describes configuration information for a DataSync-managed secret, such as an authentication token that
     *         DataSync uses to access a specific storage location. DataSync uses the default Amazon Web
     *         Services-managed KMS key to encrypt this secret in Secrets Manager.
     */
    public final ManagedSecretConfig managedSecretConfig() {
        return managedSecretConfig;
    }

    /**
     * <p>
     * Describes configuration information for a DataSync-managed secret, such as an authentication token that DataSync
     * uses to access a specific storage location, with a customer-managed KMS key.
     * </p>
     * 
     * @return Describes configuration information for a DataSync-managed secret, such as an authentication token that
     *         DataSync uses to access a specific storage location, with a customer-managed KMS key.
     */
    public final CmkSecretConfig cmkSecretConfig() {
        return cmkSecretConfig;
    }

    /**
     * <p>
     * Describes configuration information for a customer-managed secret, such as an authentication token that DataSync
     * uses to access a specific storage location, with a customer-managed KMS key.
     * </p>
     * 
     * @return Describes configuration information for a customer-managed secret, such as an authentication token that
     *         DataSync uses to access a specific storage location, with a customer-managed KMS key.
     */
    public final CustomSecretConfig customSecretConfig() {
        return customSecretConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(managedSecretConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cmkSecretConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customSecretConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationAzureBlobResponse)) {
            return false;
        }
        DescribeLocationAzureBlobResponse other = (DescribeLocationAzureBlobResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(blobTypeAsString(), other.blobTypeAsString())
                && Objects.equals(accessTierAsString(), other.accessTierAsString()) && hasAgentArns() == other.hasAgentArns()
                && Objects.equals(agentArns(), other.agentArns()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(managedSecretConfig(), other.managedSecretConfig())
                && Objects.equals(cmkSecretConfig(), other.cmkSecretConfig())
                && Objects.equals(customSecretConfig(), other.customSecretConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationAzureBlobResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("AuthenticationType", authenticationTypeAsString())
                .add("BlobType", blobTypeAsString()).add("AccessTier", accessTierAsString())
                .add("AgentArns", hasAgentArns() ? agentArns() : null).add("CreationTime", creationTime())
                .add("ManagedSecretConfig", managedSecretConfig()).add("CmkSecretConfig", cmkSecretConfig())
                .add("CustomSecretConfig", customSecretConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "BlobType":
            return Optional.ofNullable(clazz.cast(blobTypeAsString()));
        case "AccessTier":
            return Optional.ofNullable(clazz.cast(accessTierAsString()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ManagedSecretConfig":
            return Optional.ofNullable(clazz.cast(managedSecretConfig()));
        case "CmkSecretConfig":
            return Optional.ofNullable(clazz.cast(cmkSecretConfig()));
        case "CustomSecretConfig":
            return Optional.ofNullable(clazz.cast(customSecretConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("BlobType", BLOB_TYPE_FIELD);
        map.put("AccessTier", ACCESS_TIER_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ManagedSecretConfig", MANAGED_SECRET_CONFIG_FIELD);
        map.put("CmkSecretConfig", CMK_SECRET_CONFIG_FIELD);
        map.put("CustomSecretConfig", CUSTOM_SECRET_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationAzureBlobResponse, T> g) {
        return obj -> g.apply((DescribeLocationAzureBlobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocationAzureBlobResponse> {
        /**
         * <p>
         * The ARN of your Azure Blob Storage transfer location.
         * </p>
         * 
         * @param locationArn
         *        The ARN of your Azure Blob Storage transfer location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the Azure Blob Storage container involved in your transfer.
         * </p>
         * 
         * @param locationUri
         *        The URL of the Azure Blob Storage container involved in your transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage
         * using a shared access signature (SAS).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob
         *        storage using a shared access signature (SAS).
         * @see AzureBlobAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureBlobAuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage
         * using a shared access signature (SAS).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob
         *        storage using a shared access signature (SAS).
         * @see AzureBlobAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureBlobAuthenticationType
         */
        Builder authenticationType(AzureBlobAuthenticationType authenticationType);

        /**
         * <p>
         * The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
         * Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on
         * blob types, see the <a href=
         * "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
         * >Azure Blob Storage documentation</a>.
         * </p>
         * 
         * @param blobType
         *        The type of blob that you want your objects or files to be when transferring them into Azure Blob
         *        Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For
         *        more information on blob types, see the <a href=
         *        "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
         *        >Azure Blob Storage documentation</a>.
         * @see AzureBlobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureBlobType
         */
        Builder blobType(String blobType);

        /**
         * <p>
         * The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
         * Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on
         * blob types, see the <a href=
         * "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
         * >Azure Blob Storage documentation</a>.
         * </p>
         * 
         * @param blobType
         *        The type of blob that you want your objects or files to be when transferring them into Azure Blob
         *        Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For
         *        more information on blob types, see the <a href=
         *        "https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs"
         *        >Azure Blob Storage documentation</a>.
         * @see AzureBlobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureBlobType
         */
        Builder blobType(AzureBlobType blobType);

        /**
         * <p>
         * The access tier that you want your objects or files transferred into. This only applies when using the
         * location as a transfer destination. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
         * >Access tiers</a>.
         * </p>
         * 
         * @param accessTier
         *        The access tier that you want your objects or files transferred into. This only applies when using the
         *        location as a transfer destination. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
         *        >Access tiers</a>.
         * @see AzureAccessTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureAccessTier
         */
        Builder accessTier(String accessTier);

        /**
         * <p>
         * The access tier that you want your objects or files transferred into. This only applies when using the
         * location as a transfer destination. For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
         * >Access tiers</a>.
         * </p>
         * 
         * @param accessTier
         *        The access tier that you want your objects or files transferred into. This only applies when using the
         *        location as a transfer destination. For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers"
         *        >Access tiers</a>.
         * @see AzureAccessTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AzureAccessTier
         */
        Builder accessTier(AzureAccessTier accessTier);

        /**
         * <p>
         * The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The time that your Azure Blob Storage transfer location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that your Azure Blob Storage transfer location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Describes configuration information for a DataSync-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location. DataSync uses the default Amazon Web Services-managed
         * KMS key to encrypt this secret in Secrets Manager.
         * </p>
         * 
         * @param managedSecretConfig
         *        Describes configuration information for a DataSync-managed secret, such as an authentication token
         *        that DataSync uses to access a specific storage location. DataSync uses the default Amazon Web
         *        Services-managed KMS key to encrypt this secret in Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedSecretConfig(ManagedSecretConfig managedSecretConfig);

        /**
         * <p>
         * Describes configuration information for a DataSync-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location. DataSync uses the default Amazon Web Services-managed
         * KMS key to encrypt this secret in Secrets Manager.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedSecretConfig.Builder} avoiding the
         * need to create one manually via {@link ManagedSecretConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedSecretConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #managedSecretConfig(ManagedSecretConfig)}.
         * 
         * @param managedSecretConfig
         *        a consumer that will call methods on {@link ManagedSecretConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedSecretConfig(ManagedSecretConfig)
         */
        default Builder managedSecretConfig(Consumer<ManagedSecretConfig.Builder> managedSecretConfig) {
            return managedSecretConfig(ManagedSecretConfig.builder().applyMutation(managedSecretConfig).build());
        }

        /**
         * <p>
         * Describes configuration information for a DataSync-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * </p>
         * 
         * @param cmkSecretConfig
         *        Describes configuration information for a DataSync-managed secret, such as an authentication token
         *        that DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmkSecretConfig(CmkSecretConfig cmkSecretConfig);

        /**
         * <p>
         * Describes configuration information for a DataSync-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link CmkSecretConfig.Builder} avoiding the
         * need to create one manually via {@link CmkSecretConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmkSecretConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cmkSecretConfig(CmkSecretConfig)}.
         * 
         * @param cmkSecretConfig
         *        a consumer that will call methods on {@link CmkSecretConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmkSecretConfig(CmkSecretConfig)
         */
        default Builder cmkSecretConfig(Consumer<CmkSecretConfig.Builder> cmkSecretConfig) {
            return cmkSecretConfig(CmkSecretConfig.builder().applyMutation(cmkSecretConfig).build());
        }

        /**
         * <p>
         * Describes configuration information for a customer-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * </p>
         * 
         * @param customSecretConfig
         *        Describes configuration information for a customer-managed secret, such as an authentication token
         *        that DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecretConfig(CustomSecretConfig customSecretConfig);

        /**
         * <p>
         * Describes configuration information for a customer-managed secret, such as an authentication token that
         * DataSync uses to access a specific storage location, with a customer-managed KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomSecretConfig.Builder} avoiding the
         * need to create one manually via {@link CustomSecretConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomSecretConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #customSecretConfig(CustomSecretConfig)}.
         * 
         * @param customSecretConfig
         *        a consumer that will call methods on {@link CustomSecretConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customSecretConfig(CustomSecretConfig)
         */
        default Builder customSecretConfig(Consumer<CustomSecretConfig.Builder> customSecretConfig) {
            return customSecretConfig(CustomSecretConfig.builder().applyMutation(customSecretConfig).build());
        }
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private String authenticationType;

        private String blobType;

        private String accessTier;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private ManagedSecretConfig managedSecretConfig;

        private CmkSecretConfig cmkSecretConfig;

        private CustomSecretConfig customSecretConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationAzureBlobResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            authenticationType(model.authenticationType);
            blobType(model.blobType);
            accessTier(model.accessTier);
            agentArns(model.agentArns);
            creationTime(model.creationTime);
            managedSecretConfig(model.managedSecretConfig);
            cmkSecretConfig(model.cmkSecretConfig);
            customSecretConfig(model.customSecretConfig);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AzureBlobAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getBlobType() {
            return blobType;
        }

        public final void setBlobType(String blobType) {
            this.blobType = blobType;
        }

        @Override
        public final Builder blobType(String blobType) {
            this.blobType = blobType;
            return this;
        }

        @Override
        public final Builder blobType(AzureBlobType blobType) {
            this.blobType(blobType == null ? null : blobType.toString());
            return this;
        }

        public final String getAccessTier() {
            return accessTier;
        }

        public final void setAccessTier(String accessTier) {
            this.accessTier = accessTier;
        }

        @Override
        public final Builder accessTier(String accessTier) {
            this.accessTier = accessTier;
            return this;
        }

        @Override
        public final Builder accessTier(AzureAccessTier accessTier) {
            this.accessTier(accessTier == null ? null : accessTier.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedSecretConfig.Builder getManagedSecretConfig() {
            return managedSecretConfig != null ? managedSecretConfig.toBuilder() : null;
        }

        public final void setManagedSecretConfig(ManagedSecretConfig.BuilderImpl managedSecretConfig) {
            this.managedSecretConfig = managedSecretConfig != null ? managedSecretConfig.build() : null;
        }

        @Override
        public final Builder managedSecretConfig(ManagedSecretConfig managedSecretConfig) {
            this.managedSecretConfig = managedSecretConfig;
            return this;
        }

        public final CmkSecretConfig.Builder getCmkSecretConfig() {
            return cmkSecretConfig != null ? cmkSecretConfig.toBuilder() : null;
        }

        public final void setCmkSecretConfig(CmkSecretConfig.BuilderImpl cmkSecretConfig) {
            this.cmkSecretConfig = cmkSecretConfig != null ? cmkSecretConfig.build() : null;
        }

        @Override
        public final Builder cmkSecretConfig(CmkSecretConfig cmkSecretConfig) {
            this.cmkSecretConfig = cmkSecretConfig;
            return this;
        }

        public final CustomSecretConfig.Builder getCustomSecretConfig() {
            return customSecretConfig != null ? customSecretConfig.toBuilder() : null;
        }

        public final void setCustomSecretConfig(CustomSecretConfig.BuilderImpl customSecretConfig) {
            this.customSecretConfig = customSecretConfig != null ? customSecretConfig.build() : null;
        }

        @Override
        public final Builder customSecretConfig(CustomSecretConfig customSecretConfig) {
            this.customSecretConfig = customSecretConfig;
            return this;
        }

        @Override
        public DescribeLocationAzureBlobResponse build() {
            return new DescribeLocationAzureBlobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
