/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datasync.model.ListTagsForResourceResponse;

public class ListTagsForResourcePublisher
implements SdkPublisher<ListTagsForResourceResponse> {
    private final DataSyncAsyncClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTagsForResourcePublisher(DataSyncAsyncClient client, ListTagsForResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTagsForResourcePublisher(DataSyncAsyncClient client, ListTagsForResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTagsForResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListTagsForResourcePublisher resume(ListTagsForResourceResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagsForResourcePublisher(this.client, (ListTagsForResourceRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTagsForResourcePublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTagsForResourceResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTagsForResourceResponseFetcher
    implements AsyncPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTagsForResourceResponse> nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourcePublisher.this.client.listTagsForResource(ListTagsForResourcePublisher.this.firstRequest);
            }
            return ListTagsForResourcePublisher.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

