/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateTaskResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTaskRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateTaskRequest.Builder, UpdateTaskRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTaskRequest::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Options> OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateTaskRequest::options)).setter(setter(Builder::options)).constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OPTIONS_FIELD,
            NAME_FIELD));

    private final String taskArn;

    private final Options options;

    private final String name;

    private UpdateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.options = builder.options;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource name of the task to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource name of the task to update.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * Returns the value of the Options property for this object.
     * 
     * @return The value of the Options property for this object.
     */
    public Options options() {
        return options;
    }

    /**
     * <p>
     * The name of the task to update.
     * </p>
     * 
     * @return The name of the task to update.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskRequest)) {
            return false;
        }
        UpdateTaskRequest other = (UpdateTaskRequest) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(options(), other.options())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTaskRequest").add("TaskArn", taskArn()).add("Options", options()).add("Name", name())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskRequest, T> g) {
        return obj -> g.apply((UpdateTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTaskRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource name of the task to update.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the resource name of the task to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * Sets the value of the Options property for this object.
         *
         * @param options
         *        The new value for the Options property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Options options);

        /**
         * Sets the value of the Options property for this object.
         *
         * This is a convenience that creates an instance of the {@link Options.Builder} avoiding the need to create one
         * manually via {@link Options#builder()}.
         *
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #options(Options)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Options)
         */
        default Builder options(Consumer<Options.Builder> options) {
            return options(Options.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The name of the task to update.
         * </p>
         * 
         * @param name
         *        The name of the task to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String taskArn;

        private Options options;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskRequest model) {
            super(model);
            taskArn(model.taskArn);
            options(model.options);
            name(model.name);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Options.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskRequest build() {
            return new UpdateTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
