/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateTaskRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTaskRequest.getter(UpdateTaskRequest::taskArn)).setter(UpdateTaskRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateTaskRequest.getter(UpdateTaskRequest::options)).setter(UpdateTaskRequest.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTaskRequest.getter(UpdateTaskRequest::name)).setter(UpdateTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OPTIONS_FIELD, NAME_FIELD));
    private final String taskArn;
    private final Options options;
    private final String name;

    private UpdateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.options = builder.options;
        this.name = builder.name;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public Options options() {
        return this.options;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskRequest)) {
            return false;
        }
        UpdateTaskRequest other = (UpdateTaskRequest)((Object)obj);
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTaskRequest").add("TaskArn", (Object)this.taskArn()).add("Options", (Object)this.options()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskRequest, T> g) {
        return obj -> g.apply((UpdateTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String taskArn;
        private Options options;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskRequest model) {
            super(model);
            this.taskArn(model.taskArn);
            this.options(model.options);
            this.name(model.name);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskRequest build() {
            return new UpdateTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskRequest> {
        public Builder taskArn(String var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

