/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the detailed result of a <code>TaskExecution</code> operation. This result includes the time in
 * milliseconds spent in each phase, the status of the task execution, and the errors encountered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskExecutionResultDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskExecutionResultDetail.Builder, TaskExecutionResultDetail> {
    private static final SdkField<Long> PREPARE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TaskExecutionResultDetail::prepareDuration)).setter(setter(Builder::prepareDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrepareDuration").build()).build();

    private static final SdkField<String> PREPARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskExecutionResultDetail::prepareStatusAsString)).setter(setter(Builder::prepareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrepareStatus").build()).build();

    private static final SdkField<Long> TRANSFER_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TaskExecutionResultDetail::transferDuration)).setter(setter(Builder::transferDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferDuration").build()).build();

    private static final SdkField<String> TRANSFER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskExecutionResultDetail::transferStatusAsString)).setter(setter(Builder::transferStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferStatus").build()).build();

    private static final SdkField<Long> VERIFY_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TaskExecutionResultDetail::verifyDuration)).setter(setter(Builder::verifyDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyDuration").build()).build();

    private static final SdkField<String> VERIFY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskExecutionResultDetail::verifyStatusAsString)).setter(setter(Builder::verifyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyStatus").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskExecutionResultDetail::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskExecutionResultDetail::errorDetail)).setter(setter(Builder::errorDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARE_DURATION_FIELD,
            PREPARE_STATUS_FIELD, TRANSFER_DURATION_FIELD, TRANSFER_STATUS_FIELD, VERIFY_DURATION_FIELD, VERIFY_STATUS_FIELD,
            ERROR_CODE_FIELD, ERROR_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long prepareDuration;

    private final String prepareStatus;

    private final Long transferDuration;

    private final String transferStatus;

    private final Long verifyDuration;

    private final String verifyStatus;

    private final String errorCode;

    private final String errorDetail;

    private TaskExecutionResultDetail(BuilderImpl builder) {
        this.prepareDuration = builder.prepareDuration;
        this.prepareStatus = builder.prepareStatus;
        this.transferDuration = builder.transferDuration;
        this.transferStatus = builder.transferStatus;
        this.verifyDuration = builder.verifyDuration;
        this.verifyStatus = builder.verifyStatus;
        this.errorCode = builder.errorCode;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * <p>
     * The total time in milliseconds that AWS DataSync spent in the PREPARING phase.
     * </p>
     * 
     * @return The total time in milliseconds that AWS DataSync spent in the PREPARING phase.
     */
    public Long prepareDuration() {
        return prepareDuration;
    }

    /**
     * <p>
     * The status of the PREPARING phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prepareStatus}
     * will return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prepareStatusAsString}.
     * </p>
     * 
     * @return The status of the PREPARING phase.
     * @see PhaseStatus
     */
    public PhaseStatus prepareStatus() {
        return PhaseStatus.fromValue(prepareStatus);
    }

    /**
     * <p>
     * The status of the PREPARING phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prepareStatus}
     * will return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prepareStatusAsString}.
     * </p>
     * 
     * @return The status of the PREPARING phase.
     * @see PhaseStatus
     */
    public String prepareStatusAsString() {
        return prepareStatus;
    }

    /**
     * <p>
     * The total time in milliseconds that AWS DataSync spent in the TRANSFERRING phase.
     * </p>
     * 
     * @return The total time in milliseconds that AWS DataSync spent in the TRANSFERRING phase.
     */
    public Long transferDuration() {
        return transferDuration;
    }

    /**
     * <p>
     * The status of the TRANSFERRING Phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferStatus}
     * will return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferStatusAsString}.
     * </p>
     * 
     * @return The status of the TRANSFERRING Phase.
     * @see PhaseStatus
     */
    public PhaseStatus transferStatus() {
        return PhaseStatus.fromValue(transferStatus);
    }

    /**
     * <p>
     * The status of the TRANSFERRING Phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferStatus}
     * will return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferStatusAsString}.
     * </p>
     * 
     * @return The status of the TRANSFERRING Phase.
     * @see PhaseStatus
     */
    public String transferStatusAsString() {
        return transferStatus;
    }

    /**
     * <p>
     * The total time in milliseconds that AWS DataSync spent in the VERIFYING phase.
     * </p>
     * 
     * @return The total time in milliseconds that AWS DataSync spent in the VERIFYING phase.
     */
    public Long verifyDuration() {
        return verifyDuration;
    }

    /**
     * <p>
     * The status of the VERIFYING Phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verifyStatus} will
     * return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #verifyStatusAsString}.
     * </p>
     * 
     * @return The status of the VERIFYING Phase.
     * @see PhaseStatus
     */
    public PhaseStatus verifyStatus() {
        return PhaseStatus.fromValue(verifyStatus);
    }

    /**
     * <p>
     * The status of the VERIFYING Phase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verifyStatus} will
     * return {@link PhaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #verifyStatusAsString}.
     * </p>
     * 
     * @return The status of the VERIFYING Phase.
     * @see PhaseStatus
     */
    public String verifyStatusAsString() {
        return verifyStatus;
    }

    /**
     * <p>
     * Errors that AWS DataSync encountered during execution of the task. You can use this error code to help
     * troubleshoot issues.
     * </p>
     * 
     * @return Errors that AWS DataSync encountered during execution of the task. You can use this error code to help
     *         troubleshoot issues.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * Detailed description of an error that was encountered during the task execution. You can use this information to
     * help troubleshoot issues.
     * </p>
     * 
     * @return Detailed description of an error that was encountered during the task execution. You can use this
     *         information to help troubleshoot issues.
     */
    public String errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prepareDuration());
        hashCode = 31 * hashCode + Objects.hashCode(prepareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transferDuration());
        hashCode = 31 * hashCode + Objects.hashCode(transferStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verifyDuration());
        hashCode = 31 * hashCode + Objects.hashCode(verifyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionResultDetail)) {
            return false;
        }
        TaskExecutionResultDetail other = (TaskExecutionResultDetail) obj;
        return Objects.equals(prepareDuration(), other.prepareDuration())
                && Objects.equals(prepareStatusAsString(), other.prepareStatusAsString())
                && Objects.equals(transferDuration(), other.transferDuration())
                && Objects.equals(transferStatusAsString(), other.transferStatusAsString())
                && Objects.equals(verifyDuration(), other.verifyDuration())
                && Objects.equals(verifyStatusAsString(), other.verifyStatusAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TaskExecutionResultDetail").add("PrepareDuration", prepareDuration())
                .add("PrepareStatus", prepareStatusAsString()).add("TransferDuration", transferDuration())
                .add("TransferStatus", transferStatusAsString()).add("VerifyDuration", verifyDuration())
                .add("VerifyStatus", verifyStatusAsString()).add("ErrorCode", errorCode()).add("ErrorDetail", errorDetail())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrepareDuration":
            return Optional.ofNullable(clazz.cast(prepareDuration()));
        case "PrepareStatus":
            return Optional.ofNullable(clazz.cast(prepareStatusAsString()));
        case "TransferDuration":
            return Optional.ofNullable(clazz.cast(transferDuration()));
        case "TransferStatus":
            return Optional.ofNullable(clazz.cast(transferStatusAsString()));
        case "VerifyDuration":
            return Optional.ofNullable(clazz.cast(verifyDuration()));
        case "VerifyStatus":
            return Optional.ofNullable(clazz.cast(verifyStatusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionResultDetail, T> g) {
        return obj -> g.apply((TaskExecutionResultDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskExecutionResultDetail> {
        /**
         * <p>
         * The total time in milliseconds that AWS DataSync spent in the PREPARING phase.
         * </p>
         * 
         * @param prepareDuration
         *        The total time in milliseconds that AWS DataSync spent in the PREPARING phase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prepareDuration(Long prepareDuration);

        /**
         * <p>
         * The status of the PREPARING phase.
         * </p>
         * 
         * @param prepareStatus
         *        The status of the PREPARING phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder prepareStatus(String prepareStatus);

        /**
         * <p>
         * The status of the PREPARING phase.
         * </p>
         * 
         * @param prepareStatus
         *        The status of the PREPARING phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder prepareStatus(PhaseStatus prepareStatus);

        /**
         * <p>
         * The total time in milliseconds that AWS DataSync spent in the TRANSFERRING phase.
         * </p>
         * 
         * @param transferDuration
         *        The total time in milliseconds that AWS DataSync spent in the TRANSFERRING phase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferDuration(Long transferDuration);

        /**
         * <p>
         * The status of the TRANSFERRING Phase.
         * </p>
         * 
         * @param transferStatus
         *        The status of the TRANSFERRING Phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder transferStatus(String transferStatus);

        /**
         * <p>
         * The status of the TRANSFERRING Phase.
         * </p>
         * 
         * @param transferStatus
         *        The status of the TRANSFERRING Phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder transferStatus(PhaseStatus transferStatus);

        /**
         * <p>
         * The total time in milliseconds that AWS DataSync spent in the VERIFYING phase.
         * </p>
         * 
         * @param verifyDuration
         *        The total time in milliseconds that AWS DataSync spent in the VERIFYING phase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifyDuration(Long verifyDuration);

        /**
         * <p>
         * The status of the VERIFYING Phase.
         * </p>
         * 
         * @param verifyStatus
         *        The status of the VERIFYING Phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder verifyStatus(String verifyStatus);

        /**
         * <p>
         * The status of the VERIFYING Phase.
         * </p>
         * 
         * @param verifyStatus
         *        The status of the VERIFYING Phase.
         * @see PhaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhaseStatus
         */
        Builder verifyStatus(PhaseStatus verifyStatus);

        /**
         * <p>
         * Errors that AWS DataSync encountered during execution of the task. You can use this error code to help
         * troubleshoot issues.
         * </p>
         * 
         * @param errorCode
         *        Errors that AWS DataSync encountered during execution of the task. You can use this error code to help
         *        troubleshoot issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Detailed description of an error that was encountered during the task execution. You can use this information
         * to help troubleshoot issues.
         * </p>
         * 
         * @param errorDetail
         *        Detailed description of an error that was encountered during the task execution. You can use this
         *        information to help troubleshoot issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(String errorDetail);
    }

    static final class BuilderImpl implements Builder {
        private Long prepareDuration;

        private String prepareStatus;

        private Long transferDuration;

        private String transferStatus;

        private Long verifyDuration;

        private String verifyStatus;

        private String errorCode;

        private String errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionResultDetail model) {
            prepareDuration(model.prepareDuration);
            prepareStatus(model.prepareStatus);
            transferDuration(model.transferDuration);
            transferStatus(model.transferStatus);
            verifyDuration(model.verifyDuration);
            verifyStatus(model.verifyStatus);
            errorCode(model.errorCode);
            errorDetail(model.errorDetail);
        }

        public final Long getPrepareDuration() {
            return prepareDuration;
        }

        @Override
        public final Builder prepareDuration(Long prepareDuration) {
            this.prepareDuration = prepareDuration;
            return this;
        }

        public final void setPrepareDuration(Long prepareDuration) {
            this.prepareDuration = prepareDuration;
        }

        public final String getPrepareStatusAsString() {
            return prepareStatus;
        }

        @Override
        public final Builder prepareStatus(String prepareStatus) {
            this.prepareStatus = prepareStatus;
            return this;
        }

        @Override
        public final Builder prepareStatus(PhaseStatus prepareStatus) {
            this.prepareStatus(prepareStatus.toString());
            return this;
        }

        public final void setPrepareStatus(String prepareStatus) {
            this.prepareStatus = prepareStatus;
        }

        public final Long getTransferDuration() {
            return transferDuration;
        }

        @Override
        public final Builder transferDuration(Long transferDuration) {
            this.transferDuration = transferDuration;
            return this;
        }

        public final void setTransferDuration(Long transferDuration) {
            this.transferDuration = transferDuration;
        }

        public final String getTransferStatusAsString() {
            return transferStatus;
        }

        @Override
        public final Builder transferStatus(String transferStatus) {
            this.transferStatus = transferStatus;
            return this;
        }

        @Override
        public final Builder transferStatus(PhaseStatus transferStatus) {
            this.transferStatus(transferStatus.toString());
            return this;
        }

        public final void setTransferStatus(String transferStatus) {
            this.transferStatus = transferStatus;
        }

        public final Long getVerifyDuration() {
            return verifyDuration;
        }

        @Override
        public final Builder verifyDuration(Long verifyDuration) {
            this.verifyDuration = verifyDuration;
            return this;
        }

        public final void setVerifyDuration(Long verifyDuration) {
            this.verifyDuration = verifyDuration;
        }

        public final String getVerifyStatusAsString() {
            return verifyStatus;
        }

        @Override
        public final Builder verifyStatus(String verifyStatus) {
            this.verifyStatus = verifyStatus;
            return this;
        }

        @Override
        public final Builder verifyStatus(PhaseStatus verifyStatus) {
            this.verifyStatus(verifyStatus.toString());
            return this;
        }

        public final void setVerifyStatus(String verifyStatus) {
            this.verifyStatus = verifyStatus;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetail() {
            return errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        @Override
        public TaskExecutionResultDetail build() {
            return new TaskExecutionResultDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
