/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeAgentResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeAgentResponse.Builder, DescribeAgentResponse> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAgentResponse::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAgentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAgentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_CONNECTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAgentResponse::lastConnectionTime)).setter(setter(Builder::lastConnectionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionTime").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAgentResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, LAST_CONNECTION_TIME_FIELD, CREATION_TIME_FIELD));

    private final String agentArn;

    private final String name;

    private final String status;

    private final Instant lastConnectionTime;

    private final Instant creationTime;

    private DescribeAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastConnectionTime = builder.lastConnectionTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent.
     */
    public String agentArn() {
        return agentArn;
    }

    /**
     * <p>
     * The name of the agent.
     * </p>
     * 
     * @return The name of the agent.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use.
     * The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned
     * off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent
     * returns to ONLINE status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the agent. If the status is ONLINE, then the agent is configured properly and is available
     *         to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the
     *         agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy
     *         state is resolved, the agent returns to ONLINE status.
     * @see AgentStatus
     */
    public AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use.
     * The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned
     * off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent
     * returns to ONLINE status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the agent. If the status is ONLINE, then the agent is configured properly and is available
     *         to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the
     *         agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy
     *         state is resolved, the agent returns to ONLINE status.
     * @see AgentStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the agent last connected to DataSyc.
     * </p>
     * 
     * @return The time that the agent last connected to DataSyc.
     */
    public Instant lastConnectionTime() {
        return lastConnectionTime;
    }

    /**
     * <p>
     * The time that the agent was activated (that is, created in your account).
     * </p>
     * 
     * @return The time that the agent was activated (that is, created in your account).
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastConnectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentResponse)) {
            return false;
        }
        DescribeAgentResponse other = (DescribeAgentResponse) obj;
        return Objects.equals(agentArn(), other.agentArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastConnectionTime(), other.lastConnectionTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAgentResponse").add("AgentArn", agentArn()).add("Name", name())
                .add("Status", statusAsString()).add("LastConnectionTime", lastConnectionTime())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastConnectionTime":
            return Optional.ofNullable(clazz.cast(lastConnectionTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentResponse, T> g) {
        return obj -> g.apply((DescribeAgentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAgentResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent.
         * </p>
         * 
         * @param agentArn
         *        The Amazon Resource Name (ARN) of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);

        /**
         * <p>
         * The name of the agent.
         * </p>
         * 
         * @param name
         *        The name of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to
         * use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM
         * is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is
         * resolved, the agent returns to ONLINE status.
         * </p>
         * 
         * @param status
         *        The status of the agent. If the status is ONLINE, then the agent is configured properly and is
         *        available to use. The Running status is the normal running status for an agent. If the status is
         *        OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that
         *        caused the unhealthy state is resolved, the agent returns to ONLINE status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to
         * use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM
         * is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is
         * resolved, the agent returns to ONLINE status.
         * </p>
         * 
         * @param status
         *        The status of the agent. If the status is ONLINE, then the agent is configured properly and is
         *        available to use. The Running status is the normal running status for an agent. If the status is
         *        OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that
         *        caused the unhealthy state is resolved, the agent returns to ONLINE status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);

        /**
         * <p>
         * The time that the agent last connected to DataSyc.
         * </p>
         * 
         * @param lastConnectionTime
         *        The time that the agent last connected to DataSyc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastConnectionTime(Instant lastConnectionTime);

        /**
         * <p>
         * The time that the agent was activated (that is, created in your account).
         * </p>
         * 
         * @param creationTime
         *        The time that the agent was activated (that is, created in your account).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String agentArn;

        private String name;

        private String status;

        private Instant lastConnectionTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentResponse model) {
            super(model);
            agentArn(model.agentArn);
            name(model.name);
            status(model.status);
            lastConnectionTime(model.lastConnectionTime);
            creationTime(model.creationTime);
        }

        public final String getAgentArn() {
            return agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastConnectionTime() {
            return lastConnectionTime;
        }

        @Override
        public final Builder lastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
            return this;
        }

        public final void setLastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeAgentResponse build() {
            return new DescribeAgentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
