/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;

public class ListAgentsPublisher
implements SdkPublisher<ListAgentsResponse> {
    private final DataSyncAsyncClient client;
    private final ListAgentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentsPublisher(DataSyncAsyncClient client, ListAgentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentsPublisher(DataSyncAsyncClient client, ListAgentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAgentsResponseFetcher
    implements AsyncPageFetcher<ListAgentsResponse> {
        private ListAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentsResponse> nextPage(ListAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentsPublisher.this.client.listAgents(ListAgentsPublisher.this.firstRequest);
            }
            return ListAgentsPublisher.this.client.listAgents((ListAgentsRequest)((Object)ListAgentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

