/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies which files, folders and objects to include or exclude when transferring files from source to destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterRule implements SdkPojo, Serializable, ToCopyableBuilder<FilterRule.Builder, FilterRule> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FilterRule::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FilterRule::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FILTER_TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterType;

    private final String value;

    private FilterRule(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
     * @see FilterType
     */
    public FilterType filterType() {
        return FilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
     * @see FilterType
     */
    public String filterTypeAsString() {
        return filterType;
    }

    /**
     * <p>
     * A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|"
     * (that is, a pipe), for example: <code>/folder1|/folder2</code>
     * </p>
     * <p>
     * </p>
     * 
     * @return A single filter string that consists of the patterns to include or exclude. The patterns are delimited by
     *         "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
     *         <p>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterRule)) {
            return false;
        }
        FilterRule other = (FilterRule) obj;
        return Objects.equals(filterTypeAsString(), other.filterTypeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FilterRule").add("FilterType", filterTypeAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterRule, T> g) {
        return obj -> g.apply((FilterRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterRule> {
        /**
         * <p>
         * The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
         * </p>
         * 
         * @param filterType
         *        The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
         * </p>
         * 
         * @param filterType
         *        The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(FilterType filterType);

        /**
         * <p>
         * A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|"
         * (that is, a pipe), for example: <code>/folder1|/folder2</code>
         * </p>
         * <p>
         * </p>
         * 
         * @param value
         *        A single filter string that consists of the patterns to include or exclude. The patterns are delimited
         *        by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String filterType;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterRule model) {
            filterType(model.filterType);
            value(model.value);
        }

        public final String getFilterTypeAsString() {
            return filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public FilterRule build() {
            return new FilterRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
