/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointOptions implements SdkPojo, Serializable, ToCopyableBuilder<EndpointOptions.Builder, EndpointOptions> {
    private static final SdkField<Boolean> FIPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EndpointOptions::fips)).setter(setter(Builder::fips))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fips").build()).build();

    private static final SdkField<Boolean> PRIVATE_LINK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EndpointOptions::privateLink)).setter(setter(Builder::privateLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLink").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIPS_FIELD, PRIVATE_LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean fips;

    private final Boolean privateLink;

    private EndpointOptions(BuilderImpl builder) {
        this.fips = builder.fips;
        this.privateLink = builder.privateLink;
    }

    /**
     * Returns the value of the Fips property for this object.
     * 
     * @return The value of the Fips property for this object.
     */
    public Boolean fips() {
        return fips;
    }

    /**
     * Returns the value of the PrivateLink property for this object.
     * 
     * @return The value of the PrivateLink property for this object.
     */
    public Boolean privateLink() {
        return privateLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fips());
        hashCode = 31 * hashCode + Objects.hashCode(privateLink());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointOptions)) {
            return false;
        }
        EndpointOptions other = (EndpointOptions) obj;
        return Objects.equals(fips(), other.fips()) && Objects.equals(privateLink(), other.privateLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointOptions").add("Fips", fips()).add("PrivateLink", privateLink()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fips":
            return Optional.ofNullable(clazz.cast(fips()));
        case "PrivateLink":
            return Optional.ofNullable(clazz.cast(privateLink()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointOptions, T> g) {
        return obj -> g.apply((EndpointOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointOptions> {
        /**
         * Sets the value of the Fips property for this object.
         *
         * @param fips
         *        The new value for the Fips property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fips(Boolean fips);

        /**
         * Sets the value of the PrivateLink property for this object.
         *
         * @param privateLink
         *        The new value for the PrivateLink property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLink(Boolean privateLink);
    }

    static final class BuilderImpl implements Builder {
        private Boolean fips;

        private Boolean privateLink;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointOptions model) {
            fips(model.fips);
            privateLink(model.privateLink);
        }

        public final Boolean getFips() {
            return fips;
        }

        @Override
        public final Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public final void setFips(Boolean fips) {
            this.fips = fips;
        }

        public final Boolean getPrivateLink() {
            return privateLink;
        }

        @Override
        public final Builder privateLink(Boolean privateLink) {
            this.privateLink = privateLink;
            return this;
        }

        public final void setPrivateLink(Boolean privateLink) {
            this.privateLink = privateLink;
        }

        @Override
        public EndpointOptions build() {
            return new EndpointOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
