/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateLinkConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateLinkConfig.Builder, PrivateLinkConfig> {
    private static final SdkField<String> PRIVATE_LINK_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PrivateLinkConfig::privateLinkEndpoint)).setter(setter(Builder::privateLinkEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkEndpoint").build())
            .build();

    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PrivateLinkConfig::subnetArns))
            .setter(setter(Builder::subnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PrivateLinkConfig::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_LINK_ENDPOINT_FIELD,
            SUBNET_ARNS_FIELD, SECURITY_GROUP_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String privateLinkEndpoint;

    private final List<String> subnetArns;

    private final List<String> securityGroupArns;

    private PrivateLinkConfig(BuilderImpl builder) {
        this.privateLinkEndpoint = builder.privateLinkEndpoint;
        this.subnetArns = builder.subnetArns;
        this.securityGroupArns = builder.securityGroupArns;
    }

    /**
     * Returns the value of the PrivateLinkEndpoint property for this object.
     * 
     * @return The value of the PrivateLinkEndpoint property for this object.
     */
    public String privateLinkEndpoint() {
        return privateLinkEndpoint;
    }

    /**
     * Returns the value of the SubnetArns property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the SubnetArns property for this object.
     */
    public List<String> subnetArns() {
        return subnetArns;
    }

    /**
     * Returns the value of the SecurityGroupArns property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the SecurityGroupArns property for this object.
     */
    public List<String> securityGroupArns() {
        return securityGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privateLinkEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(subnetArns());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateLinkConfig)) {
            return false;
        }
        PrivateLinkConfig other = (PrivateLinkConfig) obj;
        return Objects.equals(privateLinkEndpoint(), other.privateLinkEndpoint())
                && Objects.equals(subnetArns(), other.subnetArns())
                && Objects.equals(securityGroupArns(), other.securityGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PrivateLinkConfig").add("PrivateLinkEndpoint", privateLinkEndpoint())
                .add("SubnetArns", subnetArns()).add("SecurityGroupArns", securityGroupArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrivateLinkEndpoint":
            return Optional.ofNullable(clazz.cast(privateLinkEndpoint()));
        case "SubnetArns":
            return Optional.ofNullable(clazz.cast(subnetArns()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateLinkConfig, T> g) {
        return obj -> g.apply((PrivateLinkConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateLinkConfig> {
        /**
         * Sets the value of the PrivateLinkEndpoint property for this object.
         *
         * @param privateLinkEndpoint
         *        The new value for the PrivateLinkEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLinkEndpoint(String privateLinkEndpoint);

        /**
         * Sets the value of the SubnetArns property for this object.
         *
         * @param subnetArns
         *        The new value for the SubnetArns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(Collection<String> subnetArns);

        /**
         * Sets the value of the SubnetArns property for this object.
         *
         * @param subnetArns
         *        The new value for the SubnetArns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(String... subnetArns);

        /**
         * Sets the value of the SecurityGroupArns property for this object.
         *
         * @param securityGroupArns
         *        The new value for the SecurityGroupArns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * Sets the value of the SecurityGroupArns property for this object.
         *
         * @param securityGroupArns
         *        The new value for the SecurityGroupArns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);
    }

    static final class BuilderImpl implements Builder {
        private String privateLinkEndpoint;

        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateLinkConfig model) {
            privateLinkEndpoint(model.privateLinkEndpoint);
            subnetArns(model.subnetArns);
            securityGroupArns(model.securityGroupArns);
        }

        public final String getPrivateLinkEndpoint() {
            return privateLinkEndpoint;
        }

        @Override
        public final Builder privateLinkEndpoint(String privateLinkEndpoint) {
            this.privateLinkEndpoint = privateLinkEndpoint;
            return this;
        }

        public final void setPrivateLinkEndpoint(String privateLinkEndpoint) {
            this.privateLinkEndpoint = privateLinkEndpoint;
        }

        public final Collection<String> getSubnetArns() {
            return subnetArns;
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String... subnetArns) {
            subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
        }

        public final Collection<String> getSecurityGroupArns() {
            return securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public PrivateLinkConfig build() {
            return new PrivateLinkConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
