/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single entry in a list of locations. <code>LocationListEntry</code> returns an array that contains a
 * list of locations when the <a>ListLocations</a> operation is called.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<LocationListEntry.Builder, LocationListEntry> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LocationListEntry::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LocationListEntry::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String locationArn;

    private final String locationUri;

    private LocationListEntry(BuilderImpl builder) {
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the
     * export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the
     * location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location
     *         is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the
     *         root of the location.
     */
    public String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Represents a list of URLs of a location. <code>LocationUri</code> returns an array that contains a list of
     * locations when the <a>ListLocations</a> operation is called.
     * </p>
     * <p>
     * Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.
     * </p>
     * <p>
     * TYPE designates the type of location. Valid values: NFS | EFS | S3.
     * </p>
     * <p>
     * GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is
     * <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>.
     * An example for NFS is a valid IPv4 address or a host name compliant with Domain Name Service (DNS).
     * </p>
     * <p>
     * SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon
     * EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat
     * as the root of the location.
     * </p>
     * <p/>
     * 
     * @return Represents a list of URLs of a location. <code>LocationUri</code> returns an array that contains a list
     *         of locations when the <a>ListLocations</a> operation is called.
     *         </p>
     *         <p>
     *         Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.
     *         </p>
     *         <p>
     *         TYPE designates the type of location. Valid values: NFS | EFS | S3.
     *         </p>
     *         <p>
     *         GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS
     *         is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as
     *         <code>myBucket</code>. An example for NFS is a valid IPv4 address or a host name compliant with Domain
     *         Name Service (DNS).
     *         </p>
     *         <p>
     *         SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and
     *         Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you
     *         mount to and treat as the root of the location.
     *         </p>
     */
    public String locationUri() {
        return locationUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationListEntry)) {
            return false;
        }
        LocationListEntry other = (LocationListEntry) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocationListEntry").add("LocationArn", locationArn()).add("LocationUri", locationUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocationListEntry, T> g) {
        return obj -> g.apply((LocationListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationListEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is
         * the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of
         * the location.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the
         *        location is the export path. For Amazon S3, the location is the prefix path that you want to mount and
         *        use as the root of the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Represents a list of URLs of a location. <code>LocationUri</code> returns an array that contains a list of
         * locations when the <a>ListLocations</a> operation is called.
         * </p>
         * <p>
         * Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.
         * </p>
         * <p>
         * TYPE designates the type of location. Valid values: NFS | EFS | S3.
         * </p>
         * <p>
         * GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is
         * <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as
         * <code>myBucket</code>. An example for NFS is a valid IPv4 address or a host name compliant with Domain Name
         * Service (DNS).
         * </p>
         * <p>
         * SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and
         * Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to
         * and treat as the root of the location.
         * </p>
         * <p/>
         * 
         * @param locationUri
         *        Represents a list of URLs of a location. <code>LocationUri</code> returns an array that contains a
         *        list of locations when the <a>ListLocations</a> operation is called.
         *        </p>
         *        <p>
         *        Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.
         *        </p>
         *        <p>
         *        TYPE designates the type of location. Valid values: NFS | EFS | S3.
         *        </p>
         *        <p>
         *        GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for
         *        EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as
         *        <code>myBucket</code>. An example for NFS is a valid IPv4 address or a host name compliant with Domain
         *        Name Service (DNS).
         *        </p>
         *        <p>
         *        SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS
         *        and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that
         *        you mount to and treat as the root of the location.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);
    }

    static final class BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationListEntry model) {
            locationArn(model.locationArn);
            locationUri(model.locationUri);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public LocationListEntry build() {
            return new LocationListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
