/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DataSourceErrorType {
    ACCESS_DENIED_EXCEPTION("ACCESS_DENIED_EXCEPTION"),

    CONFLICT_EXCEPTION("CONFLICT_EXCEPTION"),

    INTERNAL_SERVER_EXCEPTION("INTERNAL_SERVER_EXCEPTION"),

    RESOURCE_NOT_FOUND_EXCEPTION("RESOURCE_NOT_FOUND_EXCEPTION"),

    SERVICE_QUOTA_EXCEEDED_EXCEPTION("SERVICE_QUOTA_EXCEEDED_EXCEPTION"),

    THROTTLING_EXCEPTION("THROTTLING_EXCEPTION"),

    VALIDATION_EXCEPTION("VALIDATION_EXCEPTION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceErrorType> VALUE_MAP = EnumUtils.uniqueIndex(DataSourceErrorType.class,
            DataSourceErrorType::toString);

    private final String value;

    private DataSourceErrorType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DataSourceErrorType corresponding to the value
     */
    public static DataSourceErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DataSourceErrorType}s
     */
    public static Set<DataSourceErrorType> knownValues() {
        Set<DataSourceErrorType> knownValues = EnumSet.allOf(DataSourceErrorType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
