/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RejectSubscriptionRequestOutputSubscribedListingsListCopier {
    static List<SubscribedListing> copy(
            Collection<? extends SubscribedListing> rejectSubscriptionRequestOutputSubscribedListingsListParam) {
        List<SubscribedListing> list;
        if (rejectSubscriptionRequestOutputSubscribedListingsListParam == null
                || rejectSubscriptionRequestOutputSubscribedListingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubscribedListing> modifiableList = new ArrayList<>();
            rejectSubscriptionRequestOutputSubscribedListingsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SubscribedListing> copyFromBuilder(
            Collection<? extends SubscribedListing.Builder> rejectSubscriptionRequestOutputSubscribedListingsListParam) {
        List<SubscribedListing> list;
        if (rejectSubscriptionRequestOutputSubscribedListingsListParam == null
                || rejectSubscriptionRequestOutputSubscribedListingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubscribedListing> modifiableList = new ArrayList<>();
            rejectSubscriptionRequestOutputSubscribedListingsListParam.forEach(entry -> {
                SubscribedListing member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SubscribedListing.Builder> copyToBuilder(
            Collection<? extends SubscribedListing> rejectSubscriptionRequestOutputSubscribedListingsListParam) {
        List<SubscribedListing.Builder> list;
        if (rejectSubscriptionRequestOutputSubscribedListingsListParam == null
                || rejectSubscriptionRequestOutputSubscribedListingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubscribedListing.Builder> modifiableList = new ArrayList<>();
            rejectSubscriptionRequestOutputSubscribedListingsListParam.forEach(entry -> {
                SubscribedListing.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
