/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The additional attributes of an inventory asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetItemAdditionalAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetItemAdditionalAttributes.Builder, AssetItemAdditionalAttributes> {
    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("formsOutput")
            .getter(getter(AssetItemAdditionalAttributes::formsOutput))
            .setter(setter(Builder::formsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FormOutput>> READ_ONLY_FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("readOnlyFormsOutput")
            .getter(getter(AssetItemAdditionalAttributes::readOnlyFormsOutput))
            .setter(setter(Builder::readOnlyFormsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyFormsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMS_OUTPUT_FIELD,
            READ_ONLY_FORMS_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FormOutput> formsOutput;

    private final List<FormOutput> readOnlyFormsOutput;

    private AssetItemAdditionalAttributes(BuilderImpl builder) {
        this.formsOutput = builder.formsOutput;
        this.readOnlyFormsOutput = builder.readOnlyFormsOutput;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormsOutput() {
        return formsOutput != null && !(formsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forms included in the additional attributes of an inventory asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsOutput} method.
     * </p>
     * 
     * @return The forms included in the additional attributes of an inventory asset.
     */
    public final List<FormOutput> formsOutput() {
        return formsOutput;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadOnlyFormsOutput property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadOnlyFormsOutput() {
        return readOnlyFormsOutput != null && !(readOnlyFormsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The read-only forms included in the additional attributes of an inventory asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadOnlyFormsOutput} method.
     * </p>
     * 
     * @return The read-only forms included in the additional attributes of an inventory asset.
     */
    public final List<FormOutput> readOnlyFormsOutput() {
        return readOnlyFormsOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsOutput() ? formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReadOnlyFormsOutput() ? readOnlyFormsOutput() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetItemAdditionalAttributes)) {
            return false;
        }
        AssetItemAdditionalAttributes other = (AssetItemAdditionalAttributes) obj;
        return hasFormsOutput() == other.hasFormsOutput() && Objects.equals(formsOutput(), other.formsOutput())
                && hasReadOnlyFormsOutput() == other.hasReadOnlyFormsOutput()
                && Objects.equals(readOnlyFormsOutput(), other.readOnlyFormsOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetItemAdditionalAttributes").add("FormsOutput", hasFormsOutput() ? formsOutput() : null)
                .add("ReadOnlyFormsOutput", hasReadOnlyFormsOutput() ? readOnlyFormsOutput() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "formsOutput":
            return Optional.ofNullable(clazz.cast(formsOutput()));
        case "readOnlyFormsOutput":
            return Optional.ofNullable(clazz.cast(readOnlyFormsOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetItemAdditionalAttributes, T> g) {
        return obj -> g.apply((AssetItemAdditionalAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetItemAdditionalAttributes> {
        /**
         * <p>
         * The forms included in the additional attributes of an inventory asset.
         * </p>
         * 
         * @param formsOutput
         *        The forms included in the additional attributes of an inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(Collection<FormOutput> formsOutput);

        /**
         * <p>
         * The forms included in the additional attributes of an inventory asset.
         * </p>
         * 
         * @param formsOutput
         *        The forms included in the additional attributes of an inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(FormOutput... formsOutput);

        /**
         * <p>
         * The forms included in the additional attributes of an inventory asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #formsOutput(List<FormOutput>)}.
         * 
         * @param formsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formsOutput(java.util.Collection<FormOutput>)
         */
        Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput);

        /**
         * <p>
         * The read-only forms included in the additional attributes of an inventory asset.
         * </p>
         * 
         * @param readOnlyFormsOutput
         *        The read-only forms included in the additional attributes of an inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput);

        /**
         * <p>
         * The read-only forms included in the additional attributes of an inventory asset.
         * </p>
         * 
         * @param readOnlyFormsOutput
         *        The read-only forms included in the additional attributes of an inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFormsOutput(FormOutput... readOnlyFormsOutput);

        /**
         * <p>
         * The read-only forms included in the additional attributes of an inventory asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #readOnlyFormsOutput(List<FormOutput>)}.
         * 
         * @param readOnlyFormsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readOnlyFormsOutput(java.util.Collection<FormOutput>)
         */
        Builder readOnlyFormsOutput(Consumer<FormOutput.Builder>... readOnlyFormsOutput);
    }

    static final class BuilderImpl implements Builder {
        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();

        private List<FormOutput> readOnlyFormsOutput = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetItemAdditionalAttributes model) {
            formsOutput(model.formsOutput);
            readOnlyFormsOutput(model.readOnlyFormsOutput);
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput... formsOutput) {
            formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput) {
            formsOutput(Stream.of(formsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FormOutput.Builder> getReadOnlyFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.readOnlyFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFormsOutput(Collection<FormOutput.BuilderImpl> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copyFromBuilder(readOnlyFormsOutput);
        }

        @Override
        public final Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copy(readOnlyFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(FormOutput... readOnlyFormsOutput) {
            readOnlyFormsOutput(Arrays.asList(readOnlyFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(Consumer<FormOutput.Builder>... readOnlyFormsOutput) {
            readOnlyFormsOutput(Stream.of(readOnlyFormsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetItemAdditionalAttributes build() {
            return new AssetItemAdditionalAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
