/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssetResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetAssetResponse.Builder, GetAssetResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetAssetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetAssetResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAssetResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetAssetResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalIdentifier").getter(getter(GetAssetResponse::externalIdentifier))
            .setter(setter(Builder::externalIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build())
            .build();

    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstRevisionCreatedAt").getter(getter(GetAssetResponse::firstRevisionCreatedAt))
            .setter(setter(Builder::firstRevisionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build())
            .build();

    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstRevisionCreatedBy").getter(getter(GetAssetResponse::firstRevisionCreatedBy))
            .setter(setter(Builder::firstRevisionCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build())
            .build();

    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("formsOutput")
            .getter(getter(GetAssetResponse::formsOutput))
            .setter(setter(Builder::formsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(GetAssetResponse::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAssetResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<AssetListingDetails> LISTING_FIELD = SdkField
            .<AssetListingDetails> builder(MarshallingType.SDK_POJO).memberName("listing")
            .getter(getter(GetAssetResponse::listing)).setter(setter(Builder::listing)).constructor(AssetListingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listing").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAssetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(GetAssetResponse::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<List<FormOutput>> READ_ONLY_FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("readOnlyFormsOutput")
            .getter(getter(GetAssetResponse::readOnlyFormsOutput))
            .setter(setter(Builder::readOnlyFormsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyFormsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(GetAssetResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(GetAssetResponse::typeIdentifier))
            .setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(GetAssetResponse::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EXTERNAL_IDENTIFIER_FIELD, FIRST_REVISION_CREATED_AT_FIELD,
            FIRST_REVISION_CREATED_BY_FIELD, FORMS_OUTPUT_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, LISTING_FIELD, NAME_FIELD,
            OWNING_PROJECT_ID_FIELD, READ_ONLY_FORMS_OUTPUT_FIELD, REVISION_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String externalIdentifier;

    private final Instant firstRevisionCreatedAt;

    private final String firstRevisionCreatedBy;

    private final List<FormOutput> formsOutput;

    private final List<String> glossaryTerms;

    private final String id;

    private final AssetListingDetails listing;

    private final String name;

    private final String owningProjectId;

    private final List<FormOutput> readOnlyFormsOutput;

    private final String revision;

    private final String typeIdentifier;

    private final String typeRevision;

    private GetAssetResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.externalIdentifier = builder.externalIdentifier;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.formsOutput = builder.formsOutput;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.listing = builder.listing;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.readOnlyFormsOutput = builder.readOnlyFormsOutput;
        this.revision = builder.revision;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * The timestamp of when the asset was created.
     * </p>
     * 
     * @return The timestamp of when the asset was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the asset.
     * </p>
     * 
     * @return The Amazon DataZone user who created the asset.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the Amazon DataZone asset.
     * </p>
     * 
     * @return The description of the Amazon DataZone asset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain to which the asset belongs.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain to which the asset belongs.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String externalIdentifier() {
        return externalIdentifier;
    }

    /**
     * <p>
     * The timestamp of when the first revision of the asset was created.
     * </p>
     * 
     * @return The timestamp of when the first revision of the asset was created.
     */
    public final Instant firstRevisionCreatedAt() {
        return firstRevisionCreatedAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the first revision of the asset.
     * </p>
     * 
     * @return The Amazon DataZone user who created the first revision of the asset.
     */
    public final String firstRevisionCreatedBy() {
        return firstRevisionCreatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormsOutput() {
        return formsOutput != null && !(formsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata forms attached to the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsOutput} method.
     * </p>
     * 
     * @return The metadata forms attached to the asset.
     */
    public final List<FormOutput> formsOutput() {
        return formsOutput;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The business glossary terms attached to the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The business glossary terms attached to the asset.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String id() {
        return id;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final AssetListingDetails listing() {
        return listing;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project that owns the asset.
     * </p>
     * 
     * @return The ID of the project that owns the asset.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadOnlyFormsOutput property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadOnlyFormsOutput() {
        return readOnlyFormsOutput != null && !(readOnlyFormsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The read-only metadata forms attached to the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadOnlyFormsOutput} method.
     * </p>
     * 
     * @return The read-only metadata forms attached to the asset.
     */
    public final List<FormOutput> readOnlyFormsOutput() {
        return readOnlyFormsOutput;
    }

    /**
     * <p>
     * The revision of the asset.
     * </p>
     * 
     * @return The revision of the asset.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The ID of the asset type.
     * </p>
     * 
     * @return The ID of the asset type.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The revision of the asset type.
     * </p>
     * 
     * @return The revision of the asset type.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsOutput() ? formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(listing());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadOnlyFormsOutput() ? readOnlyFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetResponse)) {
            return false;
        }
        GetAssetResponse other = (GetAssetResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(externalIdentifier(), other.externalIdentifier())
                && Objects.equals(firstRevisionCreatedAt(), other.firstRevisionCreatedAt())
                && Objects.equals(firstRevisionCreatedBy(), other.firstRevisionCreatedBy())
                && hasFormsOutput() == other.hasFormsOutput() && Objects.equals(formsOutput(), other.formsOutput())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(id(), other.id()) && Objects.equals(listing(), other.listing())
                && Objects.equals(name(), other.name()) && Objects.equals(owningProjectId(), other.owningProjectId())
                && hasReadOnlyFormsOutput() == other.hasReadOnlyFormsOutput()
                && Objects.equals(readOnlyFormsOutput(), other.readOnlyFormsOutput())
                && Objects.equals(revision(), other.revision()) && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssetResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("ExternalIdentifier", externalIdentifier() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstRevisionCreatedAt", firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", firstRevisionCreatedBy())
                .add("FormsOutput", hasFormsOutput() ? formsOutput() : null)
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id()).add("Listing", listing())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", owningProjectId())
                .add("ReadOnlyFormsOutput", hasReadOnlyFormsOutput() ? readOnlyFormsOutput() : null).add("Revision", revision())
                .add("TypeIdentifier", typeIdentifier()).add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "externalIdentifier":
            return Optional.ofNullable(clazz.cast(externalIdentifier()));
        case "firstRevisionCreatedAt":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedAt()));
        case "firstRevisionCreatedBy":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedBy()));
        case "formsOutput":
            return Optional.ofNullable(clazz.cast(formsOutput()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "listing":
            return Optional.ofNullable(clazz.cast(listing()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "readOnlyFormsOutput":
            return Optional.ofNullable(clazz.cast(readOnlyFormsOutput()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetResponse, T> g) {
        return obj -> g.apply((GetAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAssetResponse> {
        /**
         * <p>
         * The timestamp of when the asset was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the asset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the asset.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the Amazon DataZone asset.
         * </p>
         * 
         * @param description
         *        The description of the Amazon DataZone asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain to which the asset belongs.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain to which the asset belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p/>
         * 
         * @param externalIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIdentifier(String externalIdentifier);

        /**
         * <p>
         * The timestamp of when the first revision of the asset was created.
         * </p>
         * 
         * @param firstRevisionCreatedAt
         *        The timestamp of when the first revision of the asset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt);

        /**
         * <p>
         * The Amazon DataZone user who created the first revision of the asset.
         * </p>
         * 
         * @param firstRevisionCreatedBy
         *        The Amazon DataZone user who created the first revision of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedBy(String firstRevisionCreatedBy);

        /**
         * <p>
         * The metadata forms attached to the asset.
         * </p>
         * 
         * @param formsOutput
         *        The metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(Collection<FormOutput> formsOutput);

        /**
         * <p>
         * The metadata forms attached to the asset.
         * </p>
         * 
         * @param formsOutput
         *        The metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(FormOutput... formsOutput);

        /**
         * <p>
         * The metadata forms attached to the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #formsOutput(List<FormOutput>)}.
         * 
         * @param formsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formsOutput(java.util.Collection<FormOutput>)
         */
        Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput);

        /**
         * <p>
         * The business glossary terms attached to the asset.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The business glossary terms attached to the asset.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param id
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p/>
         * 
         * @param listing
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listing(AssetListingDetails listing);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link AssetListingDetails.Builder} avoiding the
         * need to create one manually via {@link AssetListingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetListingDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #listing(AssetListingDetails)}.
         * 
         * @param listing
         *        a consumer that will call methods on {@link AssetListingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listing(AssetListingDetails)
         */
        default Builder listing(Consumer<AssetListingDetails.Builder> listing) {
            return listing(AssetListingDetails.builder().applyMutation(listing).build());
        }

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param name
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project that owns the asset.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the project that owns the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The read-only metadata forms attached to the asset.
         * </p>
         * 
         * @param readOnlyFormsOutput
         *        The read-only metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput);

        /**
         * <p>
         * The read-only metadata forms attached to the asset.
         * </p>
         * 
         * @param readOnlyFormsOutput
         *        The read-only metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFormsOutput(FormOutput... readOnlyFormsOutput);

        /**
         * <p>
         * The read-only metadata forms attached to the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #readOnlyFormsOutput(List<FormOutput>)}.
         * 
         * @param readOnlyFormsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readOnlyFormsOutput(java.util.Collection<FormOutput>)
         */
        Builder readOnlyFormsOutput(Consumer<FormOutput.Builder>... readOnlyFormsOutput);

        /**
         * <p>
         * The revision of the asset.
         * </p>
         * 
         * @param revision
         *        The revision of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The ID of the asset type.
         * </p>
         * 
         * @param typeIdentifier
         *        The ID of the asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The revision of the asset type.
         * </p>
         * 
         * @param typeRevision
         *        The revision of the asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String externalIdentifier;

        private Instant firstRevisionCreatedAt;

        private String firstRevisionCreatedBy;

        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private AssetListingDetails listing;

        private String name;

        private String owningProjectId;

        private List<FormOutput> readOnlyFormsOutput = DefaultSdkAutoConstructList.getInstance();

        private String revision;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            externalIdentifier(model.externalIdentifier);
            firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            formsOutput(model.formsOutput);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            listing(model.listing);
            name(model.name);
            owningProjectId(model.owningProjectId);
            readOnlyFormsOutput(model.readOnlyFormsOutput);
            revision(model.revision);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getExternalIdentifier() {
            return externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput... formsOutput) {
            formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput) {
            formsOutput(Stream.of(formsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AssetListingDetails.Builder getListing() {
            return listing != null ? listing.toBuilder() : null;
        }

        public final void setListing(AssetListingDetails.BuilderImpl listing) {
            this.listing = listing != null ? listing.build() : null;
        }

        @Override
        public final Builder listing(AssetListingDetails listing) {
            this.listing = listing;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final List<FormOutput.Builder> getReadOnlyFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.readOnlyFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFormsOutput(Collection<FormOutput.BuilderImpl> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copyFromBuilder(readOnlyFormsOutput);
        }

        @Override
        public final Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copy(readOnlyFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(FormOutput... readOnlyFormsOutput) {
            readOnlyFormsOutput(Arrays.asList(readOnlyFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(Consumer<FormOutput.Builder>... readOnlyFormsOutput) {
            readOnlyFormsOutput(Stream.of(readOnlyFormsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public GetAssetResponse build() {
            return new GetAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
