/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurable action of a Amazon DataZone environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurableEnvironmentAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurableEnvironmentAction.Builder, ConfigurableEnvironmentAction> {
    private static final SdkField<String> AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("auth")
            .getter(getter(ConfigurableEnvironmentAction::authAsString)).setter(setter(Builder::auth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auth").build()).build();

    private static final SdkField<List<ConfigurableActionParameter>> PARAMETERS_FIELD = SdkField
            .<List<ConfigurableActionParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(ConfigurableEnvironmentAction::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurableActionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurableActionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ConfigurableEnvironmentAction::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_FIELD, PARAMETERS_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String auth;

    private final List<ConfigurableActionParameter> parameters;

    private final String type;

    private ConfigurableEnvironmentAction(BuilderImpl builder) {
        this.auth = builder.auth;
        this.parameters = builder.parameters;
        this.type = builder.type;
    }

    /**
     * <p>
     * The authentication type of a configurable action of a Amazon DataZone environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auth} will return
     * {@link ConfigurableActionTypeAuthorization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authAsString}.
     * </p>
     * 
     * @return The authentication type of a configurable action of a Amazon DataZone environment.
     * @see ConfigurableActionTypeAuthorization
     */
    public final ConfigurableActionTypeAuthorization auth() {
        return ConfigurableActionTypeAuthorization.fromValue(auth);
    }

    /**
     * <p>
     * The authentication type of a configurable action of a Amazon DataZone environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auth} will return
     * {@link ConfigurableActionTypeAuthorization#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authAsString}.
     * </p>
     * 
     * @return The authentication type of a configurable action of a Amazon DataZone environment.
     * @see ConfigurableActionTypeAuthorization
     */
    public final String authAsString() {
        return auth;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters of a configurable action in a Amazon DataZone environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters of a configurable action in a Amazon DataZone environment.
     */
    public final List<ConfigurableActionParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of a configurable action in a Amazon DataZone environment.
     * </p>
     * 
     * @return The type of a configurable action in a Amazon DataZone environment.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableEnvironmentAction)) {
            return false;
        }
        ConfigurableEnvironmentAction other = (ConfigurableEnvironmentAction) obj;
        return Objects.equals(authAsString(), other.authAsString()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurableEnvironmentAction").add("Auth", authAsString())
                .add("Parameters", hasParameters() ? parameters() : null).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auth":
            return Optional.ofNullable(clazz.cast(authAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableEnvironmentAction, T> g) {
        return obj -> g.apply((ConfigurableEnvironmentAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurableEnvironmentAction> {
        /**
         * <p>
         * The authentication type of a configurable action of a Amazon DataZone environment.
         * </p>
         * 
         * @param auth
         *        The authentication type of a configurable action of a Amazon DataZone environment.
         * @see ConfigurableActionTypeAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurableActionTypeAuthorization
         */
        Builder auth(String auth);

        /**
         * <p>
         * The authentication type of a configurable action of a Amazon DataZone environment.
         * </p>
         * 
         * @param auth
         *        The authentication type of a configurable action of a Amazon DataZone environment.
         * @see ConfigurableActionTypeAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurableActionTypeAuthorization
         */
        Builder auth(ConfigurableActionTypeAuthorization auth);

        /**
         * <p>
         * The parameters of a configurable action in a Amazon DataZone environment.
         * </p>
         * 
         * @param parameters
         *        The parameters of a configurable action in a Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ConfigurableActionParameter> parameters);

        /**
         * <p>
         * The parameters of a configurable action in a Amazon DataZone environment.
         * </p>
         * 
         * @param parameters
         *        The parameters of a configurable action in a Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ConfigurableActionParameter... parameters);

        /**
         * <p>
         * The parameters of a configurable action in a Amazon DataZone environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableActionParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableActionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableActionParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<ConfigurableActionParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ConfigurableActionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<ConfigurableActionParameter>)
         */
        Builder parameters(Consumer<ConfigurableActionParameter.Builder>... parameters);

        /**
         * <p>
         * The type of a configurable action in a Amazon DataZone environment.
         * </p>
         * 
         * @param type
         *        The type of a configurable action in a Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String auth;

        private List<ConfigurableActionParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableEnvironmentAction model) {
            auth(model.auth);
            parameters(model.parameters);
            type(model.type);
        }

        public final String getAuth() {
            return auth;
        }

        public final void setAuth(String auth) {
            this.auth = auth;
        }

        @Override
        public final Builder auth(String auth) {
            this.auth = auth;
            return this;
        }

        @Override
        public final Builder auth(ConfigurableActionTypeAuthorization auth) {
            this.auth(auth == null ? null : auth.toString());
            return this;
        }

        public final List<ConfigurableActionParameter.Builder> getParameters() {
            List<ConfigurableActionParameter.Builder> result = ConfigurableActionParameterListCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ConfigurableActionParameter.BuilderImpl> parameters) {
            this.parameters = ConfigurableActionParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ConfigurableActionParameter> parameters) {
            this.parameters = ConfigurableActionParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ConfigurableActionParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ConfigurableActionParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ConfigurableActionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public ConfigurableEnvironmentAction build() {
            return new ConfigurableEnvironmentAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
