/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRequest extends DataZoneRequest implements ToCopyableBuilder<SearchRequest.Builder, SearchRequest> {
    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalAttributes")
            .getter(getter(SearchRequest::additionalAttributesAsStrings))
            .setter(setter(Builder::additionalAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(SearchRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<FilterClause> FILTERS_FIELD = SdkField.<FilterClause> builder(MarshallingType.SDK_POJO)
            .memberName("filters").getter(getter(SearchRequest::filters)).setter(setter(Builder::filters))
            .constructor(FilterClause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(SearchRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final SdkField<List<SearchInItem>> SEARCH_IN_FIELD = SdkField
            .<List<SearchInItem>> builder(MarshallingType.LIST)
            .memberName("searchIn")
            .getter(getter(SearchRequest::searchIn))
            .setter(setter(Builder::searchIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchIn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchInItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchInItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEARCH_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchScope").getter(getter(SearchRequest::searchScopeAsString)).setter(setter(Builder::searchScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchScope").build()).build();

    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchText").getter(getter(SearchRequest::searchText)).setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()).build();

    private static final SdkField<SearchSort> SORT_FIELD = SdkField.<SearchSort> builder(MarshallingType.SDK_POJO)
            .memberName("sort").getter(getter(SearchRequest::sort)).setter(setter(Builder::sort))
            .constructor(SearchSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD,
            DOMAIN_IDENTIFIER_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD,
            SEARCH_IN_FIELD, SEARCH_SCOPE_FIELD, SEARCH_TEXT_FIELD, SORT_FIELD));

    private final List<String> additionalAttributes;

    private final String domainIdentifier;

    private final FilterClause filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String owningProjectIdentifier;

    private final List<SearchInItem> searchIn;

    private final String searchScope;

    private final String searchText;

    private final SearchSort sort;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.additionalAttributes = builder.additionalAttributes;
        this.domainIdentifier = builder.domainIdentifier;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.searchIn = builder.searchIn;
        this.searchScope = builder.searchScope;
        this.searchText = builder.searchText;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * Specifies additional attributes for the <code>Search</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return Specifies additional attributes for the <code>Search</code> action.
     */
    public final List<SearchOutputAdditionalAttribute> additionalAttributes() {
        return SearchOutputAdditionalAttributesCopier.copyStringToEnum(additionalAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies additional attributes for the <code>Search</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return Specifies additional attributes for the <code>Search</code> action.
     */
    public final List<String> additionalAttributesAsStrings() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies the search filters.
     * </p>
     * 
     * @return Specifies the search filters.
     */
    public final FilterClause filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call to <code>Search</code>. When the number of results to be
     * listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value
     * that you can use in a subsequent call to <code>Search</code> to list the next set of results.
     * </p>
     * 
     * @return The maximum number of results to return in a single call to <code>Search</code>. When the number of
     *         results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     *         <code>NextToken</code> value that you can use in a subsequent call to <code>Search</code> to list the
     *         next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>Search</code> to list the next set of results.
     * </p>
     * 
     * @return When the number of results is greater than the default value for the <code>MaxResults</code> parameter,
     *         or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results,
     *         the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>Search</code> to list the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the owning project specified for the search.
     * </p>
     * 
     * @return The identifier of the owning project specified for the search.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchIn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSearchIn() {
        return searchIn != null && !(searchIn instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchIn} method.
     * </p>
     * 
     * @return
     */
    public final List<SearchInItem> searchIn() {
        return searchIn;
    }

    /**
     * <p>
     * The scope of the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchScope} will
     * return {@link InventorySearchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #searchScopeAsString}.
     * </p>
     * 
     * @return The scope of the search.
     * @see InventorySearchScope
     */
    public final InventorySearchScope searchScope() {
        return InventorySearchScope.fromValue(searchScope);
    }

    /**
     * <p>
     * The scope of the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchScope} will
     * return {@link InventorySearchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #searchScopeAsString}.
     * </p>
     * 
     * @return The scope of the search.
     * @see InventorySearchScope
     */
    public final String searchScopeAsString() {
        return searchScope;
    }

    /**
     * <p>
     * Specifies the text for which to search.
     * </p>
     * 
     * @return Specifies the text for which to search.
     */
    public final String searchText() {
        return searchText;
    }

    /**
     * <p>
     * Specifies the way in which the search results are to be sorted.
     * </p>
     * 
     * @return Specifies the way in which the search results are to be sorted.
     */
    public final SearchSort sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchIn() ? searchIn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(searchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchText());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest) obj;
        return hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributesAsStrings(), other.additionalAttributesAsStrings())
                && Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier())
                && hasSearchIn() == other.hasSearchIn() && Objects.equals(searchIn(), other.searchIn())
                && Objects.equals(searchScopeAsString(), other.searchScopeAsString())
                && Objects.equals(searchText(), other.searchText()) && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRequest")
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributesAsStrings() : null)
                .add("DomainIdentifier", domainIdentifier()).add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OwningProjectIdentifier", owningProjectIdentifier())
                .add("SearchIn", hasSearchIn() ? searchIn() : null).add("SearchScope", searchScopeAsString())
                .add("SearchText", searchText()).add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributesAsStrings()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        case "searchIn":
            return Optional.ofNullable(clazz.cast(searchIn()));
        case "searchScope":
            return Optional.ofNullable(clazz.cast(searchScopeAsString()));
        case "searchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRequest, T> g) {
        return obj -> g.apply((SearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchRequest> {
        /**
         * <p>
         * Specifies additional attributes for the <code>Search</code> action.
         * </p>
         * 
         * @param additionalAttributes
         *        Specifies additional attributes for the <code>Search</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributesWithStrings(Collection<String> additionalAttributes);

        /**
         * <p>
         * Specifies additional attributes for the <code>Search</code> action.
         * </p>
         * 
         * @param additionalAttributes
         *        Specifies additional attributes for the <code>Search</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributesWithStrings(String... additionalAttributes);

        /**
         * <p>
         * Specifies additional attributes for the <code>Search</code> action.
         * </p>
         * 
         * @param additionalAttributes
         *        Specifies additional attributes for the <code>Search</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<SearchOutputAdditionalAttribute> additionalAttributes);

        /**
         * <p>
         * Specifies additional attributes for the <code>Search</code> action.
         * </p>
         * 
         * @param additionalAttributes
         *        Specifies additional attributes for the <code>Search</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(SearchOutputAdditionalAttribute... additionalAttributes);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies the search filters.
         * </p>
         * 
         * @param filters
         *        Specifies the search filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(FilterClause filters);

        /**
         * <p>
         * Specifies the search filters.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterClause.Builder} avoiding the need
         * to create one manually via {@link FilterClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterClause.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(FilterClause)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link FilterClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(FilterClause)
         */
        default Builder filters(Consumer<FilterClause.Builder> filters) {
            return filters(FilterClause.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call to <code>Search</code>. When the number of results
         * to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>Search</code> to list the next
         * set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call to <code>Search</code>. When the number of
         *        results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         *        <code>NextToken</code> value that you can use in a subsequent call to <code>Search</code> to list the
         *        next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>Search</code> to list the next set of results.
         * </p>
         * 
         * @param nextToken
         *        When the number of results is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of results, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>Search</code> to list the next
         *        set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the owning project specified for the search.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The identifier of the owning project specified for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        /**
         * <p/>
         * 
         * @param searchIn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchIn(Collection<SearchInItem> searchIn);

        /**
         * <p/>
         * 
         * @param searchIn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchIn(SearchInItem... searchIn);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.SearchInItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder#build()} is called immediately and
         * its result is passed to {@link #searchIn(List<SearchInItem>)}.
         * 
         * @param searchIn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SearchInItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchIn(java.util.Collection<SearchInItem>)
         */
        Builder searchIn(Consumer<SearchInItem.Builder>... searchIn);

        /**
         * <p>
         * The scope of the search.
         * </p>
         * 
         * @param searchScope
         *        The scope of the search.
         * @see InventorySearchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventorySearchScope
         */
        Builder searchScope(String searchScope);

        /**
         * <p>
         * The scope of the search.
         * </p>
         * 
         * @param searchScope
         *        The scope of the search.
         * @see InventorySearchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventorySearchScope
         */
        Builder searchScope(InventorySearchScope searchScope);

        /**
         * <p>
         * Specifies the text for which to search.
         * </p>
         * 
         * @param searchText
         *        Specifies the text for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String searchText);

        /**
         * <p>
         * Specifies the way in which the search results are to be sorted.
         * </p>
         * 
         * @param sort
         *        Specifies the way in which the search results are to be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(SearchSort sort);

        /**
         * <p>
         * Specifies the way in which the search results are to be sorted.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchSort.Builder} avoiding the need to
         * create one manually via {@link SearchSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchSort.Builder#build()} is called immediately and its result
         * is passed to {@link #sort(SearchSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link SearchSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(SearchSort)
         */
        default Builder sort(Consumer<SearchSort.Builder> sort) {
            return sort(SearchSort.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<String> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private String domainIdentifier;

        private FilterClause filters;

        private Integer maxResults;

        private String nextToken;

        private String owningProjectIdentifier;

        private List<SearchInItem> searchIn = DefaultSdkAutoConstructList.getInstance();

        private String searchScope;

        private String searchText;

        private SearchSort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            super(model);
            additionalAttributesWithStrings(model.additionalAttributes);
            domainIdentifier(model.domainIdentifier);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            owningProjectIdentifier(model.owningProjectIdentifier);
            searchIn(model.searchIn);
            searchScope(model.searchScope);
            searchText(model.searchText);
            sort(model.sort);
        }

        public final Collection<String> getAdditionalAttributes() {
            if (additionalAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalAttributes;
        }

        public final void setAdditionalAttributes(Collection<String> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copy(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributesWithStrings(Collection<String> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributesWithStrings(String... additionalAttributes) {
            additionalAttributesWithStrings(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        public final Builder additionalAttributes(Collection<SearchOutputAdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copyEnumToString(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(SearchOutputAdditionalAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FilterClause.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(FilterClause.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(FilterClause filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final List<SearchInItem.Builder> getSearchIn() {
            List<SearchInItem.Builder> result = SearchInListCopier.copyToBuilder(this.searchIn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchIn(Collection<SearchInItem.BuilderImpl> searchIn) {
            this.searchIn = SearchInListCopier.copyFromBuilder(searchIn);
        }

        @Override
        public final Builder searchIn(Collection<SearchInItem> searchIn) {
            this.searchIn = SearchInListCopier.copy(searchIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(SearchInItem... searchIn) {
            searchIn(Arrays.asList(searchIn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(Consumer<SearchInItem.Builder>... searchIn) {
            searchIn(Stream.of(searchIn).map(c -> SearchInItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSearchScope() {
            return searchScope;
        }

        public final void setSearchScope(String searchScope) {
            this.searchScope = searchScope;
        }

        @Override
        public final Builder searchScope(String searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        @Override
        public final Builder searchScope(InventorySearchScope searchScope) {
            this.searchScope(searchScope == null ? null : searchScope.toString());
            return this;
        }

        public final String getSearchText() {
            return searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final SearchSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(SearchSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SearchSort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
