/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An asset published in an Amazon DataZone catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetListing implements SdkPojo, Serializable, ToCopyableBuilder<AssetListing.Builder, AssetListing> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(AssetListing::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetRevision").getter(getter(AssetListing::assetRevision)).setter(setter(Builder::assetRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()).build();

    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetType").getter(getter(AssetListing::assetType)).setter(setter(Builder::assetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssetListing::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> FORMS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("forms")
            .getter(getter(AssetListing::forms)).setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(AssetListing::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(AssetListing::owningProjectId)).setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_REVISION_FIELD, ASSET_TYPE_FIELD, CREATED_AT_FIELD,
                    FORMS_FIELD, GLOSSARY_TERMS_FIELD, OWNING_PROJECT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String assetRevision;

    private final String assetType;

    private final Instant createdAt;

    private final String forms;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private final String owningProjectId;

    private AssetListing(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
        this.owningProjectId = builder.owningProjectId;
    }

    /**
     * <p>
     * The identifier of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The identifier of an asset published in an Amazon DataZone catalog.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The revision of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The revision of an asset published in an Amazon DataZone catalog.
     */
    public final String assetRevision() {
        return assetRevision;
    }

    /**
     * <p>
     * The type of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The type of an asset published in an Amazon DataZone catalog.
     */
    public final String assetType() {
        return assetType;
    }

    /**
     * <p>
     * The timestamp of when an asset published in an Amazon DataZone catalog was created.
     * </p>
     * 
     * @return The timestamp of when an asset published in an Amazon DataZone catalog was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The metadata forms attached to an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The metadata forms attached to an asset published in an Amazon DataZone catalog.
     */
    public final String forms() {
        return forms;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms attached to an asset published in an Amazon DataZone catalog.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms attached to an asset published in an Amazon DataZone catalog.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The identifier of the project where an asset published in an Amazon DataZone catalog exists.
     * </p>
     * 
     * @return The identifier of the project where an asset published in an Amazon DataZone catalog exists.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(assetType());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(forms());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListing)) {
            return false;
        }
        AssetListing other = (AssetListing) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetRevision(), other.assetRevision())
                && Objects.equals(assetType(), other.assetType()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(forms(), other.forms()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(owningProjectId(), other.owningProjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetListing").add("AssetId", assetId()).add("AssetRevision", assetRevision())
                .add("AssetType", assetType()).add("CreatedAt", createdAt()).add("Forms", forms())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("OwningProjectId", owningProjectId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetRevision":
            return Optional.ofNullable(clazz.cast(assetRevision()));
        case "assetType":
            return Optional.ofNullable(clazz.cast(assetType()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetListing, T> g) {
        return obj -> g.apply((AssetListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetListing> {
        /**
         * <p>
         * The identifier of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param assetId
         *        The identifier of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The revision of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param assetRevision
         *        The revision of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetRevision(String assetRevision);

        /**
         * <p>
         * The type of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param assetType
         *        The type of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetType(String assetType);

        /**
         * <p>
         * The timestamp of when an asset published in an Amazon DataZone catalog was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when an asset published in an Amazon DataZone catalog was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The metadata forms attached to an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param forms
         *        The metadata forms attached to an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(String forms);

        /**
         * <p>
         * The glossary terms attached to an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to an asset published in an Amazon DataZone catalog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);

        /**
         * <p>
         * The identifier of the project where an asset published in an Amazon DataZone catalog exists.
         * </p>
         * 
         * @param owningProjectId
         *        The identifier of the project where an asset published in an Amazon DataZone catalog exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String assetRevision;

        private String assetType;

        private Instant createdAt;

        private String forms;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListing model) {
            assetId(model.assetId);
            assetRevision(model.assetRevision);
            assetType(model.assetType);
            createdAt(model.createdAt);
            forms(model.forms);
            glossaryTerms(model.glossaryTerms);
            owningProjectId(model.owningProjectId);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final String getAssetType() {
            return assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getForms() {
            return forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        @Override
        public AssetListing build() {
            return new AssetListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
