/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetTypeRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateAssetTypeRequest.Builder, CreateAssetTypeRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssetTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateAssetTypeRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Map<String, FormEntryInput>> FORMS_INPUT_FIELD = SdkField
            .<Map<String, FormEntryInput>> builder(MarshallingType.MAP)
            .memberName("formsInput")
            .getter(getter(CreateAssetTypeRequest::formsInput))
            .setter(setter(Builder::formsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FormEntryInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormEntryInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssetTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(CreateAssetTypeRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD));

    private final String description;

    private final String domainIdentifier;

    private final Map<String, FormEntryInput> formsInput;

    private final String name;

    private final String owningProjectIdentifier;

    private CreateAssetTypeRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.formsInput = builder.formsInput;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
    }

    /**
     * <p>
     * The descripton of the custom asset type.
     * </p>
     * 
     * @return The descripton of the custom asset type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
     * </p>
     * 
     * @return The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsInput property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFormsInput() {
        return formsInput != null && !(formsInput instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata forms that are to be attached to the custom asset type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsInput} method.
     * </p>
     * 
     * @return The metadata forms that are to be attached to the custom asset type.
     */
    public final Map<String, FormEntryInput> formsInput() {
        return formsInput;
    }

    /**
     * <p>
     * The name of the custom asset type.
     * </p>
     * 
     * @return The name of the custom asset type.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project that is to own the custom asset type.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project that is to own the custom asset type.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsInput() ? formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetTypeRequest)) {
            return false;
        }
        CreateAssetTypeRequest other = (CreateAssetTypeRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && hasFormsInput() == other.hasFormsInput() && Objects.equals(formsInput(), other.formsInput())
                && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetTypeRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("FormsInput", hasFormsInput() ? formsInput() : null)
                .add("Name", name()).add("OwningProjectIdentifier", owningProjectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "formsInput":
            return Optional.ofNullable(clazz.cast(formsInput()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetTypeRequest, T> g) {
        return obj -> g.apply((CreateAssetTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetTypeRequest> {
        /**
         * <p>
         * The descripton of the custom asset type.
         * </p>
         * 
         * @param description
         *        The descripton of the custom asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
         * </p>
         * 
         * @param domainIdentifier
         *        The unique identifier of the Amazon DataZone domain where the custom asset type is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The metadata forms that are to be attached to the custom asset type.
         * </p>
         * 
         * @param formsInput
         *        The metadata forms that are to be attached to the custom asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsInput(Map<String, FormEntryInput> formsInput);

        /**
         * <p>
         * The name of the custom asset type.
         * </p>
         * 
         * @param name
         *        The name of the custom asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the Amazon DataZone project that is to own the custom asset type.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The identifier of the Amazon DataZone project that is to own the custom asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private String domainIdentifier;

        private Map<String, FormEntryInput> formsInput = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private String owningProjectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetTypeRequest model) {
            super(model);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            formsInput(model.formsInput);
            name(model.name);
            owningProjectIdentifier(model.owningProjectIdentifier);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Map<String, FormEntryInput.Builder> getFormsInput() {
            Map<String, FormEntryInput.Builder> result = FormsInputMapCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Map<String, FormEntryInput.BuilderImpl> formsInput) {
            this.formsInput = FormsInputMapCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Map<String, FormEntryInput> formsInput) {
            this.formsInput = FormsInputMapCopier.copy(formsInput);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetTypeRequest build() {
            return new CreateAssetTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
