/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentBlueprintConfigurationRequest extends DataZoneRequest implements
        ToCopyableBuilder<GetEnvironmentBlueprintConfigurationRequest.Builder, GetEnvironmentBlueprintConfigurationRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(GetEnvironmentBlueprintConfigurationRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(GetEnvironmentBlueprintConfigurationRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD));

    private final String domainIdentifier;

    private final String environmentBlueprintIdentifier;

    private GetEnvironmentBlueprintConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where this blueprint exists.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where this blueprint exists.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * He ID of the blueprint.
     * </p>
     * 
     * @return He ID of the blueprint.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentBlueprintConfigurationRequest)) {
            return false;
        }
        GetEnvironmentBlueprintConfigurationRequest other = (GetEnvironmentBlueprintConfigurationRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentBlueprintConfigurationRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentBlueprintConfigurationRequest, T> g) {
        return obj -> g.apply((GetEnvironmentBlueprintConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEnvironmentBlueprintConfigurationRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain where this blueprint exists.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where this blueprint exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * He ID of the blueprint.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        He ID of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String environmentBlueprintIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentBlueprintConfigurationRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEnvironmentBlueprintConfigurationRequest build() {
            return new GetEnvironmentBlueprintConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
