/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.AcceptPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.CancelSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetRevisionResponse;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.CreateDomainRequest;
import software.amazon.awssdk.services.datazone.model.CreateDomainResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest;
import software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.CreateProjectRequest;
import software.amazon.awssdk.services.datazone.model.CreateProjectResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.DeleteDomainRequest;
import software.amazon.awssdk.services.datazone.model.DeleteDomainResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.DeleteFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.DeleteListingRequest;
import software.amazon.awssdk.services.datazone.model.DeleteListingResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipResponse;
import software.amazon.awssdk.services.datazone.model.DeleteProjectRequest;
import software.amazon.awssdk.services.datazone.model.DeleteProjectResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetResponse;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetAssetTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.GetDomainRequest;
import software.amazon.awssdk.services.datazone.model.GetDomainResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.GetFormTypeRequest;
import software.amazon.awssdk.services.datazone.model.GetFormTypeResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.GetGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest;
import software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse;
import software.amazon.awssdk.services.datazone.model.GetListingRequest;
import software.amazon.awssdk.services.datazone.model.GetListingResponse;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.GetProjectRequest;
import software.amazon.awssdk.services.datazone.model.GetProjectResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest;
import software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointResponse;
import software.amazon.awssdk.services.datazone.model.GetUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.GetUserProfileResponse;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.datazone.model.ListDomainsRequest;
import software.amazon.awssdk.services.datazone.model.ListDomainsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse;
import software.amazon.awssdk.services.datazone.model.ListNotificationsRequest;
import software.amazon.awssdk.services.datazone.model.ListNotificationsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse;
import software.amazon.awssdk.services.datazone.model.ListProjectsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.datazone.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest;
import software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationResponse;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest;
import software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest;
import software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse;
import software.amazon.awssdk.services.datazone.model.SearchListingsRequest;
import software.amazon.awssdk.services.datazone.model.SearchListingsResponse;
import software.amazon.awssdk.services.datazone.model.SearchRequest;
import software.amazon.awssdk.services.datazone.model.SearchResponse;
import software.amazon.awssdk.services.datazone.model.SearchTypesRequest;
import software.amazon.awssdk.services.datazone.model.SearchTypesResponse;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest;
import software.amazon.awssdk.services.datazone.model.StartDataSourceRunResponse;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunRequest;
import software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunResponse;
import software.amazon.awssdk.services.datazone.model.TagResourceRequest;
import software.amazon.awssdk.services.datazone.model.TagResourceResponse;
import software.amazon.awssdk.services.datazone.model.UntagResourceRequest;
import software.amazon.awssdk.services.datazone.model.UntagResourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.datazone.model.UpdateDomainRequest;
import software.amazon.awssdk.services.datazone.model.UpdateDomainResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.datazone.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermResponse;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateGroupProfileResponse;
import software.amazon.awssdk.services.datazone.model.UpdateProjectRequest;
import software.amazon.awssdk.services.datazone.model.UpdateProjectResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestResponse;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest;
import software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetResponse;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.datazone.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher;
import software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher;
import software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher;

/**
 * Service client for accessing Amazon DataZone asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your
 * data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone
 * simplifies your experience across Amazon Web Services services, including, but not limited to, Amazon Redshift,
 * Amazon Athena, Amazon Web Services Glue, and Amazon Web Services Lake Formation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DataZoneAsyncClient extends AwsClient {
    String SERVICE_NAME = "datazone";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "datazone";

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     *
     * @param acceptPredictionsRequest
     * @return A Java Future containing the result of the AcceptPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptPredictionsResponse> acceptPredictions(AcceptPredictionsRequest acceptPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPredictionsRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptPredictionsRequest#builder()}
     * </p>
     *
     * @param acceptPredictionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptPredictionsResponse> acceptPredictions(
            Consumer<AcceptPredictionsRequest.Builder> acceptPredictionsRequest) {
        return acceptPredictions(AcceptPredictionsRequest.builder().applyMutation(acceptPredictionsRequest).build());
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     * @return A Java Future containing the result of the AcceptSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptSubscriptionRequestResponse> acceptSubscriptionRequest(
            AcceptSubscriptionRequestRequest acceptSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a subscription request to a specific asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param acceptSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AcceptSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.AcceptSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptSubscriptionRequestResponse> acceptSubscriptionRequest(
            Consumer<AcceptSubscriptionRequestRequest.Builder> acceptSubscriptionRequestRequest) {
        return acceptSubscriptionRequest(AcceptSubscriptionRequestRequest.builder()
                .applyMutation(acceptSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     *
     * @param cancelMetadataGenerationRunRequest
     * @return A Java Future containing the result of the CancelMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataGenerationRunResponse> cancelMetadataGenerationRun(
            CancelMetadataGenerationRunRequest cancelMetadataGenerationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the metadata generation run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMetadataGenerationRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param cancelMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelMetadataGenerationRunRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMetadataGenerationRunResponse> cancelMetadataGenerationRun(
            Consumer<CancelMetadataGenerationRunRequest.Builder> cancelMetadataGenerationRunRequest) {
        return cancelMetadataGenerationRun(CancelMetadataGenerationRunRequest.builder()
                .applyMutation(cancelMetadataGenerationRunRequest).build());
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     *
     * @param cancelSubscriptionRequest
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(CancelSubscriptionRequest cancelSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the subscription to the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSubscriptionRequest#builder()}
     * </p>
     *
     * @param cancelSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(
            Consumer<CancelSubscriptionRequest.Builder> cancelSubscriptionRequest) {
        return cancelSubscription(CancelSubscriptionRequest.builder().applyMutation(cancelSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     *
     * @param createAssetRequest
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(CreateAssetRequest createAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset in Amazon DataZone catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest) {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     *
     * @param createAssetRevisionRequest
     * @return A Java Future containing the result of the CreateAssetRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetRevisionResponse> createAssetRevision(
            CreateAssetRevisionRequest createAssetRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a revision of the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRevisionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssetRevisionRequest#builder()}
     * </p>
     *
     * @param createAssetRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssetRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetRevisionResponse> createAssetRevision(
            Consumer<CreateAssetRevisionRequest.Builder> createAssetRevisionRequest) {
        return createAssetRevision(CreateAssetRevisionRequest.builder().applyMutation(createAssetRevisionRequest).build());
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     *
     * @param createAssetTypeRequest
     * @return A Java Future containing the result of the CreateAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetTypeResponse> createAssetType(CreateAssetTypeRequest createAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom asset type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetTypeRequest#builder()}
     * </p>
     *
     * @param createAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetTypeResponse> createAssetType(
            Consumer<CreateAssetTypeRequest.Builder> createAssetTypeRequest) {
        return createAssetType(CreateAssetTypeRequest.builder().applyMutation(createAssetTypeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     *
     * @param createEnvironmentProfileRequest
     * @return A Java Future containing the result of the CreateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentProfileResponse> createEnvironmentProfile(
            CreateEnvironmentProfileRequest createEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone environment profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param createEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentProfileResponse> createEnvironmentProfile(
            Consumer<CreateEnvironmentProfileRequest.Builder> createEnvironmentProfileRequest) {
        return createEnvironmentProfile(CreateEnvironmentProfileRequest.builder().applyMutation(createEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     *
     * @param createFormTypeRequest
     * @return A Java Future containing the result of the CreateFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFormTypeResponse> createFormType(CreateFormTypeRequest createFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a metadata form type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFormTypeRequest#builder()}
     * </p>
     *
     * @param createFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFormTypeResponse> createFormType(Consumer<CreateFormTypeRequest.Builder> createFormTypeRequest) {
        return createFormType(CreateFormTypeRequest.builder().applyMutation(createFormTypeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     *
     * @param createGlossaryRequest
     * @return A Java Future containing the result of the CreateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlossaryResponse> createGlossary(CreateGlossaryRequest createGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone business glossary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGlossaryRequest#builder()}
     * </p>
     *
     * @param createGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlossaryResponse> createGlossary(Consumer<CreateGlossaryRequest.Builder> createGlossaryRequest) {
        return createGlossary(CreateGlossaryRequest.builder().applyMutation(createGlossaryRequest).build());
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     *
     * @param createGlossaryTermRequest
     * @return A Java Future containing the result of the CreateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlossaryTermResponse> createGlossaryTerm(CreateGlossaryTermRequest createGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a business glossary term.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlossaryTermRequest#builder()}
     * </p>
     *
     * @param createGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlossaryTermResponse> createGlossaryTerm(
            Consumer<CreateGlossaryTermRequest.Builder> createGlossaryTermRequest) {
        return createGlossaryTerm(CreateGlossaryTermRequest.builder().applyMutation(createGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     *
     * @param createGroupProfileRequest
     * @return A Java Future containing the result of the CreateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupProfileResponse> createGroupProfile(CreateGroupProfileRequest createGroupProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupProfileRequest#builder()}
     * </p>
     *
     * @param createGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupProfileResponse> createGroupProfile(
            Consumer<CreateGroupProfileRequest.Builder> createGroupProfileRequest) {
        return createGroupProfile(CreateGroupProfileRequest.builder().applyMutation(createGroupProfileRequest).build());
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     *
     * @param createListingChangeSetRequest
     * @return A Java Future containing the result of the CreateListingChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListingChangeSetResponse> createListingChangeSet(
            CreateListingChangeSetRequest createListingChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListingChangeSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateListingChangeSetRequest#builder()}
     * </p>
     *
     * @param createListingChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateListingChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateListingChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListingChangeSetResponse> createListingChangeSet(
            Consumer<CreateListingChangeSetRequest.Builder> createListingChangeSetRequest) {
        return createListingChangeSet(CreateListingChangeSetRequest.builder().applyMutation(createListingChangeSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon DataZone project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     *
     * @param createProjectMembershipRequest
     * @return A Java Future containing the result of the CreateProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProjectMembershipResponse> createProjectMembership(
            CreateProjectMembershipRequest createProjectMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProjectMembershipRequest#builder()}
     * </p>
     *
     * @param createProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProjectMembershipResponse> createProjectMembership(
            Consumer<CreateProjectMembershipRequest.Builder> createProjectMembershipRequest) {
        return createProjectMembership(CreateProjectMembershipRequest.builder().applyMutation(createProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionGrantRequest
     * @return A Java Future containing the result of the CreateSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionGrantResponse> createSubscriptionGrant(
            CreateSubscriptionGrantRequest createSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subsscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param createSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionGrantResponse> createSubscriptionGrant(
            Consumer<CreateSubscriptionGrantRequest.Builder> createSubscriptionGrantRequest) {
        return createSubscriptionGrant(CreateSubscriptionGrantRequest.builder().applyMutation(createSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionRequestRequest
     * @return A Java Future containing the result of the CreateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionRequestResponse> createSubscriptionRequest(
            CreateSubscriptionRequestRequest createSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionRequestResponse> createSubscriptionRequest(
            Consumer<CreateSubscriptionRequestRequest.Builder> createSubscriptionRequestRequest) {
        return createSubscriptionRequest(CreateSubscriptionRequestRequest.builder()
                .applyMutation(createSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     *
     * @param createSubscriptionTargetRequest
     * @return A Java Future containing the result of the CreateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionTargetResponse> createSubscriptionTarget(
            CreateSubscriptionTargetRequest createSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param createSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionTargetResponse> createSubscriptionTarget(
            Consumer<CreateSubscriptionTargetRequest.Builder> createSubscriptionTargetRequest) {
        return createSubscriptionTarget(CreateSubscriptionTargetRequest.builder().applyMutation(createSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserProfileRequest#builder()}
     * </p>
     *
     * @param createUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(
            Consumer<CreateUserProfileRequest.Builder> createUserProfileRequest) {
        return createUserProfile(CreateUserProfileRequest.builder().applyMutation(createUserProfileRequest).build());
    }

    /**
     * <p>
     * Delets an asset in Amazon DataZone.
     * </p>
     *
     * @param deleteAssetRequest
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(DeleteAssetRequest deleteAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delets an asset in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest) {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     *
     * @param deleteAssetTypeRequest
     * @return A Java Future containing the result of the DeleteAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetTypeResponse> deleteAssetType(DeleteAssetTypeRequest deleteAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetTypeRequest#builder()}
     * </p>
     *
     * @param deleteAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetTypeResponse> deleteAssetType(
            Consumer<DeleteAssetTypeRequest.Builder> deleteAssetTypeRequest) {
        return deleteAssetType(DeleteAssetTypeRequest.builder().applyMutation(deleteAssetTypeRequest).build());
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprintConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintConfigurationResponse> deleteEnvironmentBlueprintConfiguration(
            DeleteEnvironmentBlueprintConfigurationRequest deleteEnvironmentBlueprintConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteEnvironmentBlueprintConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentBlueprintConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentBlueprintConfigurationResponse> deleteEnvironmentBlueprintConfiguration(
            Consumer<DeleteEnvironmentBlueprintConfigurationRequest.Builder> deleteEnvironmentBlueprintConfigurationRequest) {
        return deleteEnvironmentBlueprintConfiguration(DeleteEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(deleteEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     * @return A Java Future containing the result of the DeleteEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentProfileResponse> deleteEnvironmentProfile(
            DeleteEnvironmentProfileRequest deleteEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentProfileResponse> deleteEnvironmentProfile(
            Consumer<DeleteEnvironmentProfileRequest.Builder> deleteEnvironmentProfileRequest) {
        return deleteEnvironmentProfile(DeleteEnvironmentProfileRequest.builder().applyMutation(deleteEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Delets and metadata form type in Amazon DataZone.
     * </p>
     *
     * @param deleteFormTypeRequest
     * @return A Java Future containing the result of the DeleteFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFormTypeResponse> deleteFormType(DeleteFormTypeRequest deleteFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delets and metadata form type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFormTypeRequest#builder()}
     * </p>
     *
     * @param deleteFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFormTypeResponse> deleteFormType(Consumer<DeleteFormTypeRequest.Builder> deleteFormTypeRequest) {
        return deleteFormType(DeleteFormTypeRequest.builder().applyMutation(deleteFormTypeRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     *
     * @param deleteGlossaryRequest
     * @return A Java Future containing the result of the DeleteGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryResponse> deleteGlossary(DeleteGlossaryRequest deleteGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGlossaryRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryResponse> deleteGlossary(Consumer<DeleteGlossaryRequest.Builder> deleteGlossaryRequest) {
        return deleteGlossary(DeleteGlossaryRequest.builder().applyMutation(deleteGlossaryRequest).build());
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     *
     * @param deleteGlossaryTermRequest
     * @return A Java Future containing the result of the DeleteGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryTermResponse> deleteGlossaryTerm(DeleteGlossaryTermRequest deleteGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a business glossary term in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlossaryTermRequest#builder()}
     * </p>
     *
     * @param deleteGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGlossaryTermResponse> deleteGlossaryTerm(
            Consumer<DeleteGlossaryTermRequest.Builder> deleteGlossaryTermRequest) {
        return deleteGlossaryTerm(DeleteGlossaryTermRequest.builder().applyMutation(deleteGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     *
     * @param deleteListingRequest
     * @return A Java Future containing the result of the DeleteListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteListingResponse> deleteListing(DeleteListingRequest deleteListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a listing (a record of an asset at a given time).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListingRequest#builder()}
     * </p>
     *
     * @param deleteListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteListingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteListingResponse> deleteListing(Consumer<DeleteListingRequest.Builder> deleteListingRequest) {
        return deleteListing(DeleteListingRequest.builder().applyMutation(deleteListingRequest).build());
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     *
     * @param deleteProjectMembershipRequest
     * @return A Java Future containing the result of the DeleteProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProjectMembershipResponse> deleteProjectMembership(
            DeleteProjectMembershipRequest deleteProjectMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes project membership in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProjectMembershipRequest#builder()}
     * </p>
     *
     * @param deleteProjectMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProjectMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteProjectMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProjectMembershipResponse> deleteProjectMembership(
            Consumer<DeleteProjectMembershipRequest.Builder> deleteProjectMembershipRequest) {
        return deleteProjectMembership(DeleteProjectMembershipRequest.builder().applyMutation(deleteProjectMembershipRequest)
                .build());
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     * @return A Java Future containing the result of the DeleteSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionGrantResponse> deleteSubscriptionGrant(
            DeleteSubscriptionGrantRequest deleteSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionGrantRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionGrantResponse> deleteSubscriptionGrant(
            Consumer<DeleteSubscriptionGrantRequest.Builder> deleteSubscriptionGrantRequest) {
        return deleteSubscriptionGrant(DeleteSubscriptionGrantRequest.builder().applyMutation(deleteSubscriptionGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     * @return A Java Future containing the result of the DeleteSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionRequestResponse> deleteSubscriptionRequest(
            DeleteSubscriptionRequestRequest deleteSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionRequestResponse> deleteSubscriptionRequest(
            Consumer<DeleteSubscriptionRequestRequest.Builder> deleteSubscriptionRequestRequest) {
        return deleteSubscriptionRequest(DeleteSubscriptionRequestRequest.builder()
                .applyMutation(deleteSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     * @return A Java Future containing the result of the DeleteSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionTargetResponse> deleteSubscriptionTarget(
            DeleteSubscriptionTargetRequest deleteSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionTargetResponse> deleteSubscriptionTarget(
            Consumer<DeleteSubscriptionTargetRequest.Builder> deleteSubscriptionTargetRequest) {
        return deleteSubscriptionTarget(DeleteSubscriptionTargetRequest.builder().applyMutation(deleteSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     * @return A Java Future containing the result of the DeleteTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesDataPointsResponse> deleteTimeSeriesDataPoints(
            DeleteTimeSeriesDataPointsRequest deleteTimeSeriesDataPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified time series form for the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param deleteTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.DeleteTimeSeriesDataPointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.DeleteTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesDataPointsResponse> deleteTimeSeriesDataPoints(
            Consumer<DeleteTimeSeriesDataPointsRequest.Builder> deleteTimeSeriesDataPointsRequest) {
        return deleteTimeSeriesDataPoints(DeleteTimeSeriesDataPointsRequest.builder()
                .applyMutation(deleteTimeSeriesDataPointsRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     *
     * @param getAssetRequest
     * @return A Java Future containing the result of the GetAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetResponse> getAsset(GetAssetRequest getAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetRequest#builder()}
     * </p>
     *
     * @param getAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetResponse> getAsset(Consumer<GetAssetRequest.Builder> getAssetRequest) {
        return getAsset(GetAssetRequest.builder().applyMutation(getAssetRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     *
     * @param getAssetTypeRequest
     * @return A Java Future containing the result of the GetAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetTypeResponse> getAssetType(GetAssetTypeRequest getAssetTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone asset type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetTypeRequest#builder()}
     * </p>
     *
     * @param getAssetTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetAssetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAssetTypeResponse> getAssetType(Consumer<GetAssetTypeRequest.Builder> getAssetTypeRequest) {
        return getAssetType(GetAssetTypeRequest.builder().applyMutation(getAssetTypeRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     *
     * @param getDataSourceRunRequest
     * @return A Java Future containing the result of the GetDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceRunResponse> getDataSourceRun(GetDataSourceRunRequest getDataSourceRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone data source run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRunRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataSourceRunRequest#builder()}
     * </p>
     *
     * @param getDataSourceRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceRunResponse> getDataSourceRun(
            Consumer<GetDataSourceRunRequest.Builder> getDataSourceRunRequest) {
        return getDataSourceRun(GetDataSourceRunRequest.builder().applyMutation(getDataSourceRunRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     * @return A Java Future containing the result of the GetEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintResponse> getEnvironmentBlueprint(
            GetEnvironmentBlueprintRequest getEnvironmentBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon DataZone blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentBlueprintRequest.Builder} avoiding
     * the need to create one manually via {@link GetEnvironmentBlueprintRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintResponse> getEnvironmentBlueprint(
            Consumer<GetEnvironmentBlueprintRequest.Builder> getEnvironmentBlueprintRequest) {
        return getEnvironmentBlueprint(GetEnvironmentBlueprintRequest.builder().applyMutation(getEnvironmentBlueprintRequest)
                .build());
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     * @return A Java Future containing the result of the GetEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintConfigurationResponse> getEnvironmentBlueprintConfiguration(
            GetEnvironmentBlueprintConfigurationRequest getEnvironmentBlueprintConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the blueprint configuration in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param getEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentBlueprintConfigurationResponse> getEnvironmentBlueprintConfiguration(
            Consumer<GetEnvironmentBlueprintConfigurationRequest.Builder> getEnvironmentBlueprintConfigurationRequest) {
        return getEnvironmentBlueprintConfiguration(GetEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(getEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     *
     * @param getEnvironmentProfileRequest
     * @return A Java Future containing the result of the GetEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentProfileResponse> getEnvironmentProfile(
            GetEnvironmentProfileRequest getEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an evinronment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param getEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnvironmentProfileResponse> getEnvironmentProfile(
            Consumer<GetEnvironmentProfileRequest.Builder> getEnvironmentProfileRequest) {
        return getEnvironmentProfile(GetEnvironmentProfileRequest.builder().applyMutation(getEnvironmentProfileRequest).build());
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     *
     * @param getFormTypeRequest
     * @return A Java Future containing the result of the GetFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormTypeResponse> getFormType(GetFormTypeRequest getFormTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata form type in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFormTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetFormTypeRequest#builder()}
     * </p>
     *
     * @param getFormTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetFormTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFormType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetFormType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFormTypeResponse> getFormType(Consumer<GetFormTypeRequest.Builder> getFormTypeRequest) {
        return getFormType(GetFormTypeRequest.builder().applyMutation(getFormTypeRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     *
     * @param getGlossaryRequest
     * @return A Java Future containing the result of the GetGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryResponse> getGlossary(GetGlossaryRequest getGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetGlossaryRequest#builder()}
     * </p>
     *
     * @param getGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryResponse> getGlossary(Consumer<GetGlossaryRequest.Builder> getGlossaryRequest) {
        return getGlossary(GetGlossaryRequest.builder().applyMutation(getGlossaryRequest).build());
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     *
     * @param getGlossaryTermRequest
     * @return A Java Future containing the result of the GetGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryTermResponse> getGlossaryTerm(GetGlossaryTermRequest getGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a business glossary term in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlossaryTermRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlossaryTermRequest#builder()}
     * </p>
     *
     * @param getGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlossaryTermResponse> getGlossaryTerm(
            Consumer<GetGlossaryTermRequest.Builder> getGlossaryTermRequest) {
        return getGlossaryTerm(GetGlossaryTermRequest.builder().applyMutation(getGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     *
     * @param getGroupProfileRequest
     * @return A Java Future containing the result of the GetGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupProfileResponse> getGroupProfile(GetGroupProfileRequest getGroupProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetGroupProfileRequest#builder()}
     * </p>
     *
     * @param getGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupProfileResponse> getGroupProfile(
            Consumer<GetGroupProfileRequest.Builder> getGroupProfileRequest) {
        return getGroupProfile(GetGroupProfileRequest.builder().applyMutation(getGroupProfileRequest).build());
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     * @return A Java Future containing the result of the GetIamPortalLoginUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIamPortalLoginUrlResponse> getIamPortalLoginUrl(
            GetIamPortalLoginUrlRequest getIamPortalLoginUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data portal URL for the specified Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIamPortalLoginUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetIamPortalLoginUrlRequest#builder()}
     * </p>
     *
     * @param getIamPortalLoginUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIamPortalLoginUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetIamPortalLoginUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIamPortalLoginUrlResponse> getIamPortalLoginUrl(
            Consumer<GetIamPortalLoginUrlRequest.Builder> getIamPortalLoginUrlRequest) {
        return getIamPortalLoginUrl(GetIamPortalLoginUrlRequest.builder().applyMutation(getIamPortalLoginUrlRequest).build());
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time).
     * </p>
     *
     * @param getListingRequest
     * @return A Java Future containing the result of the GetListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListingResponse> getListing(GetListingRequest getListingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a listing (a record of an asset at a given time).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetListingRequest.Builder} avoiding the need to
     * create one manually via {@link GetListingRequest#builder()}
     * </p>
     *
     * @param getListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetListingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetListing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListingResponse> getListing(Consumer<GetListingRequest.Builder> getListingRequest) {
        return getListing(GetListingRequest.builder().applyMutation(getListingRequest).build());
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     *
     * @param getMetadataGenerationRunRequest
     * @return A Java Future containing the result of the GetMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataGenerationRunResponse> getMetadataGenerationRun(
            GetMetadataGenerationRunRequest getMetadataGenerationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a metadata generation run in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataGenerationRunRequest.Builder} avoiding
     * the need to create one manually via {@link GetMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param getMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetMetadataGenerationRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMetadataGenerationRunResponse> getMetadataGenerationRun(
            Consumer<GetMetadataGenerationRunRequest.Builder> getMetadataGenerationRunRequest) {
        return getMetadataGenerationRun(GetMetadataGenerationRunRequest.builder().applyMutation(getMetadataGenerationRunRequest)
                .build());
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     *
     * @param getProjectRequest
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(GetProjectRequest getProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionRequest
     * @return A Java Future containing the result of the GetSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest getSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a subscription in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSubscriptionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSubscriptionResponse> getSubscription(
            Consumer<GetSubscriptionRequest.Builder> getSubscriptionRequest) {
        return getSubscription(GetSubscriptionRequest.builder().applyMutation(getSubscriptionRequest).build());
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionGrantRequest
     * @return A Java Future containing the result of the GetSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionGrantResponse> getSubscriptionGrant(
            GetSubscriptionGrantRequest getSubscriptionGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription grant in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionGrantRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionGrantRequest#builder()}
     * </p>
     *
     * @param getSubscriptionGrantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionGrantResponse> getSubscriptionGrant(
            Consumer<GetSubscriptionGrantRequest.Builder> getSubscriptionGrantRequest) {
        return getSubscriptionGrant(GetSubscriptionGrantRequest.builder().applyMutation(getSubscriptionGrantRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     * @return A Java Future containing the result of the GetSubscriptionRequestDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionRequestDetailsResponse> getSubscriptionRequestDetails(
            GetSubscriptionRequestDetailsRequest getSubscriptionRequestDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified subscription request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionRequestDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSubscriptionRequestDetailsRequest#builder()}
     * </p>
     *
     * @param getSubscriptionRequestDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSubscriptionRequestDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionRequestDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionRequestDetailsResponse> getSubscriptionRequestDetails(
            Consumer<GetSubscriptionRequestDetailsRequest.Builder> getSubscriptionRequestDetailsRequest) {
        return getSubscriptionRequestDetails(GetSubscriptionRequestDetailsRequest.builder()
                .applyMutation(getSubscriptionRequestDetailsRequest).build());
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     *
     * @param getSubscriptionTargetRequest
     * @return A Java Future containing the result of the GetSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionTargetResponse> getSubscriptionTarget(
            GetSubscriptionTargetRequest getSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param getSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionTargetResponse> getSubscriptionTarget(
            Consumer<GetSubscriptionTargetRequest.Builder> getSubscriptionTargetRequest) {
        return getSubscriptionTarget(GetSubscriptionTargetRequest.builder().applyMutation(getSubscriptionTargetRequest).build());
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     * @return A Java Future containing the result of the GetTimeSeriesDataPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTimeSeriesDataPointResponse> getTimeSeriesDataPoint(
            GetTimeSeriesDataPointRequest getTimeSeriesDataPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the existing data point for the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimeSeriesDataPointRequest.Builder} avoiding the
     * need to create one manually via {@link GetTimeSeriesDataPointRequest#builder()}
     * </p>
     *
     * @param getTimeSeriesDataPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetTimeSeriesDataPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTimeSeriesDataPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetTimeSeriesDataPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTimeSeriesDataPointResponse> getTimeSeriesDataPoint(
            Consumer<GetTimeSeriesDataPointRequest.Builder> getTimeSeriesDataPointRequest) {
        return getTimeSeriesDataPoint(GetTimeSeriesDataPointRequest.builder().applyMutation(getTimeSeriesDataPointRequest)
                .build());
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     *
     * @param getUserProfileRequest
     * @return A Java Future containing the result of the GetUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserProfileResponse> getUserProfile(GetUserProfileRequest getUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserProfileRequest#builder()}
     * </p>
     *
     * @param getUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.GetUserProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.GetUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserProfileResponse> getUserProfile(Consumer<GetUserProfileRequest.Builder> getUserProfileRequest) {
        return getUserProfile(GetUserProfileRequest.builder().applyMutation(getUserProfileRequest).build());
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     *
     * @param listAssetRevisionsRequest
     * @return A Java Future containing the result of the ListAssetRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetRevisionsResponse> listAssetRevisions(ListAssetRevisionsRequest listAssetRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the revisions for the asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssetRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetRevisionsResponse> listAssetRevisions(
            Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest) {
        return listAssetRevisions(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsPublisher listAssetRevisionsPaginator(ListAssetRevisionsRequest listAssetRevisionsRequest) {
        return new ListAssetRevisionsPublisher(this, listAssetRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListAssetRevisionsPublisher publisher = client.listAssetRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRevisions(software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRevisionsRequest#builder()}
     * </p>
     *
     * @param listAssetRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListAssetRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetRevisionsPublisher listAssetRevisionsPaginator(
            Consumer<ListAssetRevisionsRequest.Builder> listAssetRevisionsRequest) {
        return listAssetRevisionsPaginator(ListAssetRevisionsRequest.builder().applyMutation(listAssetRevisionsRequest).build());
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return A Java Future containing the result of the ListDataSourceRunActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunActivitiesResponse> listDataSourceRunActivities(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source run activities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDataSourceRunActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunActivitiesResponse> listDataSourceRunActivities(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest) {
        return listDataSourceRunActivities(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesPublisher listDataSourceRunActivitiesPaginator(
            ListDataSourceRunActivitiesRequest listDataSourceRunActivitiesRequest) {
        return new ListDataSourceRunActivitiesPublisher(this, listDataSourceRunActivitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunActivitiesPublisher publisher = client.listDataSourceRunActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRunActivities(software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunActivitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataSourceRunActivitiesRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunActivitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRunActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceRunActivitiesPublisher listDataSourceRunActivitiesPaginator(
            Consumer<ListDataSourceRunActivitiesRequest.Builder> listDataSourceRunActivitiesRequest) {
        return listDataSourceRunActivitiesPaginator(ListDataSourceRunActivitiesRequest.builder()
                .applyMutation(listDataSourceRunActivitiesRequest).build());
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return A Java Future containing the result of the ListDataSourceRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunsResponse> listDataSourceRuns(ListDataSourceRunsRequest listDataSourceRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data source runs in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSourceRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourceRunsResponse> listDataSourceRuns(
            Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest) {
        return listDataSourceRuns(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsPublisher listDataSourceRunsPaginator(ListDataSourceRunsRequest listDataSourceRunsRequest) {
        return new ListDataSourceRunsPublisher(this, listDataSourceRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourceRunsPublisher publisher = client.listDataSourceRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceRuns(software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceRunsRequest#builder()}
     * </p>
     *
     * @param listDataSourceRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSourceRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourceRunsPublisher listDataSourceRunsPaginator(
            Consumer<ListDataSourceRunsRequest.Builder> listDataSourceRunsRequest) {
        return listDataSourceRunsPaginator(ListDataSourceRunsRequest.builder().applyMutation(listDataSourceRunsRequest).build());
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        return new ListDataSourcesPublisher(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, listDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.datazone.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return A Java Future containing the result of the ListEnvironmentBlueprintConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintConfigurationsResponse> listEnvironmentBlueprintConfigurations(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprint configurations for a Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListEnvironmentBlueprintConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintConfigurationsResponse> listEnvironmentBlueprintConfigurations(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest) {
        return listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsPublisher listEnvironmentBlueprintConfigurationsPaginator(
            ListEnvironmentBlueprintConfigurationsRequest listEnvironmentBlueprintConfigurationsRequest) {
        return new ListEnvironmentBlueprintConfigurationsPublisher(this, listEnvironmentBlueprintConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintConfigurationsPublisher publisher = client.listEnvironmentBlueprintConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprintConfigurations(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEnvironmentBlueprintConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListEnvironmentBlueprintConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprintConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintConfigurationsPublisher listEnvironmentBlueprintConfigurationsPaginator(
            Consumer<ListEnvironmentBlueprintConfigurationsRequest.Builder> listEnvironmentBlueprintConfigurationsRequest) {
        return listEnvironmentBlueprintConfigurationsPaginator(ListEnvironmentBlueprintConfigurationsRequest.builder()
                .applyMutation(listEnvironmentBlueprintConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return A Java Future containing the result of the ListEnvironmentBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintsResponse> listEnvironmentBlueprints(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists blueprints in an Amazon DataZone environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListEnvironmentBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentBlueprintsResponse> listEnvironmentBlueprints(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) {
        return listEnvironmentBlueprints(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsPublisher listEnvironmentBlueprintsPaginator(
            ListEnvironmentBlueprintsRequest listEnvironmentBlueprintsRequest) {
        return new ListEnvironmentBlueprintsPublisher(this, listEnvironmentBlueprintsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentBlueprintsPublisher publisher = client.listEnvironmentBlueprintsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentBlueprints(software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentBlueprintsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentBlueprintsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentBlueprintsPublisher listEnvironmentBlueprintsPaginator(
            Consumer<ListEnvironmentBlueprintsRequest.Builder> listEnvironmentBlueprintsRequest) {
        return listEnvironmentBlueprintsPaginator(ListEnvironmentBlueprintsRequest.builder()
                .applyMutation(listEnvironmentBlueprintsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return A Java Future containing the result of the ListEnvironmentProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProfilesResponse> listEnvironmentProfiles(
            ListEnvironmentProfilesRequest listEnvironmentProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environment profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironmentProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnvironmentProfilesResponse> listEnvironmentProfiles(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) {
        return listEnvironmentProfiles(ListEnvironmentProfilesRequest.builder().applyMutation(listEnvironmentProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesPublisher listEnvironmentProfilesPaginator(
            ListEnvironmentProfilesRequest listEnvironmentProfilesRequest) {
        return new ListEnvironmentProfilesPublisher(this, listEnvironmentProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentProfilesPublisher publisher = client.listEnvironmentProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironmentProfiles(software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListEnvironmentProfilesRequest#builder()}
     * </p>
     *
     * @param listEnvironmentProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironmentProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnvironmentProfilesPublisher listEnvironmentProfilesPaginator(
            Consumer<ListEnvironmentProfilesRequest.Builder> listEnvironmentProfilesRequest) {
        return listEnvironmentProfilesPaginator(ListEnvironmentProfilesRequest.builder()
                .applyMutation(listEnvironmentProfilesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        return new ListEnvironmentsPublisher(this, listEnvironmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     * @return A Java Future containing the result of the ListMetadataGenerationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataGenerationRunsResponse> listMetadataGenerationRuns(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata generation runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMetadataGenerationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMetadataGenerationRunsResponse> listMetadataGenerationRuns(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest) {
        return listMetadataGenerationRuns(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsPublisher listMetadataGenerationRunsPaginator(
            ListMetadataGenerationRunsRequest listMetadataGenerationRunsRequest) {
        return new ListMetadataGenerationRunsPublisher(this, listMetadataGenerationRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListMetadataGenerationRunsPublisher publisher = client.listMetadataGenerationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMetadataGenerationRuns(software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMetadataGenerationRunsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMetadataGenerationRunsRequest#builder()}
     * </p>
     *
     * @param listMetadataGenerationRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListMetadataGenerationRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMetadataGenerationRunsPublisher listMetadataGenerationRunsPaginator(
            Consumer<ListMetadataGenerationRunsRequest.Builder> listMetadataGenerationRunsRequest) {
        return listMetadataGenerationRunsPaginator(ListMetadataGenerationRunsRequest.builder()
                .applyMutation(listMetadataGenerationRunsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(ListNotificationsRequest listNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon DataZone notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) {
        return new ListNotificationsPublisher(this, listNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.datazone.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return A Java Future containing the result of the ListProjectMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProjectMembershipsResponse> listProjectMemberships(
            ListProjectMembershipsRequest listProjectMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all members of the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProjectMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProjectMembershipsResponse> listProjectMemberships(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) {
        return listProjectMemberships(ListProjectMembershipsRequest.builder().applyMutation(listProjectMembershipsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsPublisher listProjectMembershipsPaginator(
            ListProjectMembershipsRequest listProjectMembershipsRequest) {
        return new ListProjectMembershipsPublisher(this, listProjectMembershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectMembershipsPublisher publisher = client.listProjectMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectMemberships(software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProjectMembershipsRequest#builder()}
     * </p>
     *
     * @param listProjectMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjectMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectMembershipsPublisher listProjectMembershipsPaginator(
            Consumer<ListProjectMembershipsRequest.Builder> listProjectMembershipsRequest) {
        return listProjectMembershipsPaginator(ListProjectMembershipsRequest.builder()
                .applyMutation(listProjectMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.datazone.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListProjectsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return A Java Future containing the result of the ListSubscriptionGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionGrantsResponse> listSubscriptionGrants(
            ListSubscriptionGrantsRequest listSubscriptionGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscription grants.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptionGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionGrantsResponse> listSubscriptionGrants(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) {
        return listSubscriptionGrants(ListSubscriptionGrantsRequest.builder().applyMutation(listSubscriptionGrantsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsPublisher listSubscriptionGrantsPaginator(
            ListSubscriptionGrantsRequest listSubscriptionGrantsRequest) {
        return new ListSubscriptionGrantsPublisher(this, listSubscriptionGrantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionGrantsPublisher publisher = client.listSubscriptionGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionGrants(software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubscriptionGrantsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionGrantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionGrantsPublisher listSubscriptionGrantsPaginator(
            Consumer<ListSubscriptionGrantsRequest.Builder> listSubscriptionGrantsRequest) {
        return listSubscriptionGrantsPaginator(ListSubscriptionGrantsRequest.builder()
                .applyMutation(listSubscriptionGrantsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return A Java Future containing the result of the ListSubscriptionRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionRequestsResponse> listSubscriptionRequests(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon DataZone subscription requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptionRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionRequestsResponse> listSubscriptionRequests(
            Consumer<ListSubscriptionRequestsRequest.Builder> listSubscriptionRequestsRequest) {
        return listSubscriptionRequests(ListSubscriptionRequestsRequest.builder().applyMutation(listSubscriptionRequestsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsPublisher listSubscriptionRequestsPaginator(
            ListSubscriptionRequestsRequest listSubscriptionRequestsRequest) {
        return new ListSubscriptionRequestsPublisher(this, listSubscriptionRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionRequestsPublisher publisher = client.listSubscriptionRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionRequests(software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionRequestsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionRequestsPublisher listSubscriptionRequestsPaginator(
            Consumer<ListSubscriptionRequestsRequest.Builder> listSubscriptionRequestsRequest) {
        return listSubscriptionRequestsPaginator(ListSubscriptionRequestsRequest.builder()
                .applyMutation(listSubscriptionRequestsRequest).build());
    }

    /**
     * <p>
     * Lists subscription targets in Amazon DataZone.
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     * @return A Java Future containing the result of the ListSubscriptionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionTargetsResponse> listSubscriptionTargets(
            ListSubscriptionTargetsRequest listSubscriptionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscription targets in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionTargetsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptionTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionTargetsResponse> listSubscriptionTargets(
            Consumer<ListSubscriptionTargetsRequest.Builder> listSubscriptionTargetsRequest) {
        return listSubscriptionTargets(ListSubscriptionTargetsRequest.builder().applyMutation(listSubscriptionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher publisher = client.listSubscriptionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher publisher = client.listSubscriptionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsPublisher listSubscriptionTargetsPaginator(
            ListSubscriptionTargetsRequest listSubscriptionTargetsRequest) {
        return new ListSubscriptionTargetsPublisher(this, listSubscriptionTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher publisher = client.listSubscriptionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionTargetsPublisher publisher = client.listSubscriptionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionTargets(software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionTargetsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionTargetsPublisher listSubscriptionTargetsPaginator(
            Consumer<ListSubscriptionTargetsRequest.Builder> listSubscriptionTargetsRequest) {
        return listSubscriptionTargetsPaginator(ListSubscriptionTargetsRequest.builder()
                .applyMutation(listSubscriptionTargetsRequest).build());
    }

    /**
     * <p>
     * Lists subscriptions in Amazon DataZone.
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists subscriptions in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptions(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest) {
        return new ListSubscriptionsPublisher(this, listSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptionsPaginator(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists tags for the specified resource in Amazon DataZone.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for the specified resource in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists time series data points.
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     * @return A Java Future containing the result of the ListTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTimeSeriesDataPointsResponse> listTimeSeriesDataPoints(
            ListTimeSeriesDataPointsRequest listTimeSeriesDataPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists time series data points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTimeSeriesDataPointsResponse> listTimeSeriesDataPoints(
            Consumer<ListTimeSeriesDataPointsRequest.Builder> listTimeSeriesDataPointsRequest) {
        return listTimeSeriesDataPoints(ListTimeSeriesDataPointsRequest.builder().applyMutation(listTimeSeriesDataPointsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher publisher = client.listTimeSeriesDataPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher publisher = client.listTimeSeriesDataPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsPublisher listTimeSeriesDataPointsPaginator(
            ListTimeSeriesDataPointsRequest listTimeSeriesDataPointsRequest) {
        return new ListTimeSeriesDataPointsPublisher(this, listTimeSeriesDataPointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher publisher = client.listTimeSeriesDataPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.ListTimeSeriesDataPointsPublisher publisher = client.listTimeSeriesDataPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeriesDataPoints(software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.ListTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimeSeriesDataPointsPublisher listTimeSeriesDataPointsPaginator(
            Consumer<ListTimeSeriesDataPointsRequest.Builder> listTimeSeriesDataPointsRequest) {
        return listTimeSeriesDataPointsPaginator(ListTimeSeriesDataPointsRequest.builder()
                .applyMutation(listTimeSeriesDataPointsRequest).build());
    }

    /**
     * <p>
     * Posts time series data points to Amazon DataZone for the specified asset.
     * </p>
     *
     * @param postTimeSeriesDataPointsRequest
     * @return A Java Future containing the result of the PostTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.PostTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostTimeSeriesDataPointsResponse> postTimeSeriesDataPoints(
            PostTimeSeriesDataPointsRequest postTimeSeriesDataPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts time series data points to Amazon DataZone for the specified asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostTimeSeriesDataPointsRequest.Builder} avoiding
     * the need to create one manually via {@link PostTimeSeriesDataPointsRequest#builder()}
     * </p>
     *
     * @param postTimeSeriesDataPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.PostTimeSeriesDataPointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PostTimeSeriesDataPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.PostTimeSeriesDataPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostTimeSeriesDataPointsResponse> postTimeSeriesDataPoints(
            Consumer<PostTimeSeriesDataPointsRequest.Builder> postTimeSeriesDataPointsRequest) {
        return postTimeSeriesDataPoints(PostTimeSeriesDataPointsRequest.builder().applyMutation(postTimeSeriesDataPointsRequest)
                .build());
    }

    /**
     * <p>
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     * </p>
     *
     * @param putEnvironmentBlueprintConfigurationRequest
     * @return A Java Future containing the result of the PutEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.PutEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEnvironmentBlueprintConfigurationResponse> putEnvironmentBlueprintConfiguration(
            PutEnvironmentBlueprintConfigurationRequest putEnvironmentBlueprintConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEnvironmentBlueprintConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutEnvironmentBlueprintConfigurationRequest#builder()}
     * </p>
     *
     * @param putEnvironmentBlueprintConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutEnvironmentBlueprintConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.PutEnvironmentBlueprintConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEnvironmentBlueprintConfigurationResponse> putEnvironmentBlueprintConfiguration(
            Consumer<PutEnvironmentBlueprintConfigurationRequest.Builder> putEnvironmentBlueprintConfigurationRequest) {
        return putEnvironmentBlueprintConfiguration(PutEnvironmentBlueprintConfigurationRequest.builder()
                .applyMutation(putEnvironmentBlueprintConfigurationRequest).build());
    }

    /**
     * <p>
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     *
     * @param rejectPredictionsRequest
     * @return A Java Future containing the result of the RejectPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RejectPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectPredictionsResponse> rejectPredictions(RejectPredictionsRequest rejectPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectPredictionsRequest.Builder} avoiding the need
     * to create one manually via {@link RejectPredictionsRequest#builder()}
     * </p>
     *
     * @param rejectPredictionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RejectPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RejectPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectPredictionsResponse> rejectPredictions(
            Consumer<RejectPredictionsRequest.Builder> rejectPredictionsRequest) {
        return rejectPredictions(RejectPredictionsRequest.builder().applyMutation(rejectPredictionsRequest).build());
    }

    /**
     * <p>
     * Rejects the specified subscription request.
     * </p>
     *
     * @param rejectSubscriptionRequestRequest
     * @return A Java Future containing the result of the RejectSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RejectSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectSubscriptionRequestResponse> rejectSubscriptionRequest(
            RejectSubscriptionRequestRequest rejectSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the specified subscription request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link RejectSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param rejectSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RejectSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RejectSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectSubscriptionRequestResponse> rejectSubscriptionRequest(
            Consumer<RejectSubscriptionRequestRequest.Builder> rejectSubscriptionRequestRequest) {
        return rejectSubscriptionRequest(RejectSubscriptionRequestRequest.builder()
                .applyMutation(rejectSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Revokes a specified subscription in Amazon DataZone.
     * </p>
     *
     * @param revokeSubscriptionRequest
     * @return A Java Future containing the result of the RevokeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RevokeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RevokeSubscriptionResponse> revokeSubscription(RevokeSubscriptionRequest revokeSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes a specified subscription in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeSubscriptionRequest#builder()}
     * </p>
     *
     * @param revokeSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RevokeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.RevokeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RevokeSubscriptionResponse> revokeSubscription(
            Consumer<RevokeSubscriptionRequest.Builder> revokeSubscriptionRequest) {
        return revokeSubscription(RevokeSubscriptionRequest.builder().applyMutation(revokeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Searches for assets in Amazon DataZone.
     * </p>
     *
     * @param searchRequest
     * @return A Java Future containing the result of the Search operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResponse> search(SearchRequest searchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for assets in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Search operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResponse> search(Consumer<SearchRequest.Builder> searchRequest) {
        return search(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Searches group profiles in Amazon DataZone.
     * </p>
     *
     * @param searchGroupProfilesRequest
     * @return A Java Future containing the result of the SearchGroupProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchGroupProfilesResponse> searchGroupProfiles(
            SearchGroupProfilesRequest searchGroupProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches group profiles in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGroupProfilesRequest#builder()}
     * </p>
     *
     * @param searchGroupProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchGroupProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchGroupProfilesResponse> searchGroupProfiles(
            Consumer<SearchGroupProfilesRequest.Builder> searchGroupProfilesRequest) {
        return searchGroupProfiles(SearchGroupProfilesRequest.builder().applyMutation(searchGroupProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher publisher = client.searchGroupProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher publisher = client.searchGroupProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchGroupProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesPublisher searchGroupProfilesPaginator(SearchGroupProfilesRequest searchGroupProfilesRequest) {
        return new SearchGroupProfilesPublisher(this, searchGroupProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher publisher = client.searchGroupProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchGroupProfilesPublisher publisher = client.searchGroupProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchGroupProfiles(software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchGroupProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchGroupProfilesRequest#builder()}
     * </p>
     *
     * @param searchGroupProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchGroupProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchGroupProfilesPublisher searchGroupProfilesPaginator(
            Consumer<SearchGroupProfilesRequest.Builder> searchGroupProfilesRequest) {
        return searchGroupProfilesPaginator(SearchGroupProfilesRequest.builder().applyMutation(searchGroupProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Searches listings (records of an asset at a given time) in Amazon DataZone.
     * </p>
     *
     * @param searchListingsRequest
     * @return A Java Future containing the result of the SearchListings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchListingsResponse> searchListings(SearchListingsRequest searchListingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches listings (records of an asset at a given time) in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchListingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchListingsRequest#builder()}
     * </p>
     *
     * @param searchListingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchListingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchListings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchListingsResponse> searchListings(Consumer<SearchListingsRequest.Builder> searchListingsRequest) {
        return searchListings(SearchListingsRequest.builder().applyMutation(searchListingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher publisher = client.searchListingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher publisher = client.searchListingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchListingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchListingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation.</b>
     * </p>
     *
     * @param searchListingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsPublisher searchListingsPaginator(SearchListingsRequest searchListingsRequest) {
        return new SearchListingsPublisher(this, searchListingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher publisher = client.searchListingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchListingsPublisher publisher = client.searchListingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchListingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchListingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchListings(software.amazon.awssdk.services.datazone.model.SearchListingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchListingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchListingsRequest#builder()}
     * </p>
     *
     * @param searchListingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchListingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchListings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchListingsPublisher searchListingsPaginator(Consumer<SearchListingsRequest.Builder> searchListingsRequest) {
        return searchListingsPaginator(SearchListingsRequest.builder().applyMutation(searchListingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchPublisher searchPaginator(SearchRequest searchRequest) {
        return new SearchPublisher(this, searchRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchPublisher publisher = client.searchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.datazone.model.SearchRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchPublisher searchPaginator(Consumer<SearchRequest.Builder> searchRequest) {
        return searchPaginator(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Searches for types in Amazon DataZone.
     * </p>
     *
     * @param searchTypesRequest
     * @return A Java Future containing the result of the SearchTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchTypesResponse> searchTypes(SearchTypesRequest searchTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for types in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTypesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTypesRequest#builder()}
     * </p>
     *
     * @param searchTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchTypesResponse> searchTypes(Consumer<SearchTypesRequest.Builder> searchTypesRequest) {
        return searchTypes(SearchTypesRequest.builder().applyMutation(searchTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher publisher = client.searchTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher publisher = client.searchTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)} operation.</b>
     * </p>
     *
     * @param searchTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesPublisher searchTypesPaginator(SearchTypesRequest searchTypesRequest) {
        return new SearchTypesPublisher(this, searchTypesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher publisher = client.searchTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchTypesPublisher publisher = client.searchTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTypes(software.amazon.awssdk.services.datazone.model.SearchTypesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTypesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTypesRequest#builder()}
     * </p>
     *
     * @param searchTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTypesPublisher searchTypesPaginator(Consumer<SearchTypesRequest.Builder> searchTypesRequest) {
        return searchTypesPaginator(SearchTypesRequest.builder().applyMutation(searchTypesRequest).build());
    }

    /**
     * <p>
     * Searches user profiles in Amazon DataZone.
     * </p>
     *
     * @param searchUserProfilesRequest
     * @return A Java Future containing the result of the SearchUserProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchUserProfilesResponse> searchUserProfiles(SearchUserProfilesRequest searchUserProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches user profiles in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUserProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchUserProfilesRequest#builder()}
     * </p>
     *
     * @param searchUserProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchUserProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchUserProfilesResponse> searchUserProfiles(
            Consumer<SearchUserProfilesRequest.Builder> searchUserProfilesRequest) {
        return searchUserProfiles(SearchUserProfilesRequest.builder().applyMutation(searchUserProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher publisher = client.searchUserProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher publisher = client.searchUserProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchUserProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesPublisher searchUserProfilesPaginator(SearchUserProfilesRequest searchUserProfilesRequest) {
        return new SearchUserProfilesPublisher(this, searchUserProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher publisher = client.searchUserProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.datazone.paginators.SearchUserProfilesPublisher publisher = client.searchUserProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUserProfiles(software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUserProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchUserProfilesRequest#builder()}
     * </p>
     *
     * @param searchUserProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.SearchUserProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUserProfilesPublisher searchUserProfilesPaginator(
            Consumer<SearchUserProfilesRequest.Builder> searchUserProfilesRequest) {
        return searchUserProfilesPaginator(SearchUserProfilesRequest.builder().applyMutation(searchUserProfilesRequest).build());
    }

    /**
     * <p>
     * Start the run of the specified data source in Amazon DataZone.
     * </p>
     *
     * @param startDataSourceRunRequest
     * @return A Java Future containing the result of the StartDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.StartDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDataSourceRunResponse> startDataSourceRun(StartDataSourceRunRequest startDataSourceRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the run of the specified data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceRunRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceRunRequest#builder()}
     * </p>
     *
     * @param startDataSourceRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDataSourceRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.StartDataSourceRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartDataSourceRunResponse> startDataSourceRun(
            Consumer<StartDataSourceRunRequest.Builder> startDataSourceRunRequest) {
        return startDataSourceRun(StartDataSourceRunRequest.builder().applyMutation(startDataSourceRunRequest).build());
    }

    /**
     * <p>
     * Starts the metadata generation run.
     * </p>
     *
     * @param startMetadataGenerationRunRequest
     * @return A Java Future containing the result of the StartMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.StartMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataGenerationRunResponse> startMetadataGenerationRun(
            StartMetadataGenerationRunRequest startMetadataGenerationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the metadata generation run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataGenerationRunRequest.Builder} avoiding
     * the need to create one manually via {@link StartMetadataGenerationRunRequest#builder()}
     * </p>
     *
     * @param startMetadataGenerationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.StartMetadataGenerationRunRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartMetadataGenerationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.StartMetadataGenerationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataGenerationRunResponse> startMetadataGenerationRun(
            Consumer<StartMetadataGenerationRunRequest.Builder> startMetadataGenerationRunRequest) {
        return startMetadataGenerationRun(StartMetadataGenerationRunRequest.builder()
                .applyMutation(startMetadataGenerationRunRequest).build());
    }

    /**
     * <p>
     * Tags a resource in Amazon DataZone.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource in Amazon DataZone.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified data source in Amazon DataZone.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified data source in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates a Amazon DataZone domain.
     * </p>
     *
     * @param updateDomainRequest
     * @return A Java Future containing the result of the UpdateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDomainResponse> updateDomain(UpdateDomainRequest updateDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Amazon DataZone domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDomainRequest#builder()}
     * </p>
     *
     * @param updateDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDomainResponse> updateDomain(Consumer<UpdateDomainRequest.Builder> updateDomainRequest) {
        return updateDomain(UpdateDomainRequest.builder().applyMutation(updateDomainRequest).build());
    }

    /**
     * <p>
     * Updates the specified environment in Amazon DataZone.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified environment in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates the specified environment profile in Amazon DataZone.
     * </p>
     *
     * @param updateEnvironmentProfileRequest
     * @return A Java Future containing the result of the UpdateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentProfileResponse> updateEnvironmentProfile(
            UpdateEnvironmentProfileRequest updateEnvironmentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified environment profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentProfileRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEnvironmentProfileRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnvironmentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateEnvironmentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentProfileResponse> updateEnvironmentProfile(
            Consumer<UpdateEnvironmentProfileRequest.Builder> updateEnvironmentProfileRequest) {
        return updateEnvironmentProfile(UpdateEnvironmentProfileRequest.builder().applyMutation(updateEnvironmentProfileRequest)
                .build());
    }

    /**
     * <p>
     * Updates the business glossary in Amazon DataZone.
     * </p>
     *
     * @param updateGlossaryRequest
     * @return A Java Future containing the result of the UpdateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGlossaryResponse> updateGlossary(UpdateGlossaryRequest updateGlossaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the business glossary in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlossaryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGlossaryRequest#builder()}
     * </p>
     *
     * @param updateGlossaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGlossary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGlossary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGlossaryResponse> updateGlossary(Consumer<UpdateGlossaryRequest.Builder> updateGlossaryRequest) {
        return updateGlossary(UpdateGlossaryRequest.builder().applyMutation(updateGlossaryRequest).build());
    }

    /**
     * <p>
     * Updates a business glossary term in Amazon DataZone.
     * </p>
     *
     * @param updateGlossaryTermRequest
     * @return A Java Future containing the result of the UpdateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlossaryTermResponse> updateGlossaryTerm(UpdateGlossaryTermRequest updateGlossaryTermRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a business glossary term in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlossaryTermRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlossaryTermRequest#builder()}
     * </p>
     *
     * @param updateGlossaryTermRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlossaryTerm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGlossaryTerm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossaryTerm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlossaryTermResponse> updateGlossaryTerm(
            Consumer<UpdateGlossaryTermRequest.Builder> updateGlossaryTermRequest) {
        return updateGlossaryTerm(UpdateGlossaryTermRequest.builder().applyMutation(updateGlossaryTermRequest).build());
    }

    /**
     * <p>
     * Updates the specified group profile in Amazon DataZone.
     * </p>
     *
     * @param updateGroupProfileRequest
     * @return A Java Future containing the result of the UpdateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGroupProfileResponse> updateGroupProfile(UpdateGroupProfileRequest updateGroupProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified group profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGroupProfileRequest#builder()}
     * </p>
     *
     * @param updateGroupProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGroupProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateGroupProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGroupProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGroupProfileResponse> updateGroupProfile(
            Consumer<UpdateGroupProfileRequest.Builder> updateGroupProfileRequest) {
        return updateGroupProfile(UpdateGroupProfileRequest.builder().applyMutation(updateGroupProfileRequest).build());
    }

    /**
     * <p>
     * Updates the specified project in Amazon DataZone.
     * </p>
     *
     * @param updateProjectRequest
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified project in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request has exceeded the specified service quota.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Updates the status of the specified subscription grant status in Amazon DataZone.
     * </p>
     *
     * @param updateSubscriptionGrantStatusRequest
     * @return A Java Future containing the result of the UpdateSubscriptionGrantStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionGrantStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionGrantStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionGrantStatusResponse> updateSubscriptionGrantStatus(
            UpdateSubscriptionGrantStatusRequest updateSubscriptionGrantStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of the specified subscription grant status in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionGrantStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubscriptionGrantStatusRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionGrantStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSubscriptionGrantStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionGrantStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionGrantStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionGrantStatusResponse> updateSubscriptionGrantStatus(
            Consumer<UpdateSubscriptionGrantStatusRequest.Builder> updateSubscriptionGrantStatusRequest) {
        return updateSubscriptionGrantStatus(UpdateSubscriptionGrantStatusRequest.builder()
                .applyMutation(updateSubscriptionGrantStatusRequest).build());
    }

    /**
     * <p>
     * Updates a specified subscription request in Amazon DataZone.
     * </p>
     *
     * @param updateSubscriptionRequestRequest
     * @return A Java Future containing the result of the UpdateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionRequestResponse> updateSubscriptionRequest(
            UpdateSubscriptionRequestRequest updateSubscriptionRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified subscription request in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequestRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSubscriptionRequestRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateSubscriptionRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionRequestResponse> updateSubscriptionRequest(
            Consumer<UpdateSubscriptionRequestRequest.Builder> updateSubscriptionRequestRequest) {
        return updateSubscriptionRequest(UpdateSubscriptionRequestRequest.builder()
                .applyMutation(updateSubscriptionRequestRequest).build());
    }

    /**
     * <p>
     * Updates the specified subscription target in Amazon DataZone.
     * </p>
     *
     * @param updateSubscriptionTargetRequest
     * @return A Java Future containing the result of the UpdateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionTargetResponse> updateSubscriptionTarget(
            UpdateSubscriptionTargetRequest updateSubscriptionTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified subscription target in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionTargetRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSubscriptionTargetRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSubscriptionTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException There is a conflict while performing this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateSubscriptionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionTargetResponse> updateSubscriptionTarget(
            Consumer<UpdateSubscriptionTargetRequest.Builder> updateSubscriptionTargetRequest) {
        return updateSubscriptionTarget(UpdateSubscriptionTargetRequest.builder().applyMutation(updateSubscriptionTargetRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified user profile in Amazon DataZone.
     * </p>
     *
     * @param updateUserProfileRequest
     * @return A Java Future containing the result of the UpdateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateUserProfileResponse> updateUserProfile(UpdateUserProfileRequest updateUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user profile in Amazon DataZone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUserProfileRequest#builder()}
     * </p>
     *
     * @param updateUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed because of an unknown error, exception or failure.</li>
     *         <li>ResourceNotFoundException The specified resource cannot be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the Amazon Web Services
     *         service.</li>
     *         <li>UnauthorizedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DataZoneException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DataZoneAsyncClient.UpdateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateUserProfileResponse> updateUserProfile(
            Consumer<UpdateUserProfileRequest.Builder> updateUserProfileRequest) {
        return updateUserProfile(UpdateUserProfileRequest.builder().applyMutation(updateUserProfileRequest).build());
    }

    @Override
    default DataZoneServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DataZoneAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataZoneAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataZoneAsyncClient}.
     */
    static DataZoneAsyncClientBuilder builder() {
        return new DefaultDataZoneAsyncClientBuilder();
    }
}
