/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptPredictionsRequest extends DataZoneRequest implements
        ToCopyableBuilder<AcceptPredictionsRequest.Builder, AcceptPredictionsRequest> {
    private static final SdkField<List<AcceptChoice>> ACCEPT_CHOICES_FIELD = SdkField
            .<List<AcceptChoice>> builder(MarshallingType.LIST)
            .memberName("acceptChoices")
            .getter(getter(AcceptPredictionsRequest::acceptChoices))
            .setter(setter(Builder::acceptChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AcceptChoice> builder(MarshallingType.SDK_POJO)
                                            .constructor(AcceptChoice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AcceptRule> ACCEPT_RULE_FIELD = SdkField.<AcceptRule> builder(MarshallingType.SDK_POJO)
            .memberName("acceptRule").getter(getter(AcceptPredictionsRequest::acceptRule)).setter(setter(Builder::acceptRule))
            .constructor(AcceptRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptRule").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(AcceptPredictionsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(AcceptPredictionsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(AcceptPredictionsRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(AcceptPredictionsRequest::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_CHOICES_FIELD,
            ACCEPT_RULE_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, REVISION_FIELD));

    private final List<AcceptChoice> acceptChoices;

    private final AcceptRule acceptRule;

    private final String clientToken;

    private final String domainIdentifier;

    private final String identifier;

    private final String revision;

    private AcceptPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptChoices = builder.acceptChoices;
        this.acceptRule = builder.acceptRule;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.revision = builder.revision;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceptChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceptChoices() {
        return acceptChoices != null && !(acceptChoices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
     * column name) that can be accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceptChoices} method.
     * </p>
     * 
     * @return Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
     *         example, a column name) that can be accepted.
     */
    public final List<AcceptChoice> acceptChoices() {
        return acceptChoices;
    }

    /**
     * <p>
     * Specifies the rule (or the conditions) under which a prediction can be accepted.
     * </p>
     * 
     * @return Specifies the rule (or the conditions) under which a prediction can be accepted.
     */
    public final AcceptRule acceptRule() {
        return acceptRule;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *         populated if not provided.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the asset.
     * </p>
     * 
     * @return The identifier of the asset.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The revision that is to be made to the asset.
     * </p>
     * 
     * @return The revision that is to be made to the asset.
     */
    public final String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceptChoices() ? acceptChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceptRule());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPredictionsRequest)) {
            return false;
        }
        AcceptPredictionsRequest other = (AcceptPredictionsRequest) obj;
        return hasAcceptChoices() == other.hasAcceptChoices() && Objects.equals(acceptChoices(), other.acceptChoices())
                && Objects.equals(acceptRule(), other.acceptRule()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptPredictionsRequest").add("AcceptChoices", hasAcceptChoices() ? acceptChoices() : null)
                .add("AcceptRule", acceptRule()).add("ClientToken", clientToken()).add("DomainIdentifier", domainIdentifier())
                .add("Identifier", identifier()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptChoices":
            return Optional.ofNullable(clazz.cast(acceptChoices()));
        case "acceptRule":
            return Optional.ofNullable(clazz.cast(acceptRule()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptPredictionsRequest, T> g) {
        return obj -> g.apply((AcceptPredictionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcceptPredictionsRequest> {
        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be accepted.
         * </p>
         * 
         * @param acceptChoices
         *        Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
         *        example, a column name) that can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptChoices(Collection<AcceptChoice> acceptChoices);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be accepted.
         * </p>
         * 
         * @param acceptChoices
         *        Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
         *        example, a column name) that can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptChoices(AcceptChoice... acceptChoices);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be accepted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AcceptChoice.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.AcceptChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AcceptChoice.Builder#build()} is called immediately and
         * its result is passed to {@link #acceptChoices(List<AcceptChoice>)}.
         * 
         * @param acceptChoices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AcceptChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceptChoices(java.util.Collection<AcceptChoice>)
         */
        Builder acceptChoices(Consumer<AcceptChoice.Builder>... acceptChoices);

        /**
         * <p>
         * Specifies the rule (or the conditions) under which a prediction can be accepted.
         * </p>
         * 
         * @param acceptRule
         *        Specifies the rule (or the conditions) under which a prediction can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptRule(AcceptRule acceptRule);

        /**
         * <p>
         * Specifies the rule (or the conditions) under which a prediction can be accepted.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceptRule.Builder} avoiding the need to
         * create one manually via {@link AcceptRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceptRule.Builder#build()} is called immediately and its result
         * is passed to {@link #acceptRule(AcceptRule)}.
         * 
         * @param acceptRule
         *        a consumer that will call methods on {@link AcceptRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceptRule(AcceptRule)
         */
        default Builder acceptRule(Consumer<AcceptRule.Builder> acceptRule) {
            return acceptRule(AcceptRule.builder().applyMutation(acceptRule).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         * populated if not provided.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         *        populated if not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the asset.
         * </p>
         * 
         * @param identifier
         *        The identifier of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The revision that is to be made to the asset.
         * </p>
         * 
         * @param revision
         *        The revision that is to be made to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<AcceptChoice> acceptChoices = DefaultSdkAutoConstructList.getInstance();

        private AcceptRule acceptRule;

        private String clientToken;

        private String domainIdentifier;

        private String identifier;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPredictionsRequest model) {
            super(model);
            acceptChoices(model.acceptChoices);
            acceptRule(model.acceptRule);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            revision(model.revision);
        }

        public final List<AcceptChoice.Builder> getAcceptChoices() {
            List<AcceptChoice.Builder> result = AcceptChoicesCopier.copyToBuilder(this.acceptChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceptChoices(Collection<AcceptChoice.BuilderImpl> acceptChoices) {
            this.acceptChoices = AcceptChoicesCopier.copyFromBuilder(acceptChoices);
        }

        @Override
        public final Builder acceptChoices(Collection<AcceptChoice> acceptChoices) {
            this.acceptChoices = AcceptChoicesCopier.copy(acceptChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptChoices(AcceptChoice... acceptChoices) {
            acceptChoices(Arrays.asList(acceptChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptChoices(Consumer<AcceptChoice.Builder>... acceptChoices) {
            acceptChoices(Stream.of(acceptChoices).map(c -> AcceptChoice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AcceptRule.Builder getAcceptRule() {
            return acceptRule != null ? acceptRule.toBuilder() : null;
        }

        public final void setAcceptRule(AcceptRule.BuilderImpl acceptRule) {
            this.acceptRule = acceptRule != null ? acceptRule.build() : null;
        }

        @Override
        public final Builder acceptRule(AcceptRule acceptRule) {
            this.acceptRule = acceptRule;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptPredictionsRequest build() {
            return new AcceptPredictionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
