/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionTargetRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateSubscriptionTargetRequest.Builder, CreateSubscriptionTargetRequest> {
    private static final SdkField<List<String>> APPLICABLE_ASSET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicableAssetTypes")
            .getter(getter(CreateSubscriptionTargetRequest::applicableAssetTypes))
            .setter(setter(Builder::applicableAssetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableAssetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHORIZED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authorizedPrincipals")
            .getter(getter(CreateSubscriptionTargetRequest::authorizedPrincipals))
            .setter(setter(Builder::authorizedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSubscriptionTargetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateSubscriptionTargetRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(CreateSubscriptionTargetRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> MANAGE_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manageAccessRole").getter(getter(CreateSubscriptionTargetRequest::manageAccessRole))
            .setter(setter(Builder::manageAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRole").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSubscriptionTargetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(CreateSubscriptionTargetRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<List<SubscriptionTargetForm>> SUBSCRIPTION_TARGET_CONFIG_FIELD = SdkField
            .<List<SubscriptionTargetForm>> builder(MarshallingType.LIST)
            .memberName("subscriptionTargetConfig")
            .getter(getter(CreateSubscriptionTargetRequest::subscriptionTargetConfig))
            .setter(setter(Builder::subscriptionTargetConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscriptionTargetForm> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscriptionTargetForm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateSubscriptionTargetRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_ASSET_TYPES_FIELD,
            AUTHORIZED_PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD,
            MANAGE_ACCESS_ROLE_FIELD, NAME_FIELD, PROVIDER_FIELD, SUBSCRIPTION_TARGET_CONFIG_FIELD, TYPE_FIELD));

    private final List<String> applicableAssetTypes;

    private final List<String> authorizedPrincipals;

    private final String clientToken;

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final String manageAccessRole;

    private final String name;

    private final String provider;

    private final List<SubscriptionTargetForm> subscriptionTargetConfig;

    private final String type;

    private CreateSubscriptionTargetRequest(BuilderImpl builder) {
        super(builder);
        this.applicableAssetTypes = builder.applicableAssetTypes;
        this.authorizedPrincipals = builder.authorizedPrincipals;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.manageAccessRole = builder.manageAccessRole;
        this.name = builder.name;
        this.provider = builder.provider;
        this.subscriptionTargetConfig = builder.subscriptionTargetConfig;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicableAssetTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicableAssetTypes() {
        return applicableAssetTypes != null && !(applicableAssetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset types that can be included in the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicableAssetTypes} method.
     * </p>
     * 
     * @return The asset types that can be included in the subscription target.
     */
    public final List<String> applicableAssetTypes() {
        return applicableAssetTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedPrincipals() {
        return authorizedPrincipals != null && !(authorizedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorized principals of the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedPrincipals} method.
     * </p>
     * 
     * @return The authorized principals of the subscription target.
     */
    public final List<String> authorizedPrincipals() {
        return authorizedPrincipals;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which subscription target is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which subscription target is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment in which subscription target is created.
     * </p>
     * 
     * @return The ID of the environment in which subscription target is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The manage access role that is used to create the subscription target.
     * </p>
     * 
     * @return The manage access role that is used to create the subscription target.
     */
    public final String manageAccessRole() {
        return manageAccessRole;
    }

    /**
     * <p>
     * The name of the subscription target.
     * </p>
     * 
     * @return The name of the subscription target.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The provider of the subscription target.
     * </p>
     * 
     * @return The provider of the subscription target.
     */
    public final String provider() {
        return provider;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscriptionTargetConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubscriptionTargetConfig() {
        return subscriptionTargetConfig != null && !(subscriptionTargetConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptionTargetConfig} method.
     * </p>
     * 
     * @return The configuration of the subscription target.
     */
    public final List<SubscriptionTargetForm> subscriptionTargetConfig() {
        return subscriptionTargetConfig;
    }

    /**
     * <p>
     * The type of the subscription target.
     * </p>
     * 
     * @return The type of the subscription target.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicableAssetTypes() ? applicableAssetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedPrincipals() ? authorizedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(manageAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionTargetRequest)) {
            return false;
        }
        CreateSubscriptionTargetRequest other = (CreateSubscriptionTargetRequest) obj;
        return hasApplicableAssetTypes() == other.hasApplicableAssetTypes()
                && Objects.equals(applicableAssetTypes(), other.applicableAssetTypes())
                && hasAuthorizedPrincipals() == other.hasAuthorizedPrincipals()
                && Objects.equals(authorizedPrincipals(), other.authorizedPrincipals())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(manageAccessRole(), other.manageAccessRole()) && Objects.equals(name(), other.name())
                && Objects.equals(provider(), other.provider())
                && hasSubscriptionTargetConfig() == other.hasSubscriptionTargetConfig()
                && Objects.equals(subscriptionTargetConfig(), other.subscriptionTargetConfig())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionTargetRequest")
                .add("ApplicableAssetTypes", hasApplicableAssetTypes() ? applicableAssetTypes() : null)
                .add("AuthorizedPrincipals", hasAuthorizedPrincipals() ? authorizedPrincipals() : null)
                .add("ClientToken", clientToken()).add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("ManageAccessRole", manageAccessRole())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Provider", provider())
                .add("SubscriptionTargetConfig", hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicableAssetTypes":
            return Optional.ofNullable(clazz.cast(applicableAssetTypes()));
        case "authorizedPrincipals":
            return Optional.ofNullable(clazz.cast(authorizedPrincipals()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "manageAccessRole":
            return Optional.ofNullable(clazz.cast(manageAccessRole()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "subscriptionTargetConfig":
            return Optional.ofNullable(clazz.cast(subscriptionTargetConfig()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionTargetRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriptionTargetRequest> {
        /**
         * <p>
         * The asset types that can be included in the subscription target.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The asset types that can be included in the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(Collection<String> applicableAssetTypes);

        /**
         * <p>
         * The asset types that can be included in the subscription target.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The asset types that can be included in the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(String... applicableAssetTypes);

        /**
         * <p>
         * The authorized principals of the subscription target.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorized principals of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(Collection<String> authorizedPrincipals);

        /**
         * <p>
         * The authorized principals of the subscription target.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorized principals of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(String... authorizedPrincipals);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which subscription target is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which subscription target is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment in which subscription target is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment in which subscription target is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The manage access role that is used to create the subscription target.
         * </p>
         * 
         * @param manageAccessRole
         *        The manage access role that is used to create the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageAccessRole(String manageAccessRole);

        /**
         * <p>
         * The name of the subscription target.
         * </p>
         * 
         * @param name
         *        The name of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The provider of the subscription target.
         * </p>
         * 
         * @param provider
         *        The provider of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptionTargetConfig(List<SubscriptionTargetForm>)}.
         * 
         * @param subscriptionTargetConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionTargetConfig(java.util.Collection<SubscriptionTargetForm>)
         */
        Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig);

        /**
         * <p>
         * The type of the subscription target.
         * </p>
         * 
         * @param type
         *        The type of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<String> applicableAssetTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorizedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String domainIdentifier;

        private String environmentIdentifier;

        private String manageAccessRole;

        private String name;

        private String provider;

        private List<SubscriptionTargetForm> subscriptionTargetConfig = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionTargetRequest model) {
            super(model);
            applicableAssetTypes(model.applicableAssetTypes);
            authorizedPrincipals(model.authorizedPrincipals);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            manageAccessRole(model.manageAccessRole);
            name(model.name);
            provider(model.provider);
            subscriptionTargetConfig(model.subscriptionTargetConfig);
            type(model.type);
        }

        public final Collection<String> getApplicableAssetTypes() {
            if (applicableAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return applicableAssetTypes;
        }

        public final void setApplicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
        }

        @Override
        public final Builder applicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableAssetTypes(String... applicableAssetTypes) {
            applicableAssetTypes(Arrays.asList(applicableAssetTypes));
            return this;
        }

        public final Collection<String> getAuthorizedPrincipals() {
            if (authorizedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedPrincipals;
        }

        public final void setAuthorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
        }

        @Override
        public final Builder authorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipals(String... authorizedPrincipals) {
            authorizedPrincipals(Arrays.asList(authorizedPrincipals));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getManageAccessRole() {
            return manageAccessRole;
        }

        public final void setManageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
        }

        @Override
        public final Builder manageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<SubscriptionTargetForm.Builder> getSubscriptionTargetConfig() {
            List<SubscriptionTargetForm.Builder> result = SubscriptionTargetFormsCopier
                    .copyToBuilder(this.subscriptionTargetConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionTargetConfig(Collection<SubscriptionTargetForm.BuilderImpl> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copyFromBuilder(subscriptionTargetConfig);
        }

        @Override
        public final Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copy(subscriptionTargetConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig) {
            subscriptionTargetConfig(Arrays.asList(subscriptionTargetConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig) {
            subscriptionTargetConfig(Stream.of(subscriptionTargetConfig)
                    .map(c -> SubscriptionTargetForm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionTargetRequest build() {
            return new CreateSubscriptionTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
